/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseVersion4;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.exception.LicenseLimitReachedException;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.ReleasePersistenceInterceptor$;
import com.xebialabs.xlrelease.repository.sql.WorkflowInterceptorLogic;
import com.xebialabs.xlrelease.repository.sql.WorkflowTaskValidator;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\t\u0002\u0011)\u0019!C\u0001\u000b\"AA\n\u0001B\u0001B\u0003%a\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\"\u0002.\u0001\t\u0003Y\u0006\"B1\u0001\t\u0003\u0012\u0007\"B6\u0001\t\u0003b\u0007\"\u00028\u0001\t\u0013y\u0007\"\u0002:\u0001\t\u0013\u0019\b\"B;\u0001\t\u00131\b\"\u0002=\u0001\t\u0013I\b\"B>\u0001\t\u0013a\b\"\u0002@\u0001\t\u0013y\bbBA\u0002\u0001\u0011%\u0011Q\u0001\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aq!!\u0006\u0001\t\u0013\t9bB\u0004\u0002ZmA\t!a\u0017\u0007\riY\u0002\u0012AA/\u0011\u0019QF\u0003\"\u0001\u0002f!I\u0011q\r\u000bC\u0002\u0013%\u0011\u0011\u000e\u0005\t\u0003c\"\u0002\u0015!\u0003\u0002l!I\u00111\u000f\u000bC\u0002\u0013%\u0011Q\u000f\u0005\t\u0003\u0013#\u0002\u0015!\u0003\u0002x\ti\"+\u001a7fCN,\u0007+\u001a:tSN$XM\\2f\u0013:$XM]2faR|'O\u0003\u0002\u001d;\u0005\u00191/\u001d7\u000b\u0005yy\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011\u0001%I\u0001\nq2\u0014X\r\\3bg\u0016T!AI\u0012\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0013\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u00019s&O\u001f\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013\u0001\u00027b]\u001eT\u0011\u0001L\u0001\u0005U\u00064\u0018-\u0003\u0002/S\t1qJ\u00196fGR\u00042\u0001M\u00194\u001b\u0005i\u0012B\u0001\u001a\u001e\u0005Y\u0001VM]:jgR,gnY3J]R,'oY3qi>\u0014\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c \u0003\u0019!w.\\1j]&\u0011\u0001(\u000e\u0002\b%\u0016dW-Y:f!\tQ4(D\u0001\u001c\u0013\ta4DA\u000bX_J\\g\r\\8x)\u0006\u001c8NV1mS\u0012\fGo\u001c:\u0011\u0005ir\u0014BA \u001c\u0005a9vN]6gY><\u0018J\u001c;fe\u000e,\u0007\u000f^8s\u0019><\u0017nY\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bC\u0001\u0019C\u0013\t\u0019UDA\tSK2,\u0017m]3SKB|7/\u001b;pef\fq\u0002^1tWB+'o]5ti\u0016t7-Z\u000b\u0002\rB\u0011qIS\u0007\u0002\u0011*\u0011\u0011jG\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0002L\u0011\nyA+Y:l!\u0016\u00148/[:uK:\u001cW-\u0001\tuCN\\\u0007+\u001a:tSN$XM\\2fA\u0005\u0001bm\u001c7eKJ\u0014V\r]8tSR|'/\u001f\t\u0003a=K!\u0001U\u000f\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\u0018A\u00047jG\u0016t7/Z*feZL7-\u001a\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bqa]3sm&\u001cWM\u0003\u0002XC\u00059A.[2f]N,\u0017BA-U\u00059a\u0015nY3og\u0016\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD#\u0002/^=~\u0003\u0007C\u0001\u001e\u0001\u0011\u0015\u0001e\u00011\u0001B\u0011\u0015!e\u00011\u0001G\u0011\u0015ie\u00011\u0001O\u0011\u0015\tf\u00011\u0001S\u0003!ygn\u0011:fCR,GCA2j!\t!w-D\u0001f\u0015\u00051\u0017!B:dC2\f\u0017B\u00015f\u0005\u0011)f.\u001b;\t\u000b)<\u0001\u0019A\u001a\u0002\u0005\rL\u0017\u0001C8o+B$\u0017\r^3\u0015\u0005\rl\u0007\"\u00026\t\u0001\u0004\u0019\u0014\u0001E8o\u0007J,\u0017\r^3PeV\u0003H-\u0019;f)\t\u0019\u0007\u000fC\u0003r\u0013\u0001\u00071'A\u0004sK2,\u0017m]3\u00027Y\fG.\u001b3bi\u0016$UMZ1vYR$\u0016M]4fi\u001a{G\u000eZ3s)\t\u0019G\u000fC\u0003r\u0015\u0001\u00071'\u0001\u000ewC2LG-\u0019;f/>\u00148N\u001a7poB\u0013x\u000e]3si&,7\u000f\u0006\u0002do\")\u0011o\u0003a\u0001g\u0005Ab/\u00197jI\u0006$XMT8u\u0003J{w\u000e^,pe.4Gn\\<\u0015\u0005\rT\b\"B9\r\u0001\u0004\u0019\u0014A\b<bY&$\u0017\r^3O_\u0012\u000b7\u000f\u001b2pCJ$gi\u001c:X_J\\g\r\\8x)\t\u0019W\u0010C\u0003r\u001b\u0001\u00071'\u0001\u0013wC2LG-\u0019;f\u001d>dunY6UCN\\\u0007K]3tK:$hi\u001c:X_J\\g\r\\8x)\r\u0019\u0017\u0011\u0001\u0005\u0006c:\u0001\raM\u0001!m\u0006d\u0017\u000eZ1uK:{'+[:l!J|g-\u001b7f\r>\u0014xk\u001c:lM2|w\u000fF\u0002d\u0003\u000fAQ!]\bA\u0002M\n1F^1mS\u0012\fG/\u001a(p+:\u001cX\u000f\u001d9peR,G\rV1tWB\u0013Xm]3oi\u001a{'oV8sW\u001adwn\u001e\u000b\u0004G\u00065\u0001\"B9\u0011\u0001\u0004\u0019\u0014A\t<bY&$\u0017\r^3U_R\fGNT8PM^{'o\u001b4m_^$V-\u001c9mCR,7\u000fF\u0002d\u0003'AQ!]\tA\u0002M\n\u0011cZ3u\u0019&\u001cWM\\:f\u000b\u0012LG/[8o)\t\tI\u0002\u0005\u0003\u0002\u001c\u0005%b\u0002BA\u000f\u0003K\u00012!a\bf\u001b\t\t\tCC\u0002\u0002$\u0015\na\u0001\u0010:p_Rt\u0014bAA\u0014K\u00061\u0001K]3eK\u001aLA!a\u000b\u0002.\t11\u000b\u001e:j]\u001eT1!a\nfQ\r\u0001\u0011\u0011\u0007\t\u0005\u0003g\ty$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0007q\tYDC\u0002\u0002>}\t!\u0001\u001a2\n\t\u0005\u0005\u0013Q\u0007\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\"\u001a\u0001!!\u0012\u0011\t\u0005\u001d\u0013QK\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005Q1\u000f^3sK>$\u0018\u0010]3\u000b\t\u0005=\u0013\u0011K\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u00111K\u0001\u0004_J<\u0017\u0002BA,\u0003\u0013\u0012\u0011bQ8na>tWM\u001c;\u0002;I+G.Z1tKB+'o]5ti\u0016t7-Z%oi\u0016\u00148-\u001a9u_J\u0004\"A\u000f\u000b\u0014\u0007Q\ty\u0006E\u0002e\u0003CJ1!a\u0019f\u0005\u0019\te.\u001f*fMR\u0011\u00111L\u0001\"\u001b\u0006CvLT(`/>\u00136J\u0012'P/~#V)\u0014)M\u0003R+5kX!M\u0019>;V\tR\u000b\u0003\u0003W\u00022\u0001ZA7\u0013\r\ty'\u001a\u0002\u0004\u0013:$\u0018AI'B1~sujX,P%.3EjT,`)\u0016k\u0005\u000bT!U\u000bN{\u0016\t\u0014'P/\u0016#\u0005%A\u000fV\u001dJ+5\u000b\u0016*J\u0007R+Ei\u0018'J\u0007\u0016s5+R0F\t&#\u0016j\u0014(T+\t\t9\b\u0005\u0004\u0002z\u0005\r\u0015\u0011\u0004\b\u0005\u0003w\nyH\u0004\u0003\u0002 \u0005u\u0014\"\u00014\n\u0007\u0005\u0005U-A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0015q\u0011\u0002\u0004'\u0016\f(bAAAK\u0006qRK\u0014*F'R\u0013\u0016j\u0011+F\t~c\u0015jQ#O'\u0016{V\tR%U\u0013>s5\u000b\t")
public class ReleasePersistenceInterceptor
implements PersistenceInterceptor<Release>,
WorkflowTaskValidator,
WorkflowInterceptorLogic {
    private final ReleaseRepository releaseRepository;
    private final TaskPersistence taskPersistence;
    private final FolderRepository folderRepository;
    private final LicenseService licenseService;

    @Override
    public void updateWorkflowProperties(Release release) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, release);
    }

    @Override
    public void updateWorkflowProperties(Task task) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateWorkflowTaskCount(Release release) {
        WorkflowTaskValidator.validateWorkflowTaskCount$(this, release);
    }

    public void onDelete(String x$1) {
        super.onDelete(x$1);
    }

    public void afterCreate(ConfigurationItem x$1) {
        super.afterCreate(x$1);
    }

    public void afterUpdate(ConfigurationItem x$1) {
        super.afterUpdate(x$1);
    }

    public void afterDelete(String x$1) {
        super.afterDelete(x$1);
    }

    @Override
    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public void onCreate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    public void onUpdate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    private void onCreateOrUpdate(Release release) {
        this.validateTotalNoOfWorkflowTemplates(release);
        this.updateWorkflowProperties(release);
        this.validateDefaultTargetFolder(release);
        this.validateWorkflowProperties(release);
    }

    private void validateDefaultTargetFolder(Release release) {
        boolean defaultTargetFolderIdIsEmpty;
        boolean doesNotAllowTargetFolderOverride = !release.getAllowTargetFolderOverride();
        String defaultTargetFolderId = release.getDefaultTargetFolderId();
        boolean bl = defaultTargetFolderIdIsEmpty = !StringUtils.hasText((String)defaultTargetFolderId);
        if (release.isTemplate() && doesNotAllowTargetFolderOverride && defaultTargetFolderIdIsEmpty) {
            String msg = "Override of the target folder is not allowed, but default target folder is not provided for release with ID [" + release.getId() + "]";
            throw new Checks.IncorrectArgumentException(msg, new Object[0]);
        }
        if (!defaultTargetFolderIdIsEmpty) {
            Option optionalFolder = this.folderRepository.findById(defaultTargetFolderId, 1);
            if (optionalFolder.isEmpty()) {
                throw new Checks.IncorrectArgumentException("Cannot find folder with id [" + defaultTargetFolderId + "]", new Object[0]);
            }
            return;
        }
    }

    private void validateWorkflowProperties(Release release) {
        this.validateNotARootWorkflow(release);
        this.validateNoDashboardForWorkflow(release);
        this.validateNoRiskProfileForWorkflow(release);
        this.validateNoLockTaskPresentForWorkflow(release);
        this.validateNoUnsupportedTaskPresentForWorkflow(release);
        this.validateWorkflowTaskCount(release);
    }

    private void validateNotARootWorkflow(Release release) {
        String parentFolder = Ids.getParentId((String)release.getId());
        if (release.isWorkflow()) {
            String string = parentFolder;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new Checks.IncorrectArgumentException("Workflows can be created only inside a folder", new Object[0]);
            }
        }
    }

    private void validateNoDashboardForWorkflow(Release release) {
        if (release.isWorkflow()) {
            boolean hasDashboards = CollectionConverters$.MODULE$.ListHasAsScala(release.getExtensions()).asScala().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReleasePersistenceInterceptor.$anonfun$validateNoDashboardForWorkflow$1(x$1)));
            if (hasDashboards) {
                throw new Checks.IncorrectArgumentException("Dashboards are not supported for workflows", new Object[0]);
            }
            return;
        }
    }

    private void validateNoLockTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoLockTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateNoRiskProfileForWorkflow(Release release) {
        if (release.isWorkflow() && release.getRiskProfile() != null) {
            throw new Checks.IncorrectArgumentException("Risk profile is not supported for workflows", new Object[0]);
        }
    }

    private void validateNoUnsupportedTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoUnsupportedTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateTotalNoOfWorkflowTemplates(Release release) {
        if (release.isTemplate() && release.isWorkflow()) {
            String licenseEdition = this.getLicenseEdition();
            if (!ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$UNRESTRICTED_LICENSE_EDITIONS().contains((Object)licenseEdition)) {
                int totalWorkflowTemplates = this.releaseRepository.countTemplatesByKind(ReleaseKind.WORKFLOW);
                if (totalWorkflowTemplates >= ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$MAX_NO_WORKFLOW_TEMPLATES_ALLOWED()) {
                    throw new LicenseLimitReachedException("License limit reached. You have exceeded the limit on the number of workflow templates supported with your license.");
                }
                return;
            }
            return;
        }
    }

    private String getLicenseEdition() {
        License license = this.licenseService.getLicense();
        if (license.isDummyLicense()) {
            return LicenseVersion4.Edition4.Unregistered.name();
        }
        return this.licenseService.getLicense().getStringValue(LicenseProperty.EDITION);
    }

    public static final /* synthetic */ boolean $anonfun$validateNoDashboardForWorkflow$1(ReleaseExtension x$1) {
        return x$1 instanceof Dashboard;
    }

    public ReleasePersistenceInterceptor(ReleaseRepository releaseRepository, TaskPersistence taskPersistence, FolderRepository folderRepository, LicenseService licenseService) {
        this.releaseRepository = releaseRepository;
        this.taskPersistence = taskPersistence;
        this.folderRepository = folderRepository;
        this.licenseService = licenseService;
        WorkflowTaskValidator.$init$(this);
        WorkflowInterceptorLogic.$init$(this);
        releaseRepository.registerPersistenceInterceptor((PersistenceInterceptor)this);
    }
}

