/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitCommit;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHCommit {
    private GHRepository owner;
    private ShortInfo commit;
    String url;
    String html_url;
    String sha;
    List<File> files;
    Stats stats;
    List<Parent> parents;
    User author;
    User committer;

    public GHCommit() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="acceptable")
    GHCommit(ShortInfo shortInfo) {
        this.commit = shortInfo;
        this.owner = this.commit.getOwner();
        this.html_url = this.commit.getHtmlUrl();
        this.sha = this.commit.getSha();
        this.url = this.commit.getUrl();
        this.parents = this.commit.getParents();
    }

    public ShortInfo getCommitShortInfo() throws IOException {
        if (this.commit == null) {
            this.populate();
        }
        return this.commit;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getOwner() {
        return this.owner;
    }

    public int getLinesChanged() throws IOException {
        this.populate();
        return this.stats.total;
    }

    public int getLinesAdded() throws IOException {
        this.populate();
        return this.stats.additions;
    }

    public int getLinesDeleted() throws IOException {
        this.populate();
        return this.stats.deletions;
    }

    public GHTree getTree() throws IOException {
        return this.owner.getTree(this.getCommitShortInfo().getTreeSHA1());
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public String getSHA1() {
        return this.sha;
    }

    public URL getUrl() {
        return GitHubClient.parseURL(this.url);
    }

    public List<File> getFiles() throws IOException {
        this.populate();
        return this.files != null ? Collections.unmodifiableList(this.files) : Collections.emptyList();
    }

    public List<String> getParentSHA1s() {
        if (this.parents == null || this.parents.size() == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return GHCommit.this.parents.get((int)index).sha;
            }

            @Override
            public int size() {
                return GHCommit.this.parents.size();
            }
        };
    }

    public List<GHCommit> getParents() throws IOException {
        this.populate();
        ArrayList<GHCommit> r = new ArrayList<GHCommit>();
        for (String sha1 : this.getParentSHA1s()) {
            r.add(this.owner.getCommit(sha1));
        }
        return r;
    }

    public GHUser getAuthor() throws IOException {
        this.populate();
        return this.resolveUser(this.author);
    }

    public Date getAuthoredDate() throws IOException {
        return this.getCommitShortInfo().getAuthoredDate();
    }

    public GHUser getCommitter() throws IOException {
        this.populate();
        return this.resolveUser(this.committer);
    }

    public Date getCommitDate() throws IOException {
        return this.getCommitShortInfo().getCommitDate();
    }

    private GHUser resolveUser(User author) throws IOException {
        if (author == null || author.login == null) {
            return null;
        }
        return this.owner.root().getUser(author.login);
    }

    @Preview(value={Previews.GROOT})
    public PagedIterable<GHPullRequest> listPullRequests() {
        return ((Requester)((Requester)this.owner.root().createRequest().withPreview(Previews.GROOT)).withUrlPath(String.format("/repos/%s/%s/commits/%s/pulls", this.owner.getOwnerName(), this.owner.getName(), this.sha), new String[0])).toIterable(GHPullRequest[].class, item -> item.wrapUp(this.owner));
    }

    @Preview(value={Previews.GROOT})
    public PagedIterable<GHBranch> listBranchesWhereHead() throws IOException {
        return ((Requester)((Requester)this.owner.root().createRequest().withPreview(Previews.GROOT)).withUrlPath(String.format("/repos/%s/%s/commits/%s/branches-where-head", this.owner.getOwnerName(), this.owner.getName(), this.sha), new String[0])).toIterable(GHBranch[].class, item -> item.wrap(this.owner));
    }

    public PagedIterable<GHCommitComment> listComments() {
        return this.owner.listCommitComments(this.sha);
    }

    public GHCommitComment createComment(String body, String path, Integer line, Integer position) throws IOException {
        GHCommitComment r = ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).with("body", body)).with("path", path)).with("line", line)).with("position", position)).withUrlPath(String.format("/repos/%s/%s/commits/%s/comments", this.owner.getOwnerName(), this.owner.getName(), this.sha), new String[0])).fetch(GHCommitComment.class);
        return r.wrap(this.owner);
    }

    public GHCommitComment createComment(String body) throws IOException {
        return this.createComment(body, null, null, null);
    }

    public PagedIterable<GHCommitStatus> listStatuses() throws IOException {
        return this.owner.listCommitStatuses(this.sha);
    }

    public GHCommitStatus getLastStatus() throws IOException {
        return this.owner.getLastCommitStatus(this.sha);
    }

    @Preview(value={Previews.ANTIOPE})
    public PagedIterable<GHCheckRun> getCheckRuns() throws IOException {
        return this.owner.getCheckRuns(this.sha);
    }

    void populate() throws IOException {
        if (this.files == null && this.stats == null) {
            ((Requester)this.owner.root().createRequest().withUrlPath(this.owner.getApiTailUrl("commits/" + this.sha), new String[0])).fetchInto(this);
        }
    }

    GHCommit wrapUp(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    static class User {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String avatar_url;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String gravatar_id;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        int id;
        String login;

        User() {
        }
    }

    public static class Parent {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
        String sha;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="It's being initialized by JSON deserialization")
    public static class File {
        String status;
        int changes;
        int additions;
        int deletions;
        String raw_url;
        String blob_url;
        String sha;
        String patch;
        String filename;
        String previous_filename;

        public int getLinesChanged() {
            return this.changes;
        }

        public int getLinesAdded() {
            return this.additions;
        }

        public int getLinesDeleted() {
            return this.deletions;
        }

        public String getStatus() {
            return this.status;
        }

        @SuppressFBWarnings(value={"NM_CONFUSING"}, justification="It's a part of the library's API and cannot be renamed")
        public String getFileName() {
            return this.filename;
        }

        public String getPreviousFilename() {
            return this.previous_filename;
        }

        public String getPatch() {
            return this.patch;
        }

        public URL getRawUrl() {
            return GitHubClient.parseURL(this.raw_url);
        }

        public URL getBlobUrl() {
            return GitHubClient.parseURL(this.blob_url);
        }

        public String getSha() {
            return this.sha;
        }
    }

    public static class Stats {
        int total;
        int additions;
        int deletions;
    }

    @Deprecated
    public static class GHAuthor
    extends GitUser {
        public GHAuthor() {
        }

        public GHAuthor(GitUser user) {
            super(user);
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class ShortInfo
    extends GitCommit {
        private int comment_count = -1;

        public int getCommentCount() throws GHException {
            if (this.comment_count < 0) {
                throw new GHException("Not available on this endpoint.");
            }
            return this.comment_count;
        }

        public ShortInfo() {
        }

        ShortInfo(GitCommit commit) {
            super(commit);
        }

        @Override
        public List<String> getParentSHA1s() {
            List<String> shortInfoParents = super.getParentSHA1s();
            if (shortInfoParents == null) {
                throw new GHException("Not available on this endpoint. Try calling getParentSHA1s from outer class.");
            }
            return shortInfoParents;
        }
    }
}

