/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableTable;
import de.javakaffee.kryoserializers.guava.TableSerializerBase;

public class ImmutableTableSerializer<R, C, V>
extends TableSerializerBase<R, C, V, ImmutableTable<R, C, V>> {
    private static final boolean HANDLES_NULL = false;
    private static final boolean IMMUTABLE = true;

    public ImmutableTableSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, ImmutableTable<R, C, V> immutableTable) {
        super.writeTable(kryo, output, immutableTable);
    }

    public ImmutableTable<R, C, V> read(Kryo kryo, Input input, Class<? extends ImmutableTable<R, C, V>> type) {
        final ImmutableTable.Builder builder = ImmutableTable.builder();
        super.readTable(kryo, input, new TableSerializerBase.CellConsumer<R, C, V>(){

            @Override
            public void accept(R r, C c, V v) {
                builder.put(r, c, v);
            }
        });
        return builder.build();
    }

    public static void registerSerializers(Kryo kryo) {
        ImmutableTableSerializer serializer = new ImmutableTableSerializer();
        kryo.register(ImmutableTable.class, serializer);
        kryo.register(ImmutableTable.of().getClass(), serializer);
        kryo.register(ImmutableTable.of((Object)1, (Object)2, (Object)3).getClass(), serializer);
        kryo.register(ImmutableTable.builder().put((Object)"a", (Object)1, (Object)1).put((Object)"b", (Object)1, (Object)1).build().getClass(), serializer);
    }
}

