/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.XLReleaseBootstrapper;
import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions;
import com.xebialabs.xlrelease.XLReleaseSetup;
import java.time.Year;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseServer {
    private static final int DEFAULT_PORT = 5516;
    private static final Logger logger = LoggerFactory.getLogger(ReleaseServer.class);
    private static final String PRODUCT_RELEASE = XLReleaseBootstrapper.PRODUCT_DIGITALAI();
    private final XLReleaseServerLaunchOptions launchOptions;
    private final ServerConfigFile configFile;
    private boolean isConfigAndPasswordInitDone = false;

    public ReleaseServer(XLReleaseServerLaunchOptions launchOptions, ServerConfigFile configFile) {
        this.launchOptions = launchOptions;
        this.configFile = configFile;
    }

    public static void outputReleaseInfo() {
        ReleaseInfo releaseInfo = new ReleaseInfo("com/xebialabs/deployit/release.properties");
        logger.info("{} version {} (built at {})", new Object[]{PRODUCT_RELEASE, releaseInfo.getVersion(), releaseInfo.getDate()});
        logger.info("{} running with {} (version {}) from {}", new Object[]{PRODUCT_RELEASE, System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor")});
        logger.info("(c) 2012-{} Digital.ai.", (Object)Year.now().getValue());
        if (Environment.isDevelopment()) {
            logger.warn(" DEVELOPMENT MODE");
        }
    }

    public void prepareConfigs() {
        if (this.launchOptions.isDoSetup()) {
            this.startSetup();
            System.exit(0);
        } else {
            if (!this.configFile.exists()) {
                logger.warn("Configuration not found...");
                this.startSetup();
            }
            if (!this.isConfigAndPasswordInitDone) {
                this.loadConfigAndInitPasswordEncryptionKey();
            }
        }
    }

    private void startSetup() {
        ServerConfiguration serverDefaults = new ServerConfiguration();
        serverDefaults.setHttpPort(5516);
        logger.info("Initializing Repository");
        XLReleaseSetup setupWizard = new XLReleaseSetup(PRODUCT_RELEASE, this.configFile, this.launchOptions, serverDefaults);
        setupWizard.run();
    }

    private void loadConfigAndInitPasswordEncryptionKey() {
        ServerConfiguration config = this.configFile.loadConfig(false, false);
        String repositoryKeyStorePassword = this.launchOptions.getRepositoryKeystorePassword() != null ? this.launchOptions.getRepositoryKeystorePassword() : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            throw new RuntimeException("Could not load the encryption key. The server will not start.");
        }
        config.loadEncryptedPasswords();
        this.configFile.saveDirtyConfiguration(config);
        ServerConfiguration.setInstance((ServerConfiguration)config);
        XLReleaseServerLaunchOptions.setInstance(this.launchOptions);
        this.isConfigAndPasswordInitDone = true;
    }
}

