/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.environments.repository.EnvironmentLabelRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\u0006\r\u0001]A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006[\u0001!\tA\f\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006q\u0002!\t!\u001f\u0005\u0006{\u0002!\tA \u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002\u001e\u0001!I!a\b\u0003/\u0015sg/\u001b:p]6,g\u000e\u001e'bE\u0016d7+\u001a:wS\u000e,'BA\u0007\u000f\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0004\t\u0002\u0019\u0015tg/\u001b:p]6,g\u000e^:\u000b\u0005E\u0011\u0012!\u0003=me\u0016dW-Y:f\u0015\t\u0019B#A\u0005yK\nL\u0017\r\\1cg*\tQ#A\u0002d_6\u001c\u0001aE\u0002\u00011y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0019\u0013\u0001C4sSjTH.\u001a3\n\u0005\u0015\u0002#a\u0002'pO\u001eLgnZ\u0001\u001bK:4\u0018N]8o[\u0016tG\u000fT1cK2\u0014V\r]8tSR|'/\u001f\t\u0003Q-j\u0011!\u000b\u0006\u0003U9\t!B]3q_NLGo\u001c:z\u0013\ta\u0013F\u0001\u000eF]ZL'o\u001c8nK:$H*\u00192fYJ+\u0007o\\:ji>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0003_E\u0002\"\u0001\r\u0001\u000e\u00031AQA\n\u0002A\u0002\u001dB#AA\u001a\u0011\u0005QzT\"A\u001b\u000b\u0005Y:\u0014AC1o]>$\u0018\r^5p]*\u0011\u0001(O\u0001\bM\u0006\u001cGo\u001c:z\u0015\tQ4(A\u0003cK\u0006t7O\u0003\u0002={\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001?\u0003\ry'oZ\u0005\u0003\u0001V\u0012\u0011\"Q;u_^L'/\u001a3\u0002\u0019M,\u0017M]2i\u0019\u0006\u0014W\r\\:\u0015\u0005\r\u0013\u0006c\u0001#J\u00176\tQI\u0003\u0002G\u000f\u0006!Q\u000f^5m\u0015\u0005A\u0015\u0001\u00026bm\u0006L!AS#\u0003\t1K7\u000f\u001e\t\u0003\u0019Bk\u0011!\u0014\u0006\u0003\u001f9S!a\u0014\t\u0002\r\u0011|W.Y5o\u0013\t\tVJ\u0001\tF]ZL'o\u001c8nK:$H*\u00192fY\")1k\u0001a\u0001)\u00069RM\u001c<je>tW.\u001a8u\u0019\u0006\u0014W\r\u001c$jYR,'o\u001d\t\u0003+rk\u0011A\u0016\u0006\u0003/b\u000baAZ5mi\u0016\u0014(BA-[\u0003\t1\u0018G\u0003\u0002\\!\u0005\u0019\u0011\r]5\n\u0005u3&aF#om&\u0014xN\\7f]Rd\u0015MY3m\r&dG/\u001a:tQ\t\u0019q\f\u0005\u0002aM6\t\u0011M\u0003\u00027E*\u00111\rZ\u0001\b[\u0016$(/[2t\u0015\t)G#\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\t9\u0017MA\u0003US6,G-A\u0007gS:$G*\u00192fY\nK\u0018\n\u001a\u000b\u0003\u0017*DQa\u001b\u0003A\u00021\f!#\u001a8wSJ|g.\\3oi2\u000b'-\u001a7JIB\u0011Q\u000e\u001e\b\u0003]J\u0004\"a\u001c\u000e\u000e\u0003AT!!\u001d\f\u0002\rq\u0012xn\u001c;?\u0013\t\u0019($\u0001\u0004Qe\u0016$WMZ\u0005\u0003kZ\u0014aa\u0015;sS:<'BA:\u001bQ\t!q,A\u0006de\u0016\fG/\u001a'bE\u0016dGCA&{\u0011\u0015YX\u00011\u0001L\u0003A)gN^5s_:lWM\u001c;MC\n,G\u000e\u000b\u0002\u0006?\u0006YQ\u000f\u001d3bi\u0016d\u0015MY3m)\tYu\u0010C\u0003|\r\u0001\u00071\n\u000b\u0002\u0007?\u0006YA-\u001a7fi\u0016d\u0015MY3m)\u0011\t9!!\u0004\u0011\u0007e\tI!C\u0002\u0002\fi\u0011A!\u00168ji\")1n\u0002a\u0001Y\"\u0012qaX\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011qAA\u000b\u0011\u0015Y\b\u00021\u0001L\u000351\u0018\r\\5eCR,G+\u001b;mKR!\u0011qAA\u000e\u0011\u0015Y\u0018\u00021\u0001L\u000351\u0018\r\\5eCR,7i\u001c7peR!\u0011qAA\u0011\u0011\u0019\t\u0019C\u0003a\u0001Y\u0006)1m\u001c7pe\"\u001a\u0001!a\n\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f<\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003c\tYCA\u0004TKJ4\u0018nY3")
public class EnvironmentLabelService
implements Logging {
    private final EnvironmentLabelRepository environmentLabelRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentLabelService environmentLabelService = this;
        synchronized (environmentLabelService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public List<EnvironmentLabel> searchLabels(EnvironmentLabelFilters environmentLabelFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.environmentLabelRepository.search(environmentLabelFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public EnvironmentLabel findLabelById(String environmentLabelId) {
        return this.environmentLabelRepository.findById(environmentLabelId);
    }

    @Timed
    public EnvironmentLabel createLabel(EnvironmentLabel environmentLabel) {
        this.logger().debug((Function0 & Serializable)() -> "Creating a new environment label");
        this.validate(environmentLabel);
        return this.environmentLabelRepository.create(environmentLabel);
    }

    @Timed
    public EnvironmentLabel updateLabel(EnvironmentLabel environmentLabel) {
        this.logger().debug((Function0 & Serializable)() -> "Updating environment label [" + environmentLabel + "]");
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentLabel.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environmentLabel);
        return this.environmentLabelRepository.update(environmentLabel);
    }

    @Timed
    public void deleteLabel(String environmentLabelId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting environment label [" + environmentLabelId + "]");
        this.environmentLabelRepository.delete(environmentLabelId);
    }

    private void validate(EnvironmentLabel environmentLabel) {
        this.validateTitle(environmentLabel);
        this.validateColor(environmentLabel.getColor());
    }

    private void validateTitle(EnvironmentLabel environmentLabel) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentLabel.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateColor(String color) {
        if (!Pattern.compile("^#([A-Fa-f0-9]{6})$").matcher(color).matches()) {
            throw new Checks.IncorrectArgumentException("Invalid color pattern '" + color + "'", new Object[0]);
        }
    }

    @Autowired
    public EnvironmentLabelService(EnvironmentLabelRepository environmentLabelRepository) {
        this.environmentLabelRepository = environmentLabelRepository;
        Logging.$init$((Logging)this);
    }
}

