/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.RemoveTriggeredReleaseCondition;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.repository.TriggerPersistenceHelper$;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggeredReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\tea\u0001B\t\u0013\u0001uA\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003I\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!9\u0011q\r\u0001\u0005B\u0005%\u0004bBA=\u0001\u0011\u0005\u00131\u0010\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\ti\f\u0001C!\u0003\u007fCq!a<\u0001\t\u0003\n\t\u0010C\u0004\u0003\u0002\u0001!\tEa\u0001\u0003)M\u000bH\u000e\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u0015\t\u0019B#\u0001\u0006sKB|7/\u001b;pefT!!\u0006\f\u0002\u0011Q\u0014\u0018nZ4feNT!a\u0006\r\u0002\u0013ad'/\u001a7fCN,'BA\r\u001b\u0003%AXMY5bY\u0006\u00147OC\u0001\u001c\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001a\u0004J\u00156!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011QeJ\u0007\u0002M)\u00111CF\u0005\u0003Q\u0019\u0012\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z!\rQSfL\u0007\u0002W)\u0011AFJ\u0001\u0004gFd\u0017B\u0001\u0018,\u0005UIe\u000e^3sG\u0016\u0004H/\u001a3SKB|7/\u001b;pef\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\f\u0002\r\u0011|W.Y5o\u0013\t!\u0014GA\u0004Ue&<w-\u001a:\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014!B:mMRR'\"\u0001\u001e\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001P\u001c\u0003\u000f1{wmZ5oO\u0006\u0011BO]5hO\u0016\u0014\b+\u001a:tSN$XM\\2f+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\u0013\u0003-\u0001XM]:jgR,gnY3\n\u0005\u0011\u000b%A\u0005+sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016\f1\u0003\u001e:jO\u001e,'\u000fU3sg&\u001cH/\u001a8dK\u0002\n1bY5JIN+'O^5dKV\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002L-\u000591/\u001a:wS\u000e,\u0017BA'K\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\r\t6\u000b\u0016\t\u0003%\u0002i\u0011A\u0005\u0005\u0006{\u0015\u0001\ra\u0010\u0005\u0006\r\u0016\u0001\r\u0001S\u0001\u0005M&tG-\u0006\u0002X5R\u0011\u0001\f\u0019\t\u00033jc\u0001\u0001B\u0003\\\r\t\u0007ALA\u0001U#\tiv\u0006\u0005\u0002 =&\u0011q\f\t\u0002\b\u001d>$\b.\u001b8h\u0011\u0015\tg\u00011\u0001c\u0003%!(/[4hKJLE\r\u0005\u0002dU:\u0011A\r\u001b\t\u0003K\u0002j\u0011A\u001a\u0006\u0003Or\ta\u0001\u0010:p_Rt\u0014BA5!\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%\u0004\u0003F\u0001\u0004o!\tyW/D\u0001q\u0015\t\t(/A\u0006ue\u0006t7/Y2uS>t'B\u0001\u0017t\u0015\t!h#\u0001\u0002eE&\u0011a\u000f\u001d\u0002\u000b\u0013N\u0014V-\u00193P]2L\bF\u0001\u0004y!\rI\u0018\u0011A\u0007\u0002u*\u00111\u0010`\u0001\u000bC:tw\u000e^1uS>t'BA?\u007f\u0003\u001diW\r\u001e:jGNT!a \u000e\u0002\u0011\r|G-\u00195bY\u0016L1!a\u0001{\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKV!\u0011\u0011BA\u0007)\u0011\tY!a\u0004\u0011\u0007e\u000bi\u0001B\u0003\\\u000f\t\u0007A\fC\u0004\u0002\u0012\u001d\u0001\r!a\u0003\u0002\u000fQ\u0014\u0018nZ4fe\"\u0012q\u0001_\u0001\u0007kB$\u0017\r^3\u0016\t\u0005e\u0011Q\u0004\u000b\u0005\u00037\ty\u0002E\u0002Z\u0003;!Qa\u0017\u0005C\u0002qCq!!\u0005\t\u0001\u0004\tY\u0002\u000b\u0002\tq\u00061A-\u001a7fi\u0016$B!a\n\u0002.A\u0019q$!\u000b\n\u0007\u0005-\u0002E\u0001\u0003V]&$\b\"B1\n\u0001\u0004\u0011\u0007FA\u0005y\u000391\u0017N\u001c3Cs\u001a{G\u000eZ3s\u0013\u0012$\u0002\"!\u000e\u0002L\u0005=\u0013\u0011\f\t\u0006\u0003o\t9eL\u0007\u0003\u0003sQ1AMA\u001e\u0015\u0011\ti$a\u0010\u0002\t\u0011\fG/\u0019\u0006\u0005\u0003\u0003\n\u0019%A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t)%A\u0002pe\u001eLA!!\u0013\u0002:\t!\u0001+Y4f\u0011\u0019\tiE\u0003a\u0001E\u0006Aam\u001c7eKJLE\rC\u0004\u0002R)\u0001\r!a\u0015\u0002\u001b9,7\u000f^3e\r>dG-\u001a:t!\ry\u0012QK\u0005\u0004\u0003/\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\b\u00037R\u0001\u0019AA/\u0003!\u0001\u0018mZ3bE2,\u0007\u0003BA\u001c\u0003?JA!!\u0019\u0002:\tA\u0001+Y4fC\ndW\r\u000b\u0002\u000b]\"\u0012!\u0002_\u0001\u0019]Vl'-\u001a:PMR+W\u000e\u001d7bi\u0016$&/[4hKJ\u001cH\u0003BA6\u0003c\u00022aHA7\u0013\r\ty\u0007\t\u0002\u0004\u0013:$\bBBA:\u0017\u0001\u0007!-\u0001\u0006uK6\u0004H.\u0019;f\u0013\u0012D#a\u00038)\u0005-A\u0018\u0001\u00054j]\u0012\u0014\u0015\u0010V3na2\fG/Z%e)\u0019\t)$! \u0002\u0000!1\u00111\u000f\u0007A\u0002\tDq!a\u0017\r\u0001\u0004\ti\u0006\u000b\u0002\r]\"\u0012A\u0002_\u0001\u000bM&tGMQ=UsB,GCBA\u001b\u0003\u0013\u000b9\fC\u0004\u0002\f6\u0001\r!!$\u0002\u0017Q\u0014\u0018nZ4feRK\b/\u001a\t\u0007\u0003\u001f\u000bI*a(\u000f\t\u0005E\u0015Q\u0013\b\u0004K\u0006M\u0015\"A\u0011\n\u0007\u0005]\u0005%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0015Q\u0014\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0018\u0002\u0002B!!)\u000246\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+A\u0004sK\u001adWm\u0019;\u000b\t\u0005%\u00161V\u0001\u0004CBL'\u0002BAW\u0003_\u000ba\u0001\u001d7vO&t'bAAY1\u0005AA-\u001a9m_fLG/\u0003\u0003\u00026\u0006\r&\u0001\u0002+za\u0016Dq!a\u0017\u000e\u0001\u0004\ti\u0006\u000b\u0002\u000e]\"\u0012Q\u0002_\u0001!O\u0016$(+\u001e8oS:<GK]5hO\u0016\u0014X\r\u001a*fY\u0016\f7/Z:D_VtG\u000f\u0006\u0003\u0002l\u0005\u0005\u0007bBAb\u001d\u0001\u0007\u0011QY\u0001\u000ei\u0016l\u0007\u000f\\1uK\u000eKW+\u001b3\u0011\t\u0005\u001d\u0017Q\u001d\b\u0005\u0003\u0013\f\tO\u0004\u0003\u0002L\u0006}g\u0002BAg\u0003;tA!a4\u0002\\:!\u0011\u0011[Am\u001d\u0011\t\u0019.a6\u000f\u0007\u0015\f).C\u0001\u001c\u0013\tI\"$\u0003\u0002\u00181%\u00111CF\u0005\u0003Y\u0019J!AQ\u0016\n\t\u0005]\u00151\u001d\u0006\u0003\u0005.JA!a:\u0002j\n)1)[+jI*!\u0011qSArQ\tqa\u000e\u000b\u0002\u000fq\u00061\u0012N\\:feR$&/[4hKJ,GMU3mK\u0006\u001cX\r\u0006\u0005\u0002(\u0005M\u0018q_A~\u0011\u001d\t)p\u0004a\u0001\u0003\u000b\f1\u0002^3na2\fG/Z+jI\"9\u0011\u0011`\bA\u0002\u0005\u0015\u0017A\u0003;sS\u001e<WM]+jI\"9\u0011Q`\bA\u0002\u0005\u0015\u0017a\u0005;sS\u001e<WM]3e%\u0016dW-Y:f+&$\u0007FA\by\u0003Y\u0011X-\\8wKR\u0013\u0018nZ4fe\u0016$'+\u001a7fCN,G\u0003BA\u0014\u0005\u000bAqAa\u0002\u0011\u0001\u0004\u0011I!A\u0005d_:$\u0017\u000e^5p]B\u0019QEa\u0003\n\u0007\t5aEA\u0010SK6|g/\u001a+sS\u001e<WM]3e%\u0016dW-Y:f\u0007>tG-\u001b;j_:D#\u0001\u0005=)\u0007\u0001\u0011\u0019\u0002E\u0002p\u0005+I1Aa\u0006q\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlTriggerRepository
implements TriggerRepository,
Logging {
    private final TriggerPersistence triggerPersistence;
    private final CiIdService ciIdService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Trigger> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTriggerRepository sqlTriggerRepository = this;
        synchronized (sqlTriggerRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    @IsReadOnly
    public <T extends Trigger> T find(String triggerId) {
        Option maybeTrigger = Ids.isInRelease((String)triggerId) ? this.triggerPersistence().findById(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId)))) : this.triggerPersistence().findById(Ids.getName((String)triggerId));
        return (T)((Trigger)maybeTrigger.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId});
        }));
    }

    @Timed
    public <T extends Trigger> T create(T trigger) {
        if (!Ids.isTriggerId((String)trigger.getId())) {
            throw new IllegalArgumentException("Trigger Id [" + trigger.getId() + "] is not valid");
        }
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptCreate((ConfigurationItem)trigger);
        this.triggerPersistence().insert(trigger);
        this.afterCreate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public <T extends Trigger> T update(T trigger) {
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptUpdate((ConfigurationItem)trigger);
        this.triggerPersistence().update(trigger);
        this.afterUpdate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public void delete(String triggerId) {
        this.interceptDelete(triggerId);
        this.triggerPersistence().delete(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        this.afterDelete(triggerId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByFolderId(String folderId, boolean nestedFolders, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setFolderId(folderId);
        filter.setNestedFolders(Predef$.MODULE$.boolean2Boolean(nestedFolders));
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        return this.triggerPersistence().numberOfTemplateTriggers(templateId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByTemplateId(String templateId, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTemplateId(templateId);
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByType(List<Type> triggerType, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTriggerType(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)triggerType.map((Function1 & Serializable)x$1 -> x$1.toString())).asJava());
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int getRunningTriggeredReleasesCount(Integer templateCiUid) {
        int total = this.triggerPersistence().getRunningTriggeredReleasesCount(templateCiUid);
        this.logger().debug((Function0 & Serializable)() -> "getRunningTriggeredReleasesCount: templateCiUid=" + templateCiUid + ", total=" + total);
        return total;
    }

    @Timed
    public void insertTriggeredRelease(Integer templateUid, Integer triggerUid, Integer triggeredReleaseUid) {
        this.logger().debug((Function0 & Serializable)() -> "insertTriggeredRelease: templateUid=" + templateUid + ", triggerUid=" + triggerUid + ", triggeredReleaseUid=" + triggeredReleaseUid);
        TriggeredReleaseRow row = new TriggeredReleaseRow(templateUid, triggerUid, triggeredReleaseUid);
        this.triggerPersistence().insertTriggeredReleaseRow(row);
    }

    @Timed
    public void removeTriggeredRelease(RemoveTriggeredReleaseCondition condition) {
        this.logger().debug((Function0 & Serializable)() -> "removeTriggeredRelease: " + condition);
        this.triggerPersistence().removeTriggeredReleasesRow(condition);
    }

    public SqlTriggerRepository(TriggerPersistence triggerPersistence, CiIdService ciIdService) {
        this.triggerPersistence = triggerPersistence;
        this.ciIdService = ciIdService;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
    }
}

