/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.jdbc.snapshot.dao.legacy;

import akka.persistence.SnapshotMetadata;
import akka.persistence.jdbc.config.SnapshotConfig;
import akka.persistence.jdbc.snapshot.dao.SnapshotDao;
import akka.persistence.jdbc.snapshot.dao.legacy.ByteArraySnapshotSerializer;
import akka.persistence.jdbc.snapshot.dao.legacy.SnapshotQueries;
import akka.persistence.jdbc.snapshot.dao.legacy.SnapshotTables;
import akka.serialization.Serialization;
import akka.stream.Materializer;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.RunnableCompiled;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001\u0002\r\u001a\u0001\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!i\u0005A!A!\u0002\u0017q\u0005\u0002\u0003+\u0001\u0005\u000b\u0007I1A+\t\u0011q\u0003!\u0011!Q\u0001\nYCQ!\u0018\u0001\u0005\u0002yCq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u0019\u0019\b\u0001)A\u0005a\")A\u000f\u0001C\u0001k\"9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\ty\u0007\u0001C!\u0003cBq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\f\u0002!\t%!$\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u00111\u0014\u0001\u0005B\u0005u\u0005bBAR\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003W\u0003A\u0011IAW\u0005Q\u0011\u0015\u0010^3BeJ\f\u0017p\u00158baNDw\u000e\u001e#b_*\u0011!dG\u0001\u0007Y\u0016<\u0017mY=\u000b\u0005qi\u0012a\u00013b_*\u0011adH\u0001\tg:\f\u0007o\u001d5pi*\u0011\u0001%I\u0001\u0005U\u0012\u00147M\u0003\u0002#G\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\u0005!\u0013\u0001B1lW\u0006\u001c\u0001aE\u0002\u0001O5\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0007C\u0001\u00180\u001b\u0005Y\u0012B\u0001\u0019\u001c\u0005-\u0019f.\u00199tQ>$H)Y8\u0002\u0005\u0011\u0014\u0007CA\u001a;!\t!\u0004(D\u00016\u0015\t\u0001cGC\u00018\u0003\u0015\u0019H.[2l\u0013\tITGA\u0006KI\n\u001c')Y2lK:$\u0017BA\u001e9\u0005-!\u0015\r^1cCN,G)\u001a4\u0002\u000fA\u0014xNZ5mKB\u0011AGP\u0005\u0003\u007fU\u00121B\u00133cGB\u0013xNZ5mK\u0006q1O\\1qg\"|GoQ8oM&<\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001# \u0003\u0019\u0019wN\u001c4jO&\u0011ai\u0011\u0002\u000f':\f\u0007o\u001d5pi\u000e{gNZ5h\u00035\u0019XM]5bY&T\u0018\r^5p]B\u0011\u0011jS\u0007\u0002\u0015*\u0011qiI\u0005\u0003\u0019*\u0013QbU3sS\u0006d\u0017N_1uS>t\u0017AA3d!\ty%+D\u0001Q\u0015\t\t\u0016&\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0015)\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA7biV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002ZG\u000511\u000f\u001e:fC6L!a\u0017-\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\t5\fG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b}#WMZ4\u0015\u0007\u0001\u00147\r\u0005\u0002b\u00015\t\u0011\u0004C\u0003N\u0011\u0001\u000fa\nC\u0003U\u0011\u0001\u000fa\u000bC\u00032\u0011\u0001\u0007!\u0007C\u0003=\u0011\u0001\u0007Q\bC\u0003A\u0011\u0001\u0007\u0011\tC\u0003H\u0011\u0001\u0007\u0001*A\u0004rk\u0016\u0014\u0018.Z:\u0016\u0003)\u0004\"!Y6\n\u00051L\"aD*oCB\u001c\bn\u001c;Rk\u0016\u0014\u0018.Z:\u0002\u0011E,XM]5fg\u0002\n!b]3sS\u0006d\u0017N_3s+\u0005\u0001\bCA1r\u0013\t\u0011\u0018DA\u000eCsR,\u0017I\u001d:bsNs\u0017\r]:i_R\u001cVM]5bY&TXM]\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\bu_Ns\u0017\r]:i_R$\u0015\r^1\u0015\u0007Y\f\t\u0001\u0005\u0003)ofl\u0018B\u0001=*\u0005\u0019!V\u000f\u001d7feA\u0011!p_\u0007\u0002C%\u0011A0\t\u0002\u0011':\f\u0007o\u001d5pi6+G/\u00193bi\u0006\u0004\"\u0001\u000b@\n\u0005}L#aA!os\"9\u00111A\u0007A\u0002\u0005\u0015\u0011a\u0001:poB!\u0011qAA\u0016\u001d\u0011\tI!a\n\u000f\t\u0005-\u0011Q\u0005\b\u0005\u0003\u001b\t\u0019C\u0004\u0003\u0002\u0010\u0005\u0005b\u0002BA\t\u0003?qA!a\u0005\u0002\u001e9!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0015\na\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\tqr$\u0003\u0002\u001d;%\u0011!dG\u0005\u0004\u0003SI\u0012AD*oCB\u001c\bn\u001c;UC\ndWm]\u0005\u0005\u0003[\tyCA\u0006T]\u0006\u00048\u000f[8u%><(bAA\u00153\u0005qA.\u0019;fgR\u001cf.\u00199tQ>$H\u0003BA\u001b\u0003\u0003\u0002RaTA\u001c\u0003wI1!!\u000fQ\u0005\u00191U\u000f^;sKB!\u0001&!\u0010w\u0013\r\ty$\u000b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\rc\u00021\u0001\u0002F\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012\u0004B!a\u0012\u0002P9!\u0011\u0011JA&!\r\t)\"K\u0005\u0004\u0003\u001bJ\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002R\u0005M#AB*ue&twMC\u0002\u0002N%\nqc\u001d8baNDw\u000e\u001e$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u0005U\u0012\u0011LA.\u0011\u001d\t\u0019e\u0004a\u0001\u0003\u000bBq!!\u0018\u0010\u0001\u0004\ty&\u0001\u0007nCb$\u0016.\\3ti\u0006l\u0007\u000fE\u0002)\u0003CJ1!a\u0019*\u0005\u0011auN\\4\u00021Mt\u0017\r]:i_R4uN]'bqN+\u0017/^3oG\u0016t%\u000f\u0006\u0004\u00026\u0005%\u00141\u000e\u0005\b\u0003\u0007\u0002\u0002\u0019AA#\u0011\u001d\ti\u0007\u0005a\u0001\u0003?\nQ\"\\1y'\u0016\fX/\u001a8dK:\u0013\u0018aJ:oCB\u001c\bn\u001c;G_Jl\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"!\u000e\u0002t\u0005U\u0014q\u000f\u0005\b\u0003\u0007\n\u0002\u0019AA#\u0011\u001d\ti'\u0005a\u0001\u0003?Bq!!\u0018\u0012\u0001\u0004\ty&\u0001\u0003tCZ,GCBA?\u0003\u000b\u000bI\tE\u0003P\u0003o\ty\bE\u0002)\u0003\u0003K1!a!*\u0005\u0011)f.\u001b;\t\r\u0005\u001d%\u00031\u0001z\u0003A\u0019h.\u00199tQ>$X*\u001a;bI\u0006$\u0018\rC\u0003\u001f%\u0001\u0007Q0\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003{\ny)!%\t\u000f\u0005\r3\u00031\u0001\u0002F!9\u00111S\nA\u0002\u0005}\u0013AC:fcV,gnY3Oe\u0006\u0011B-\u001a7fi\u0016\fE\u000e\\*oCB\u001c\bn\u001c;t)\u0011\ti(!'\t\u000f\u0005\rC\u00031\u0001\u0002F\u00059B-\u001a7fi\u0016,\u0006\u000fV8NCb\u001cV-];f]\u000e,gJ\u001d\u000b\u0007\u0003{\ny*!)\t\u000f\u0005\rS\u00031\u0001\u0002F!9\u0011QN\u000bA\u0002\u0005}\u0013A\u00063fY\u0016$X-\u00169U_6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u0005u\u0014qUAU\u0011\u001d\t\u0019E\u0006a\u0001\u0003\u000bBq!!\u0018\u0017\u0001\u0004\ty&\u0001\u0014eK2,G/Z+q)>l\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"! \u00020\u0006E\u00161\u0017\u0005\b\u0003\u0007:\u0002\u0019AA#\u0011\u001d\tig\u0006a\u0001\u0003?Bq!!\u0018\u0018\u0001\u0004\ty\u0006")
public class ByteArraySnapshotDao
implements SnapshotDao {
    private final JdbcBackend.DatabaseDef db;
    private final JdbcProfile profile;
    private final ExecutionContext ec;
    private final Materializer mat;
    private final SnapshotQueries queries;
    private final ByteArraySnapshotSerializer serializer;

    public Materializer mat() {
        return this.mat;
    }

    public SnapshotQueries queries() {
        return this.queries;
    }

    public ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    public Tuple2<SnapshotMetadata, Object> toSnapshotData(SnapshotTables.SnapshotRow row) {
        Tuple2 deserialized;
        Try<Tuple2<SnapshotMetadata, Object>> try_ = this.serializer().deserialize(row);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable cause = failure.exception();
                throw cause;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        Tuple2 tuple2 = deserialized = (Tuple2)success.value();
        return tuple2;
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> latestSnapshot(String persistenceId) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectLatestByPersistenceId().apply((Object)persistenceId))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<BoxedUnit> save(SnapshotMetadata snapshotMetadata, Object snapshot) {
        Future eventualSnapshotRow = Future$.MODULE$.fromTry(this.serializer().serialize(snapshotMetadata, snapshot));
        return eventualSnapshotRow.map((Function1 & Serializable)snapshotRow -> this.queries().insertOrUpdate((SnapshotTables.SnapshotRow)snapshotRow), this.ec).flatMap((Function1 & Serializable)a -> $this.db.run(a), this.ec).map((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> delete(String persistenceId, long sequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdAndSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            int n = x$2;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteAllSnapshots(String persistenceId) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectAll().apply((Object)persistenceId)).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            int n = x$3;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            int n = x$4;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            int n = x$5;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            int n = x$6;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, this.ec);
    }

    public ByteArraySnapshotDao(JdbcBackend.DatabaseDef db, JdbcProfile profile, SnapshotConfig snapshotConfig, Serialization serialization, ExecutionContext ec, Materializer mat) {
        this.db = db;
        this.profile = profile;
        this.ec = ec;
        this.mat = mat;
        this.queries = new SnapshotQueries(profile, snapshotConfig.legacySnapshotTableConfiguration());
        this.serializer = new ByteArraySnapshotSerializer(serialization);
    }
}

