import { all, call, put, takeEvery } from 'redux-saga/effects';
import { PayloadAction } from '@reduxjs/toolkit';
import { externalApplicationWizard } from './application-wizard.reducer';
import { ServerCi } from '../external-deployment.types';
import { httpPOST } from '../../../../../../../../../core/xlr-ui/app/features/common/services/http';

const { setConnectionTested, setTestConnectionStatus, testConnection } = externalApplicationWizard.actions;

export function* testConnectionSaga(action: PayloadAction<ServerCi>) {
    const {
        data: { errorText, success },
    } = yield call(httpPOST, `configurations/status`, action.payload);
    yield put(setTestConnectionStatus({ success, errorText }));
    yield put(setConnectionTested(true));
}

export function* applicationWizardSagas() {
    yield all([takeEvery(testConnection, testConnectionSaga)]);
}
