/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.Objects;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;

public class ImportNode
extends AnnotatedNode {
    private ClassNode type;
    private final String alias;
    private final String fieldName;
    private final String packageName;
    private final boolean isStar;
    private final boolean isStatic;
    private int hashCode;

    public ImportNode(ClassNode type, String alias) {
        this.type = Objects.requireNonNull(type);
        this.alias = alias;
        this.isStar = false;
        this.isStatic = false;
        this.packageName = null;
        this.fieldName = null;
    }

    public ImportNode(String packageName) {
        this.type = null;
        this.alias = null;
        this.isStar = true;
        this.isStatic = false;
        this.packageName = Objects.requireNonNull(packageName);
        this.fieldName = null;
    }

    public ImportNode(ClassNode type) {
        this.type = Objects.requireNonNull(type);
        this.alias = null;
        this.isStar = true;
        this.isStatic = true;
        this.packageName = null;
        this.fieldName = null;
    }

    public ImportNode(ClassNode type, String fieldName, String alias) {
        this.type = Objects.requireNonNull(type);
        this.alias = alias;
        this.isStar = false;
        this.isStatic = true;
        this.packageName = null;
        this.fieldName = Objects.requireNonNull(fieldName);
    }

    @Override
    public String getText() {
        String typeName = this.getClassName();
        if (this.isStar && !this.isStatic) {
            return "import " + this.packageName + "*";
        }
        if (this.isStar) {
            return "import static " + typeName + ".*";
        }
        if (this.isStatic) {
            if (this.alias != null && !this.alias.isEmpty() && !this.alias.equals(this.fieldName)) {
                return "import static " + typeName + "." + this.fieldName + " as " + this.alias;
            }
            return "import static " + typeName + "." + this.fieldName;
        }
        if (this.alias == null || this.alias.isEmpty()) {
            return "import " + typeName;
        }
        return "import " + typeName + " as " + this.alias;
    }

    public boolean isStar() {
        return this.isStar;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getClassName() {
        return this.type == null ? null : this.type.getName();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassNode getType() {
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = type;
        this.hashCode = 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImportNode)) {
            return false;
        }
        ImportNode imp = (ImportNode)o;
        if (this.type == null != (imp.type == null)) {
            return false;
        }
        if (this.type != null && !this.type.equals(imp.type)) {
            return false;
        }
        if (this.alias == null != (imp.alias == null)) {
            return false;
        }
        if (this.alias != null && !this.alias.equals(imp.alias)) {
            return false;
        }
        if (this.fieldName == null != (imp.fieldName == null)) {
            return false;
        }
        if (this.fieldName != null && !this.fieldName.equals(imp.fieldName)) {
            return false;
        }
        if (this.packageName == null != (imp.packageName == null)) {
            return false;
        }
        if (this.packageName != null && !this.packageName.equals(imp.packageName)) {
            return false;
        }
        if (this.isStar != imp.isStar) {
            return false;
        }
        return this.isStatic == imp.isStatic;
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            if (this.type != null) {
                result = 31 * result + this.type.hashCode();
            }
            if (this.alias != null) {
                result = 31 * result + this.alias.hashCode();
            }
            if (this.fieldName != null) {
                result = 31 * result + this.fieldName.hashCode();
            }
            if (this.packageName != null) {
                result = 31 * result + this.packageName.hashCode();
            }
            result = 31 * result + Boolean.hashCode(this.isStar);
            this.hashCode = result = 31 * result + Boolean.hashCode(this.isStatic);
        }
        return result;
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
    }
}

