/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Marker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\u0006\r\u0001]A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006c\u0001!\tA\r\u0005\u0006m\u0001!\te\u000e\u0005\u0006-\u0002!\te\u0016\u0005\u0006-\u0002!\tE\u0019\u0005\u0006M\u0002!\te\u001a\u0005\u0006]\u0002!\te\u001c\u0005\u0006]\u0002!\tE\u001e\u0005\u0006}\u0002!\ta \u0005\b\u00033\u0001A\u0011AA\u000e\u0005]\u0019\u0016\u000f\\!ui\u0006\u001c\u0007.\\3oiJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u000e\u001d\u0005\u00191/\u001d7\u000b\u0005=\u0001\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011\u0011CE\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0005\u000b\u0002\u0013a,'-[1mC\n\u001c(\"A\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001AbD\t\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0001S\"\u0001\b\n\u0005\u0005r!\u0001F!ui\u0006\u001c\u0007.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005)1\u000f\u001c45U*\tq%\u0001\u0005he&T(\u0010\\3e\u0013\tICEA\u0004M_\u001e<\u0017N\\4\u0002%I,G.Z1tKB+'o]5ti\u0016t7-\u001a\t\u0003Y=j\u0011!\f\u0006\u0003]1\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011\u0001'\f\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003gU\u0002\"\u0001\u000e\u0001\u000e\u00031AQA\u000b\u0002A\u0002-\n\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0003qy\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\t\u0002\r\u0011|W.Y5o\u0013\ti$H\u0001\u0006BiR\f7\r[7f]RDQaP\u0002A\u0002\u0001\u000bA\"\u0019;uC\u000eDW.\u001a8u\u0013\u0012\u0004\"!\u0011%\u000f\u0005\t3\u0005CA\"\u001b\u001b\u0005!%BA#\u0017\u0003\u0019a$o\\8u}%\u0011qIG\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H5!\u00121\u0001\u0014\t\u0003\u001bRk\u0011A\u0014\u0006\u0003\u001fB\u000b!\"\u00198o_R\fG/[8o\u0015\t\t&+A\u0004nKR\u0014\u0018nY:\u000b\u0005M#\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005Us%!\u0002+j[\u0016$\u0017AB2sK\u0006$X\r\u0006\u000391v{\u0006\"B-\u0005\u0001\u0004Q\u0016a\u0002:fY\u0016\f7/\u001a\t\u0003smK!\u0001\u0018\u001e\u0003\u000fI+G.Z1tK\")a\f\u0002a\u0001\u0001\u00061A/Y:l\u0013\u0012DQ\u0001\u0019\u0003A\u0002a\n!\"\u0019;uC\u000eDW.\u001a8uQ\t!A\nF\u00029G\u0012DQ!W\u0003A\u0002iCQ\u0001Y\u0003A\u0002aB#!\u0002'\u0002!%t7/\u001a:u\u0003R$\u0018m\u00195nK:$Hc\u00015l[B\u0011\u0011$[\u0005\u0003Uj\u0011qAQ8pY\u0016\fg\u000eC\u0003m\r\u0001\u0007\u0001)A\u0005sK2,\u0017m]3JI\")\u0001M\u0002a\u0001q\u00051A-\u001a7fi\u0016$2\u0001]:u!\tI\u0012/\u0003\u0002s5\t!QK\\5u\u0011\u0015Iv\u00011\u0001[\u0011\u0015\u0001w\u00011\u00019Q\t9A\nF\u0002qorDQ\u0001\u001f\u0005A\u0002e\fA\u0001^1tWB\u0011\u0011H_\u0005\u0003wj\u0012A\u0001V1tW\")\u0001\r\u0003a\u0001q!\u0012\u0001\u0002T\u0001\fE\u0006$8\r[%og\u0016\u0014H\u000fF\u0003i\u0003\u0003\t\u0019\u0001C\u0003Z\u0013\u0001\u0007!\fC\u0004\u0002\u0006%\u0001\r!a\u0002\u0002\u0017\u0005$H/Y2i[\u0016tGo\u001d\t\u0006\u0003\u0013\t\u0019\u0002\u000f\b\u0005\u0003\u0017\tyAD\u0002D\u0003\u001bI\u0011aG\u0005\u0004\u0003#Q\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003+\t9BA\u0002TKFT1!!\u0005\u001b\u0003\u0019Ign]3siRI\u0001.!\b\u0002F\u0005%\u0013Q\n\u0005\b\u0003?Q\u0001\u0019AA\u0011\u0003)\u0011X\r\\3bg\u0016,\u0016\u000e\u001a\t\u0005\u0003G\tyD\u0004\u0003\u0002&\u0005ub\u0002BA\u0014\u0003wqA!!\u000b\u0002:9!\u00111FA\u001c\u001d\u0011\ti#!\u000e\u000f\t\u0005=\u00121\u0007\b\u0004\u0007\u0006E\u0012\"A\u000b\n\u0005M!\u0012BA\t\u0013\u0013\ty\u0001#\u0003\u0002\u000e\u001d%\u0011a\u0006D\u0005\u0004\u0003#i\u0013\u0002BA!\u0003\u0007\u0012QaQ5VS\u0012T1!!\u0005.\u0011\u0019\t9E\u0003a\u0001\u0001\u0006Q\u0011M\u001d;jM\u0006\u001cG/\u00133\t\r\u0005-#\u00021\u0001A\u00031\t'\u000f^5gC\u000e$h*Y7f\u0011\u001d\tyE\u0003a\u0001\u0003#\nqaY8oi\u0016tG\u000f\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\u0005%|'BAA.\u0003\u0011Q\u0017M^1\n\t\u0005}\u0013Q\u000b\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eK\u0002\u0001\u0003G\u0002B!!\u001a\u0002r5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0006ue\u0006t7/Y2uS>t'bA\u0007\u0002n)\u0019\u0011q\u000e\t\u0002\u0005\u0011\u0014\u0017\u0002BA:\u0003O\u0012q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlAttachmentRepository
implements AttachmentRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlAttachmentRepository sqlAttachmentRepository = this;
        synchronized (sqlAttachmentRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Attachment findById(String attachmentId) {
        this.logger().debug((Function0 & Serializable)() -> "Searching for attachment [" + attachmentId + "]");
        return (Attachment)this.releasePersistence.findAttachmentById(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Repository entity [%s] not found", new Object[]{attachmentId});
        });
    }

    @Timed
    public Attachment create(Release release, String taskId, Attachment attachment) {
        this.logger().debug((Function0 & Serializable)() -> "Adding attachment to task [" + taskId + "]");
        Task releaseTask = release.getTask(taskId);
        HashSet<Attachment> taskAttachments = new HashSet<Attachment>(releaseTask.getAttachments());
        taskAttachments.add(attachment);
        releaseTask.setAttachments(new ArrayList(taskAttachments));
        return this.create(release, attachment);
    }

    @Timed
    public Attachment create(Release release, Attachment attachment) {
        this.logger().debug((Function0 & Serializable)() -> "Adding attachment to release [" + release.getId() + "]");
        release.getAttachments().add(attachment);
        this.releasePersistence.update((Option<Release>)None$.MODULE$, release);
        return attachment;
    }

    public boolean insertAttachment(String releaseId, Attachment attachment) {
        return this.releasePersistence.insertAttachments(releaseId, (Seq<SourceArtifact>)new .colon.colon((Object)attachment, (List)Nil$.MODULE$));
    }

    @Timed
    public void delete(Release release, Attachment attachment) {
        this.logger().info((Function0 & Serializable)() -> "Deleting attachment reference '" + attachment.getId() + "' from release '" + release.getId() + "'");
        release.deleteAttachment(attachment.getId());
        this.releasePersistence.update(release);
        if (!release.isTemplate()) {
            this.releasePersistence.deleteAttachmentById(attachment.getId(), release.getCiUid());
            return;
        }
    }

    @Timed
    public void delete(Task task, Attachment attachment) {
        task.deleteAttachment(attachment.getId());
        Release release = task.getRelease();
        if (release.getTasksUsingAttachment(attachment.getId()).isEmpty()) {
            this.delete(release, attachment);
            return;
        }
        this.logger().info((Function0 & Serializable)() -> "Deleting attachment reference " + attachment.getId() + " from task " + task.getId());
        this.releasePersistence.update(release);
    }

    public boolean batchInsert(Release release, Seq<Attachment> attachments) {
        boolean bl;
        try {
            bl = this.releasePersistence.insertAttachments(release.getId(), attachments);
        }
        catch (RuntimeException e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public boolean insert(Integer releaseUid, String artifactId, String artifactName, InputStream content) {
        boolean bl;
        try {
            bl = this.releasePersistence.insertArtifact(Predef$.MODULE$.Integer2int(releaseUid), artifactId, artifactName, content);
        }
        catch (RuntimeException e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public SqlAttachmentRepository(ReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
        Logging.$init$((Logging)this);
    }
}

