/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.forms.CreatePersonalAccessTokenForm;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Path(value="/tokens")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\u0006\r\u0001]A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002\u0012\u0002!\t!a%\t\rY\u0003A\u0011BAb\u0005E)6/\u001a:U_.,gNU3t_V\u00148-\u001a\u0006\u0003\u001b9\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001fA\t1!\u00199j\u0015\t\t\"#A\u0005yYJ,G.Z1tK*\u00111\u0003F\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!F\u0001\u0004G>l7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005)1\u000f\u001c45U*\t1%\u0001\u0005he&T(\u0010\\3e\u0013\t)\u0003EA\u0004M_\u001e<\u0017N\\4\u0002\u0017A,'/\\5tg&|gn\u001d\t\u0003Q-j\u0011!\u000b\u0006\u0003UA\t\u0001b]3dkJLG/_\u0005\u0003Y%\u0012\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u00031!xn[3o'\u0016\u0014h/[2f!\ty#'D\u00011\u0015\t\t\u0004#A\u0004tKJ4\u0018nY3\n\u0005M\u0002$\u0001E+tKJ$vn[3o'\u0016\u0014h/[2f\u0003\u0015)8/\u001a:t!\tyc'\u0003\u00028a\t)Qk]3sg\u0006)\u0002O]5oG&\u0004\u0018\r\u001c#bi\u0006\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0011\u00035\u0001(/\u001b8dSB\fG\u000eZ1uC&\u0011ah\u000f\u0002\u0016!JLgnY5qC2$\u0015\r^1Qe>4\u0018\u000eZ3s\u0003\u0019a\u0014N\\5u}Q)\u0011i\u0011#F\rB\u0011!\tA\u0007\u0002\u0019!)a%\u0002a\u0001O!)Q&\u0002a\u0001]!)A'\u0002a\u0001k!)\u0001(\u0002a\u0001s!\u0012Q\u0001\u0013\t\u0003\u0013Rk\u0011A\u0013\u0006\u0003\u00172\u000b!\"\u00198o_R\fG/[8o\u0015\tie*A\u0004gC\u000e$xN]=\u000b\u0005=\u0003\u0016!\u00022fC:\u001c(BA)S\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A*\u0002\u0007=\u0014x-\u0003\u0002V\u0015\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u000eO\u0016$Xk]3s)>\\WM\\:\u0015\u0007a+W\u0010E\u0002Z=\u0002l\u0011A\u0017\u0006\u00037r\u000ba\u0001Z8nC&t'BA/Q\u0003\u0011!\u0017\r^1\n\u0005}S&\u0001\u0002)bO\u0016\u0004\"!Y2\u000e\u0003\tT!a\u0017\t\n\u0005\u0011\u0014'!C+tKJ$vn[3o\u0011\u00151g\u00011\u0001h\u0003\u0011\u0001\u0018mZ3\u0011\u0005eA\u0017BA5\u001b\u0005\rIe\u000e\u001e\u0015\u0005K.,h\u000f\u0005\u0002mg6\tQN\u0003\u0002o_\u0006\u0011!o\u001d\u0006\u0003aF\f!a^:\u000b\u0003I\fQA[1wCbL!\u0001^7\u0003\u0019\u0011+g-Y;miZ\u000bG.^3\u0002\u000bY\fG.^3\"\u0003]\f\u0011\u0001\r\u0015\u0005Kf,H\u0010\u0005\u0002mu&\u001110\u001c\u0002\u000b#V,'/\u001f)be\u0006l\u0017%\u00014\t\u000by4\u0001\u0019A4\u0002\u001dI,7/\u001e7ugB+'\u000fU1hK\"*Qp[;\u0002\u0002\u0005\u0012\u00111A\u0001\u0004cA\u0002\u0004&B?zk\u0006\u001d\u0011%\u0001@)\u0007\u0019\tY\u0001E\u0002m\u0003\u001bI1!a\u0004n\u0005\r9U\t\u0016\u0015\u0007\r\u0005MQ/!\u0007\u0011\u00071\f)\"C\u0002\u0002\u00185\u0014A\u0001U1uQ\u0006\u0012\u00111D\u0001\u0007_U\u001cXM]:)\u0007\u0019\ty\u0002\u0005\u0003\u0002\"\u00055RBAA\u0012\u0015\rY\u0015Q\u0005\u0006\u0005\u0003O\tI#A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005-B#\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\ty#a\t\u0003\u000bQKW.\u001a3\u0002)\u001d,G\u000fV8lK:\u001chi\u001c:Vg\u0016\u0014h.Y7f)\u001dA\u0016QGA-\u0003?Bq!a\u000e\b\u0001\u0004\tI$\u0001\u0005vg\u0016\u0014h.Y7f!\u0011\tY$!\u0013\u000f\t\u0005u\u0012Q\t\t\u0004\u0003\u007fQRBAA!\u0015\r\t\u0019EF\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d#$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\niE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000fR\u0002fBA\u001b\u0003#*\u0018q\u000b\t\u0004Y\u0006M\u0013bAA+[\nI\u0001+\u0019;i!\u0006\u0014\u0018-\\\u0011\u0003\u0003oAQAZ\u0004A\u0002\u001dDS!!\u0017lkZDS!!\u0017zkrDQA`\u0004A\u0002\u001dDc!a\u0018lk\u0006\u0005\u0001FBA0sV\f9\u0001K\u0002\b\u0003\u0017AcaBA\nk\u0006%\u0014EAA6\u0003EySo]3sg>ZXo]3s]\u0006lW-`\u0001\u0012O\u0016tWM]1uKV\u001bXM\u001d+pW\u0016tGc\u00011\u0002r!9\u00111\u000f\u0005A\u0002\u0005U\u0014!D;tKJ$vn[3o\r>\u0014X\u000e\u0005\u0003\u0002x\u0005\u0005UBAA=\u0015\u0011\tY(! \u0002\u000b\u0019|'/\\:\u000b\u0007\u0005}d\"\u0001\u0002wc%!\u00111QA=\u0005u\u0019%/Z1uKB+'o]8oC2\f5mY3tgR{7.\u001a8G_Jl\u0007f\u0001\u0005\u0002\bB\u0019A.!#\n\u0007\u0005-UN\u0001\u0003Q\u001fN#\u0006F\u0002\u0005\u0002\u0014U\fI\u0002K\u0002\t\u0003?\tq\u0002Z3mKR,Wk]3s)>\\WM\u001c\u000b\u0005\u0003+\u000bY\nE\u0002\u001a\u0003/K1!!'\u001b\u0005\u0011)f.\u001b;\t\u000f\u0005u\u0015\u00021\u0001\u0002 \u0006)1-[+jIB!\u0011\u0011UAV\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016\u0001\u00027b]\u001eT!!!+\u0002\t)\fg/Y\u0005\u0005\u0003[\u000b\u0019KA\u0004J]R,w-\u001a:)\u000f\u0005m\u0015\u0011K;\u00022\u0006\u0012\u0011Q\u0014\u0015\u0004\u0013\u0005U\u0006c\u00017\u00028&\u0019\u0011\u0011X7\u0003\r\u0011+E*\u0012+FQ\u0019I\u00111C;\u0002>\u0006\u0012\u0011qX\u0001\u000f_U\u001cXM]:0w\u000eLW+\u001b3~Q\rI\u0011q\u0004\u000b\b1\u0006\u0015\u0017qYAe\u0011\u001d\t9D\u0003a\u0001\u0003sAQA\u001a\u0006A\u0002\u001dDQA \u0006A\u0002\u001dDc\u0001AA\nk\u00065\u0017EAAh\u0003\u001dyCo\\6f]NDc\u0001AAjk\u0006e\u0007c\u00017\u0002V&\u0019\u0011q[7\u0003\u0011\r{gn];nKNd#!a7\"\u0005\u0005u\u0017\u0001E1qa2L7-\u0019;j_:|#n]8oQ\u0019\u0001\u0011\u0011];\u0002hB\u0019A.a9\n\u0007\u0005\u0015XN\u0001\u0005Qe>$WoY3tY\t\tY\u000eK\u0002\u0001\u0003W\u0004B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0004\u0003c\u0004\u0016AC:uKJ,w\u000e^=qK&!\u0011Q_Ax\u0005)\u0019uN\u001c;s_2dWM\u001d")
public class UserTokenResource
implements Logging {
    private final PermissionChecker permissions;
    private final UserTokenService tokenService;
    private final Users users;
    private final PrincipalDataProvider principalDataProvider;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenResource userTokenResource = this;
        synchronized (userTokenResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/users")
    @Timed
    public Page<UserToken> getUserTokens(@DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        return this.getUserTokens(User.AUTHENTICATED_USER.getName(), page, resultsPerPage);
    }

    @GET
    @Path(value="/users/{username}")
    public Page<UserToken> getTokensForUsername(@PathParam(value="username") String username, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.getUserTokens(username, page, resultsPerPage);
    }

    @POST
    @Path(value="/users")
    @Timed
    public UserToken generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        String username = User.AUTHENTICATED_USER.getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        boolean personalAccessTokenSupported = this.users.userExistsInRepository(username) || userData.isFound();
        Checks.checkArgument((boolean)personalAccessTokenSupported, (String)"Personal access tokens are only supported for internal users and external users authenticated via LDAP, Atlassian Crowd", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)userTokenForm.getTokenNote()), (String)"Note can't be blank", (Object[])new Object[0]);
        Checks.checkArgument((userTokenForm.getExpiryDate() == null || userTokenForm.getExpiryDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.getTokenNote().trim();
        userTokenForm.setTokenNote(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!this.tokenService.userTokenExists(username, tokenNote) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
        return this.tokenService.createUserToken(username, tokenNote, userTokenForm.getExpiryDate());
    }

    @DELETE
    @Path(value="/users/{ciUid}")
    @Timed
    public void deleteUserToken(@PathParam(value="ciUid") Integer ciUid) {
        Option<UserToken> userToken = this.tokenService.findByCiUid(ciUid);
        Option<UserToken> option = userToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            UserToken token = (UserToken)some.value();
            if (token.username().equalsIgnoreCase(User.AUTHENTICATED_USER.getName()) || this.permissions.isCurrentUserAdmin()) {
                this.tokenService.deleteUserToken(token);
                return;
            }
            throw new PermissionDeniedException("You don't have the permissions required to delete this personal access token.");
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Personal access token ciUid[" + ciUid + "] is not valid");
        }
        throw new MatchError(option);
    }

    private Page<UserToken> getUserTokens(String username, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.tokenService.find(username, (Pageable)pageable);
    }

    @Autowired
    public UserTokenResource(PermissionChecker permissions, UserTokenService tokenService, Users users, PrincipalDataProvider principalDataProvider) {
        this.permissions = permissions;
        this.tokenService = tokenService;
        this.users = users;
        this.principalDataProvider = principalDataProvider;
        Logging.$init$((Logging)this);
    }
}

