/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.filter;

public abstract class PeriodicStats {
    private long nextPeriodBegins = 0L;
    private long lastTotal = 0L;
    private long lastCount = 0L;
    private double average;
    private int n;

    PeriodicStats() {
        this(System.currentTimeMillis());
    }

    PeriodicStats(long now) {
        this.nextPeriodBegins = this.computeStartOfNextPeriod(now);
    }

    void update(long now, long total) {
        if (now > this.nextPeriodBegins) {
            this.lastCount = total - this.lastTotal;
            this.lastTotal = total;
            this.average = (this.average * (double)this.n + (double)this.lastCount) / (double)(++this.n);
            this.nextPeriodBegins = this.computeStartOfNextPeriod(now);
        }
    }

    public double getAverage() {
        return this.average;
    }

    public long getLastCount() {
        return this.lastCount;
    }

    void reset(long now) {
        this.nextPeriodBegins = this.computeStartOfNextPeriod(now);
        this.lastTotal = 0L;
        this.lastCount = 0L;
        this.average = 0.0;
        this.n = 0;
    }

    void reset() {
        this.reset(System.currentTimeMillis());
    }

    abstract long computeStartOfNextPeriod(long var1);
}

