/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

public enum JmsConnectionExtensions {
    SSL_CONTEXT("sslContext"),
    USERNAME_OVERRIDE("username"),
    PASSWORD_OVERRIDE("password"),
    HTTP_HEADERS_OVERRIDE("httpHeaders"),
    PROXY_HANDLER_SUPPLIER("proxyHandlerSupplier"),
    AMQP_OPEN_PROPERTIES("amqpOpenProperties");

    private final String extensionKey;

    private JmsConnectionExtensions(String key) {
        this.extensionKey = key;
    }

    public String toString() {
        return this.extensionKey;
    }

    public static JmsConnectionExtensions fromString(String extensionName) {
        for (JmsConnectionExtensions ext : JmsConnectionExtensions.values()) {
            if (ext.extensionKey.equalsIgnoreCase(extensionName)) {
                return ext;
            }
            if (!ext.toString().equalsIgnoreCase(extensionName)) continue;
            return ext;
        }
        throw new IllegalArgumentException("No Extension with name " + extensionName + " found");
    }
}

