/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handlers;

import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedAttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedAttachmentDeletedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedCommentCreatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedCommentDeletedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedCommentUpdatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedTaskStatusChangeEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedTaskStatusLineUpdated;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentDeletedEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentEvent;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentDeletedEvent;
import com.xebialabs.xlrelease.domain.events.CommentEvent;
import com.xebialabs.xlrelease.domain.events.CommentUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskExecutionEvent;
import com.xebialabs.xlrelease.domain.events.TaskStatusLineUpdated;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.service.BroadcastService;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0002\u0005\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u0003:\u0001\u0011%!\bC\u0003K\u0001\u0011%1\nC\u0003Q\u0001\u0011%\u0011KA\fESN$(/\u001b2vi\u0016$WI^3oi\u0006#\u0017\r\u001d;fe*\u0011\u0011BC\u0001\tQ\u0006tG\r\\3sg*\u00111\u0002D\u0001\u0007KZ,g\u000e^:\u000b\u00055q\u0011!\u0003=me\u0016dW-Y:f\u0015\ty\u0001#A\u0005yK\nL\u0017\r\\1cg*\t\u0011#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\f\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u0005qyR\"A\u000f\u000b\u0005ya\u0011aB:feZL7-Z\u0005\u0003Au\u0011\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t\u0001\u0002C\u0003\u001b\u0005\u0001\u00071$A\u0004p]\u00163XM\u001c;\u0015\u0005!Z\u0003CA\u000b*\u0013\tQcC\u0001\u0003V]&$\b\"\u0002\u0017\u0004\u0001\u0004i\u0013!B3wK:$\bC\u0001\u00183\u001b\u0005y#BA\u00061\u0015\t\tD\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003g=\u0012a\u0002\u0017'SK2,\u0017m]3Fm\u0016tG\u000f\u000b\u0002\u0004kA\u0011agN\u0007\u0002\u0015%\u0011\u0001H\u0003\u0002\u000f\u0003NLhnY*vEN\u001c'/\u001b2f\u0003Eyg.\u0011;uC\u000eDW.\u001a8u\u000bZ,g\u000e\u001e\u000b\u0003w\u0015\u00032!\u0006\u001f?\u0013\tidC\u0001\u0004PaRLwN\u001c\t\u0003\u007f\rk\u0011\u0001\u0011\u0006\u0003\u0017\u0005S!A\u0011\u0019\u0002\u0017\u0011L7\u000f\u001e:jEV$X\rZ\u0005\u0003\t\u0002\u0013\u0011\u0004R5tiJL'-\u001e;fIbc%+\u001a7fCN,WI^3oi\")a\t\u0002a\u0001\u000f\u0006\tQ\r\u0005\u0002/\u0011&\u0011\u0011j\f\u0002\u0010\u0003R$\u0018m\u00195nK:$XI^3oi\u0006qqN\\\"p[6,g\u000e^#wK:$HCA\u001eM\u0011\u00151U\u00011\u0001N!\tqc*\u0003\u0002P_\ta1i\\7nK:$XI^3oi\u0006!rN\\\"p]\u001aLw-\u001e:bi&|g.\u0012<f]R$\"a\u000f*\t\u000b\u00193\u0001\u0019A*\u0011\u00059\"\u0016BA+0\u0005I\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u00163XM\u001c;)\u0005\u00019\u0006C\u0001-`\u001b\u0005I&B\u0001.\\\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u00039v\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002=\u0006\u0019qN]4\n\u0005\u0001L&!C\"p[B|g.\u001a8uQ\t\u0001!\r\u0005\u00027G&\u0011AM\u0003\u0002\u000e\u000bZ,g\u000e\u001e'jgR,g.\u001a:")
public class DistributedEventAdapter {
    private final BroadcastService broadcastService;

    @AsyncSubscribe
    public void onEvent(XLReleaseEvent event) {
        Some some;
        XLReleaseEvent xLReleaseEvent = event;
        if (xLReleaseEvent instanceof DistributedXLReleaseEvent) {
            some = None$.MODULE$;
        } else if (xLReleaseEvent instanceof ConfigurationEvent) {
            ConfigurationEvent configurationEvent = (ConfigurationEvent)xLReleaseEvent;
            some = this.onConfigurationEvent(configurationEvent);
        } else if (xLReleaseEvent instanceof AttachmentEvent) {
            AttachmentEvent attachmentEvent = (AttachmentEvent)xLReleaseEvent;
            some = this.onAttachmentEvent(attachmentEvent);
        } else if (xLReleaseEvent instanceof CommentEvent) {
            CommentEvent commentEvent = (CommentEvent)xLReleaseEvent;
            some = this.onCommentEvent(commentEvent);
        } else if (xLReleaseEvent instanceof TaskStatusLineUpdated) {
            TaskStatusLineUpdated taskStatusLineUpdated = (TaskStatusLineUpdated)xLReleaseEvent;
            some = new Some((Object)new DistributedTaskStatusLineUpdated(taskStatusLineUpdated.taskId(), taskStatusLineUpdated.statusLine()));
        } else if (xLReleaseEvent instanceof TaskExecutionEvent) {
            TaskExecutionEvent taskExecutionEvent = (TaskExecutionEvent)xLReleaseEvent;
            some = new Some((Object)new DistributedTaskStatusChangeEvent(taskExecutionEvent.task().getId(), taskExecutionEvent.task().getStatus()));
        } else {
            some = None$.MODULE$;
        }
        Some clusterEvent = some;
        clusterEvent.foreach((Function1 & Serializable)e -> {
            this.broadcastService.broadcast(e, true);
            return BoxedUnit.UNIT;
        });
    }

    private Option<DistributedXLReleaseEvent> onAttachmentEvent(AttachmentEvent e) {
        AttachmentEvent attachmentEvent = e;
        if (attachmentEvent instanceof AttachmentCreatedEvent) {
            AttachmentCreatedEvent attachmentCreatedEvent = (AttachmentCreatedEvent)attachmentEvent;
            String containerId = attachmentCreatedEvent.containerId();
            Attachment attachment = attachmentCreatedEvent.attachment();
            return new Some((Object)new DistributedAttachmentCreatedEvent(containerId, attachment.getId()));
        }
        if (attachmentEvent instanceof AttachmentDeletedEvent) {
            AttachmentDeletedEvent attachmentDeletedEvent = (AttachmentDeletedEvent)attachmentEvent;
            String containerId = attachmentDeletedEvent.containerId();
            Attachment attachment = attachmentDeletedEvent.attachment();
            return new Some((Object)new DistributedAttachmentDeletedEvent(containerId, attachment.getId()));
        }
        throw new MatchError((Object)attachmentEvent);
    }

    private Option<DistributedXLReleaseEvent> onCommentEvent(CommentEvent e) {
        CommentEvent commentEvent = e;
        if (commentEvent instanceof CommentCreatedEvent) {
            CommentCreatedEvent commentCreatedEvent = (CommentCreatedEvent)commentEvent;
            Task task = commentCreatedEvent.task();
            Comment comment = commentCreatedEvent.comment();
            return new Some((Object)new DistributedCommentCreatedEvent(task.getId(), comment.getId()));
        }
        if (commentEvent instanceof CommentUpdatedEvent) {
            CommentUpdatedEvent commentUpdatedEvent = (CommentUpdatedEvent)commentEvent;
            Task task = commentUpdatedEvent.task();
            Comment updated = commentUpdatedEvent.updated();
            return new Some((Object)new DistributedCommentUpdatedEvent(task.getId(), updated.getId()));
        }
        if (commentEvent instanceof CommentDeletedEvent) {
            CommentDeletedEvent commentDeletedEvent = (CommentDeletedEvent)commentEvent;
            Task task = commentDeletedEvent.task();
            Comment comment = commentDeletedEvent.comment();
            return new Some((Object)new DistributedCommentDeletedEvent(task.getId(), comment.getId()));
        }
        throw new MatchError((Object)commentEvent);
    }

    private Option<DistributedXLReleaseEvent> onConfigurationEvent(ConfigurationEvent e) {
        ConfigurationEvent configurationEvent = e;
        if (configurationEvent instanceof ConfigurationCreatedEvent) {
            ConfigurationCreatedEvent configurationCreatedEvent = (ConfigurationCreatedEvent)configurationEvent;
            BaseConfiguration conf = configurationCreatedEvent.conf();
            return new Some((Object)new DistributedConfigurationCreatedEvent(conf.getType().toString(), conf.getId()));
        }
        if (configurationEvent instanceof ConfigurationUpdatedEvent) {
            ConfigurationUpdatedEvent configurationUpdatedEvent = (ConfigurationUpdatedEvent)configurationEvent;
            BaseConfiguration updated = configurationUpdatedEvent.updated();
            return new Some((Object)new DistributedConfigurationUpdatedEvent(updated.getType().toString(), updated.getId()));
        }
        if (configurationEvent instanceof ConfigurationDeletedEvent) {
            ConfigurationDeletedEvent configurationDeletedEvent = (ConfigurationDeletedEvent)configurationEvent;
            BaseConfiguration conf = configurationDeletedEvent.conf();
            return new Some((Object)new DistributedConfigurationDeletedEvent(conf.getType().toString(), conf.getId()));
        }
        if (configurationEvent instanceof ConfigurationCopiedEvent) {
            ConfigurationCopiedEvent configurationCopiedEvent = (ConfigurationCopiedEvent)configurationEvent;
            BaseConfiguration original = configurationCopiedEvent.original();
            String newId = configurationCopiedEvent.newId();
            return new Some((Object)new DistributedConfigurationCopiedEvent(original.getType().toString(), original.getId(), newId));
        }
        throw new MatchError((Object)configurationEvent);
    }

    public DistributedEventAdapter(BroadcastService broadcastService) {
        this.broadcastService = broadcastService;
    }
}

