/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.handlers;

import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.domain.events.UserTokenAboutToExpireEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.UserTokenAboutToExpire;
import java.time.Duration;
import java.time.Instant;
import org.springframework.stereotype.Component;
import scala.reflect.ScalaSignature;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u00153A\u0001B\u0003\u0001!!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004C\u0003\u001d\u0001\u0011\u0005Q\u0004C\u0003\"\u0001\u0011\u0005!EA\u0011Vg\u0016\u0014Hk\\6f]:{G/\u001b4jG\u0006$\u0018n\u001c8Fm\u0016tG\u000fS1oI2,'O\u0003\u0002\u0007\u000f\u0005A\u0001.\u00198eY\u0016\u00148O\u0003\u0002\t\u0013\u0005ian\u001c;jM&\u001c\u0017\r^5p]NT!AC\u0006\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0007\u000e\u0003%AXMY5bY\u0006\u00147OC\u0001\u000f\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VMZ\u0001\u0014]>$\u0018NZ5dCRLwN\\*feZL7-\u001a\t\u00033ii\u0011aB\u0005\u00037\u001d\u00111CT8uS\u001aL7-\u0019;j_:\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDC\u0001\u0010!!\ty\u0002!D\u0001\u0006\u0011\u00159\"\u00011\u0001\u0019\u0003ayg.V:feR{7.\u001a8BE>,H\u000fV8FqBL'/\u001a\u000b\u0003G\u0019\u0002\"A\u0005\u0013\n\u0005\u0015\u001a\"\u0001B+oSRDQaJ\u0002A\u0002!\nQ!\u001a<f]R\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\r\u00154XM\u001c;t\u0015\ti\u0013\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003_)\u00121$V:feR{7.\u001a8BE>,H\u000fV8FqBL'/Z#wK:$\bFA\u00022!\t\u0011D'D\u00014\u0015\tY\u0013\"\u0003\u00026g\tq\u0011i]=oGN+(m]2sS\n,\u0007F\u0001\u00018!\t\u0011\u0004(\u0003\u0002:g\tiQI^3oi2K7\u000f^3oKJD#\u0001A\u001e\u0011\u0005q\u001aU\"A\u001f\u000b\u0005yz\u0014AC:uKJ,w\u000e^=qK*\u0011\u0001)Q\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!)A\u0002pe\u001eL!\u0001R\u001f\u0003\u0013\r{W\u000e]8oK:$\b")
public class UserTokenNotificationEventHandler {
    private final NotificationService notificationService;

    @AsyncSubscribe
    public void onUserTokenAboutToExpire(UserTokenAboutToExpireEvent event) {
        UserToken userToken = event.userToken();
        long expirationDurationInHours = Duration.between(Instant.now(), userToken.expiryDate().toInstant()).toHours();
        this.notificationService.notify(new UserTokenAboutToExpire(userToken.username(), userToken.tokenNote(), expirationDurationInHours));
    }

    public UserTokenNotificationEventHandler(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

