/*
 * Decompiled with CFR 0.152.
 */
package com.xhaus.jyson;

import com.xhaus.jyson.JSONDecodeError;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PyUnicode;

public class JysonDecoder {
    public boolean accept_any_primary_datum = false;
    public boolean accept_dangling_commas = false;
    public boolean accept_shell_style_comments = false;
    public boolean accept_single_quoted_strings = false;
    public boolean accept_hex_char_escapes = false;
    public boolean accept_hexadecimal_integers = false;
    public boolean accept_octal_integers = false;
    public boolean accept_junk_after_data = false;
    protected int curr_pos = 0;
    protected String json_text;

    protected JysonDecoder(String string) {
        this.json_text = string;
    }

    private void reset_defaults() {
        this.accept_any_primary_datum = false;
        this.accept_dangling_commas = false;
        this.accept_shell_style_comments = false;
        this.accept_single_quoted_strings = false;
        this.accept_hex_char_escapes = false;
        this.accept_hexadecimal_integers = false;
        this.accept_octal_integers = false;
        this.accept_junk_after_data = false;
    }

    public void strict_mode() {
        this.reset_defaults();
    }

    public void permissive_mode() {
        this.accept_any_primary_datum = true;
        this.accept_dangling_commas = true;
        this.accept_shell_style_comments = true;
        this.accept_single_quoted_strings = true;
        this.accept_hex_char_escapes = true;
        this.accept_hexadecimal_integers = true;
        this.accept_octal_integers = true;
        this.accept_junk_after_data = true;
    }

    protected void push() {
        if (this.curr_pos > 0) {
            --this.curr_pos;
        }
    }

    protected char get_char() {
        if (this.curr_pos < this.json_text.length()) {
            return this.json_text.charAt(this.curr_pos++);
        }
        return '\u0000';
    }

    protected String get_chars(int n, String string) throws JSONDecodeError {
        try {
            String string2 = this.json_text.substring(this.curr_pos, this.curr_pos + n);
            this.curr_pos += n;
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.decode_exception("Ran out of characters reading " + string);
        }
    }

    protected char get_data_char() throws JSONDecodeError {
        block9: while (true) {
            char c = this.get_char();
            block0 : switch (c) {
                case '/': {
                    switch (this.get_char()) {
                        case '/': {
                            while ((c = this.get_char()) != '\n' && c != '\r' && c != '\u0000') {
                            }
                            while (c == '\n' || c == '\r') {
                                c = this.get_char();
                            }
                            if (c == '\u0000') continue block9;
                            this.push();
                            break block0;
                        }
                        case '*': {
                            while (true) {
                                if ((c = this.get_char()) == '\u0000') {
                                    throw this.decode_exception("Unclosed comment.");
                                }
                                if (c != '*') continue;
                                if (this.get_char() == '/') continue block9;
                                this.push();
                            }
                        }
                        default: {
                            this.push();
                            return '/';
                        }
                    }
                }
                case '#': {
                    if (this.accept_shell_style_comments) {
                        while ((c = this.get_char()) != '\n' && c != '\r' && c != '\u0000') {
                        }
                        while (c == '\n' || c == '\r') {
                            c = this.get_char();
                        }
                        if (c == '\u0000') continue block9;
                        this.push();
                        break;
                    }
                    throw this.decode_exception("Shell style comments are not accepted");
                }
                case '\u0000': {
                    return c;
                }
                default: {
                    if (c <= ' ') continue block9;
                    return c;
                }
            }
        }
    }

    protected String get_string(char c) throws JSONDecodeError {
        StringBuffer stringBuffer = new StringBuffer();
        block19: while (true) {
            char c2 = this.get_char();
            switch (c2) {
                case '\\': {
                    c2 = this.get_char();
                    switch (c2) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block19;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block19;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block19;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block19;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block19;
                        }
                        case '\\': {
                            stringBuffer.append('\\');
                            continue block19;
                        }
                        case '\"': {
                            stringBuffer.append('\"');
                            continue block19;
                        }
                        case '/': {
                            stringBuffer.append('/');
                            continue block19;
                        }
                        case 'u': {
                            String string = this.get_chars(4, "Unicode escape");
                            try {
                                stringBuffer.append((char)Integer.parseInt(string, 16));
                                continue block19;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw this.decode_exception("Illegal character in unicode hex constant: " + string);
                            }
                        }
                        case 'x': {
                            if (this.accept_hex_char_escapes) {
                                stringBuffer.append((char)Integer.parseInt(this.get_chars(2, "Hexadecimal escape"), 16));
                                continue block19;
                            }
                            throw this.decode_exception("Hexadecimal escapes for characters are not accepted");
                        }
                    }
                    throw this.decode_exception("Illegal escape character: '" + c2 + "'");
                }
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.decode_exception("Line terminators must be escaped inside strings");
                }
                case '\"': 
                case '\'': {
                    if (c2 != c) break;
                    return stringBuffer.toString();
                }
            }
            stringBuffer.append(c2);
        }
    }

    protected PyObject decode_constant(String string) throws JSONDecodeError {
        if (string.compareTo("true") == 0) {
            return Py.True;
        }
        if (string.compareTo("false") == 0) {
            return Py.False;
        }
        if (string.compareTo("null") == 0) {
            return Py.None;
        }
        if (string.length() == 0) {
            throw this.decode_exception("No value specified");
        }
        return null;
    }

    protected PyObject decode_number(String string) throws JSONDecodeError {
        char c = string.charAt(0);
        if (Character.isDigit(c) || ".-+".indexOf(c) != -1) {
            String string2;
            if (c == '0' && string.length() > 1) {
                if (string.charAt(1) == 'x' || string.charAt(1) == 'X') {
                    if (this.accept_hexadecimal_integers) {
                        String string3 = string.substring(2);
                        try {
                            return new PyInteger(Integer.parseInt(string3, 16));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.decode_exception("Format error in hexadecimal constant: " + string3);
                        }
                    }
                    throw this.decode_exception("Hexadecimal integers are not accepted.");
                }
                if (string.charAt(1) != '.') {
                    if (this.accept_octal_integers) {
                        try {
                            return new PyInteger(Integer.parseInt(string, 8));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.decode_exception("Format error in octal constant: " + string);
                        }
                    }
                    throw this.decode_exception("Octal integers are not accepted.");
                }
            }
            if ((string2 = string).charAt(0) == '+') {
                string2 = string2.substring(1);
            }
            try {
                return new PyInteger(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                try {
                    return new PyLong(string2);
                }
                catch (Exception exception2) {
                    try {
                        double d = Double.parseDouble(string2);
                        return new PyFloat(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    protected PyStringMap get_json_object() throws JSONDecodeError {
        PyStringMap pyStringMap = new PyStringMap();
        block10: while (true) {
            String string;
            char c = this.get_data_char();
            switch (c) {
                case '\u0000': {
                    throw this.decode_exception("A JSON object must end with '}'");
                }
                case '}': {
                    return pyStringMap;
                }
                case '\'': {
                    if (this.accept_single_quoted_strings) {
                        string = this.get_string('\'');
                        break;
                    }
                    throw this.decode_exception("Single quoted strings are not acceptable in JSON");
                }
                case '\"': {
                    string = this.get_string('\"');
                    break;
                }
                default: {
                    throw this.decode_exception("Only strings are acceptable as object keys in JSON");
                }
            }
            c = this.get_data_char();
            if (c != ':') {
                throw this.decode_exception("Object keys and values must be separated by ':'");
            }
            PyObject pyObject = this.get_object();
            pyStringMap.__setitem__((PyObject)new PyUnicode(string), pyObject);
            switch (this.get_data_char()) {
                case ',': {
                    if (this.get_data_char() == '}') {
                        if (this.accept_dangling_commas) {
                            return pyStringMap;
                        }
                        throw this.decode_exception("Commas after last entry of object not accepted");
                    }
                    this.push();
                    continue block10;
                }
                case '}': {
                    return pyStringMap;
                }
            }
            break;
        }
        throw this.decode_exception("Expected a ',' or '}'");
    }

    protected PyList get_json_array() throws JSONDecodeError {
        char c = this.get_data_char();
        if (c == '\u0000') {
            throw this.decode_exception("Ran out of characters reading array");
        }
        PyList pyList = new PyList();
        if (c == ']') {
            return pyList;
        }
        this.push();
        block5: while (true) {
            if (this.get_data_char() == ',') {
                throw this.decode_exception("Arrays may not contain consecutive or dangling commas");
            }
            this.push();
            pyList.append(this.get_object());
            switch (this.get_data_char()) {
                case '\u0000': {
                    throw this.decode_exception("Ran out of characters reading array");
                }
                case ',': {
                    if (this.get_data_char() == ']') {
                        if (this.accept_dangling_commas) {
                            return pyList;
                        }
                        throw this.decode_exception("Commas after last element of array not accepted");
                    }
                    this.push();
                    continue block5;
                }
                case ']': {
                    return pyList;
                }
            }
            break;
        }
        throw this.decode_exception("Array elements must be followed by ',' or ']'");
    }

    protected PyObject get_object() throws JSONDecodeError {
        String string;
        PyObject pyObject;
        char c = this.get_data_char();
        switch (c) {
            case '{': {
                return this.get_json_object();
            }
            case '[': {
                return this.get_json_array();
            }
            case '\"': {
                return new PyUnicode(this.get_string(c));
            }
            case '\'': {
                if (this.accept_single_quoted_strings) {
                    return new PyUnicode(this.get_string(c));
                }
                throw this.decode_exception("Single quoted strings are not accepted");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (c >= ' ' && ",:]}/\\[{#".indexOf(c) == -1) {
            stringBuffer.append(c);
            c = this.get_char();
        }
        if (c != '\u0000') {
            this.push();
        }
        if ((pyObject = this.decode_constant(string = stringBuffer.toString().trim())) != null) {
            return pyObject;
        }
        pyObject = this.decode_number(string);
        if (pyObject != null) {
            return pyObject;
        }
        throw this.decode_exception("Unable to decode '" + string + "'");
    }

    protected PyObject get_top_level_object() throws JSONDecodeError {
        PyObject pyObject = this.get_object();
        if (!(pyObject instanceof PyStringMap || pyObject instanceof PyList || this.accept_any_primary_datum)) {
            throw this.decode_exception("JSON expressions must strictly be either objects or lists");
        }
        char c = this.get_data_char();
        if (c != '\u0000' && !this.accept_junk_after_data) {
            throw this.decode_exception("Only whitespace is permitted after the primary datum: not '" + c + "'");
        }
        return pyObject;
    }

    protected JSONDecodeError decode_exception(String string) {
        return new JSONDecodeError(string + ": position=" + this.curr_pos);
    }
}

