/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import java.util.regex.Matcher;
import org.jparsec.internal.util.Checks;
import org.jparsec.pattern.CharPredicate;
import org.jparsec.pattern.CharPredicates;
import org.jparsec.pattern.OptionalPattern;
import org.jparsec.pattern.OrPattern;
import org.jparsec.pattern.Pattern;
import org.jparsec.pattern.RepeatCharPredicatePattern;
import org.jparsec.pattern.SequencePattern;

public final class Patterns {
    public static final Pattern NEVER = new Pattern(){

        @Override
        public int match(CharSequence src, int begin, int end) {
            return -1;
        }

        public String toString() {
            return "<>";
        }
    };
    public static final Pattern ALWAYS = new Pattern(){

        @Override
        public int match(CharSequence src, int begin, int end) {
            return 0;
        }
    };
    public static final Pattern ANY_CHAR = Patterns.hasAtLeast(1);
    public static final Pattern EOF = Patterns.hasExact(0);
    public static final Pattern ESCAPED = new Pattern(){

        @Override
        public int match(CharSequence src, int begin, int end) {
            if (begin >= end - 1) {
                return -1;
            }
            if (src.charAt(begin) == '\\') {
                return 2;
            }
            return -1;
        }
    };
    public static final Pattern INTEGER = Patterns.many1(CharPredicates.IS_DIGIT);
    public static final Pattern STRICT_DECIMAL = INTEGER.next(Patterns.isChar('.').next(Patterns.many(CharPredicates.IS_DIGIT)).optional());
    public static final Pattern FRACTION = Patterns.isChar('.').next(INTEGER);
    public static final Pattern DECIMAL = STRICT_DECIMAL.or(FRACTION);
    public static final Pattern WORD = Patterns.isChar(CharPredicates.IS_ALPHA_).next(Patterns.isChar(CharPredicates.IS_ALPHA_NUMERIC_).many());
    public static final Pattern OCT_INTEGER = Patterns.isChar('0').next(Patterns.many(CharPredicates.range('0', '7')));
    public static final Pattern DEC_INTEGER = Patterns.sequence(Patterns.range('1', '9'), Patterns.many(CharPredicates.IS_DIGIT));
    public static final Pattern HEX_INTEGER = Patterns.string("0x").or(Patterns.string("0X")).next(Patterns.many1(CharPredicates.IS_HEX_DIGIT));
    public static final Pattern SCIENTIFIC_NOTATION = Patterns.sequence(DECIMAL, Patterns.among("eE"), Patterns.among("+-").optional(), INTEGER);
    public static final Pattern REGEXP_PATTERN = Patterns.getRegularExpressionPattern();
    public static final Pattern REGEXP_MODIFIERS = Patterns.getModifiersPattern();

    private Patterns() {
    }

    public static Pattern hasAtLeast(final int n) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                if (begin + n > end) {
                    return -1;
                }
                return n;
            }

            public String toString() {
                return ".{" + n + ",}";
            }
        };
    }

    public static Pattern hasExact(final int n) {
        Checks.checkNonNegative(n, "n < 0");
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                if (begin + n != end) {
                    return -1;
                }
                return n;
            }

            public String toString() {
                return ".{" + n + "}";
            }
        };
    }

    public static Pattern isChar(char c) {
        return Patterns.isChar(CharPredicates.isChar(c));
    }

    public static Pattern range(char c1, char c2) {
        return Patterns.isChar(CharPredicates.range(c1, c2));
    }

    public static Pattern among(String chars) {
        return Patterns.isChar(CharPredicates.among(chars));
    }

    public static Pattern isChar(final CharPredicate predicate) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                if (begin >= end) {
                    return -1;
                }
                if (predicate.isChar(src.charAt(begin))) {
                    return 1;
                }
                return -1;
            }

            public String toString() {
                return predicate.toString();
            }
        };
    }

    public static Pattern lineComment(String begin) {
        return Patterns.string(begin).next(Patterns.many(CharPredicates.notChar('\n')));
    }

    public static Pattern string(final String string) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                if (end - begin < string.length()) {
                    return -1;
                }
                return Patterns.matchString(string, src, begin, end);
            }

            public String toString() {
                return string;
            }
        };
    }

    public static Pattern stringCaseInsensitive(final String string) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchStringCaseInsensitive(string, src, begin, end);
            }

            public String toString() {
                return string.toUpperCase();
            }
        };
    }

    public static Pattern notString(final String string) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                if (begin >= end) {
                    return -1;
                }
                int matchedLength = Patterns.matchString(string, src, begin, end);
                if (matchedLength == -1 || matchedLength < string.length()) {
                    return 1;
                }
                return -1;
            }

            public String toString() {
                return "!(" + string + ")";
            }
        };
    }

    public static Pattern notStringCaseInsensitive(final String string) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                if (begin >= end) {
                    return -1;
                }
                if (Patterns.matchStringCaseInsensitive(string, src, begin, end) == -1) {
                    return 1;
                }
                return -1;
            }

            public String toString() {
                return "!(" + string.toUpperCase() + ")";
            }
        };
    }

    public static Pattern not(Pattern pattern) {
        return pattern.not();
    }

    public static Pattern and(final Pattern ... patterns) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                int ret = 0;
                for (Pattern pattern : patterns) {
                    int l = pattern.match(src, begin, end);
                    if (l == -1) {
                        return -1;
                    }
                    if (l <= ret) continue;
                    ret = l;
                }
                return ret;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append('(');
                for (Pattern pattern : patterns) {
                    sb.append(pattern).append(" & ");
                }
                if (sb.length() > 1) {
                    sb.delete(sb.length() - 3, sb.length());
                }
                return sb.append(')').toString();
            }
        };
    }

    public static Pattern or(Pattern ... patterns) {
        return new OrPattern(patterns);
    }

    static Pattern orWithoutEmpty(Pattern left, Pattern right) {
        if (right == NEVER) {
            return left;
        }
        if (left == NEVER) {
            return right;
        }
        return left.or(right);
    }

    static Pattern nextWithEmpty(Pattern left, Pattern right) {
        if (right == NEVER) {
            return NEVER;
        }
        if (left == NEVER) {
            return NEVER;
        }
        return left.next(right);
    }

    public static Pattern sequence(Pattern ... patterns) {
        return new SequencePattern(patterns);
    }

    public static Pattern repeat(int n, CharPredicate predicate) {
        Checks.checkNonNegative(n, "n < 0");
        return new RepeatCharPredicatePattern(n, predicate);
    }

    @Deprecated
    public static Pattern many(int min, CharPredicate predicate) {
        return Patterns.atLeast(min, predicate);
    }

    public static Pattern atLeast(final int min, final CharPredicate predicate) {
        Checks.checkMin(min);
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                int minLen = RepeatCharPredicatePattern.matchRepeat(min, predicate, src, end, begin, 0);
                if (minLen == -1) {
                    return -1;
                }
                return Patterns.matchMany(predicate, src, end, begin + minLen, minLen);
            }

            public String toString() {
                return min > 1 ? predicate + "{" + min + ",}" : predicate + "+";
            }
        };
    }

    public static Pattern many(final CharPredicate predicate) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchMany(predicate, src, end, begin, 0);
            }

            public String toString() {
                return predicate + "*";
            }
        };
    }

    @Deprecated
    public static Pattern some(int min, int max, CharPredicate predicate) {
        return Patterns.times(min, max, predicate);
    }

    public static Pattern times(final int min, final int max, final CharPredicate predicate) {
        Checks.checkMinMax(min, max);
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                int minLen = RepeatCharPredicatePattern.matchRepeat(min, predicate, src, end, begin, 0);
                if (minLen == -1) {
                    return -1;
                }
                return Patterns.matchSome(max - min, predicate, src, end, begin + minLen, minLen);
            }
        };
    }

    @Deprecated
    public static Pattern some(int max, CharPredicate predicate) {
        return Patterns.atMost(max, predicate);
    }

    public static Pattern atMost(final int max, final CharPredicate predicate) {
        Checks.checkMax(max);
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchSome(max, predicate, src, end, begin, 0);
            }
        };
    }

    public static Pattern longer(Pattern p1, Pattern p2) {
        return Patterns.longest(p1, p2);
    }

    public static Pattern longest(final Pattern ... patterns) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                int r = -1;
                for (Pattern pattern : patterns) {
                    int l = pattern.match(src, begin, end);
                    if (l <= r) continue;
                    r = l;
                }
                return r;
            }
        };
    }

    public static Pattern shorter(Pattern p1, Pattern p2) {
        return Patterns.shortest(p1, p2);
    }

    public static Pattern shortest(final Pattern ... patterns) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                int r = -1;
                for (Pattern pattern : patterns) {
                    int l = pattern.match(src, begin, end);
                    if (l == -1 || r != -1 && l >= r) continue;
                    r = l;
                }
                return r;
            }
        };
    }

    public static Pattern many1(CharPredicate predicate) {
        return Patterns.atLeast(1, predicate);
    }

    public static Pattern regex(final java.util.regex.Pattern p) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                if (begin > end) {
                    return -1;
                }
                Matcher matcher = p.matcher(src.subSequence(begin, end));
                if (matcher.lookingAt()) {
                    return matcher.end();
                }
                return -1;
            }
        };
    }

    public static Pattern regex(String s) {
        return Patterns.regex(java.util.regex.Pattern.compile(s));
    }

    static Pattern optional(Pattern pp) {
        return new OptionalPattern(pp);
    }

    private static int matchSome(int max, CharPredicate predicate, CharSequence src, int len, int from, int acc) {
        int k = Math.min(max + from, len);
        for (int i = from; i < k; ++i) {
            if (predicate.isChar(src.charAt(i))) continue;
            return i - from + acc;
        }
        return k - from + acc;
    }

    private static Pattern getRegularExpressionPattern() {
        Pattern quote = Patterns.isChar('/');
        Pattern escape = Patterns.isChar('\\').next(Patterns.hasAtLeast(1));
        Pattern content = Patterns.or(escape, Patterns.isChar(CharPredicates.notAmong("/\r\n\\")));
        return quote.next(content.many()).next(quote);
    }

    private static Pattern getModifiersPattern() {
        return Patterns.isChar(CharPredicates.IS_ALPHA).many();
    }

    private static int matchMany(CharPredicate predicate, CharSequence src, int len, int from, int acc) {
        for (int i = from; i < len; ++i) {
            if (predicate.isChar(src.charAt(i))) continue;
            return i - from + acc;
        }
        return len - from + acc;
    }

    private static int matchStringCaseInsensitive(String str, CharSequence src, int begin, int end) {
        int patternLength = str.length();
        if (end - begin < patternLength) {
            return -1;
        }
        for (int i = 0; i < patternLength; ++i) {
            char exp = str.charAt(i);
            char enc = src.charAt(begin + i);
            if (Character.toLowerCase(exp) == Character.toLowerCase(enc)) continue;
            return -1;
        }
        return patternLength;
    }

    private static int matchString(String str, CharSequence src, int begin, int end) {
        int i;
        int patternLength = str.length();
        for (i = 0; i < patternLength && begin + i < end; ++i) {
            char enc;
            char exp = str.charAt(i);
            if (exp == (enc = src.charAt(begin + i))) continue;
            return -1;
        }
        return i;
    }
}

