import React from 'react';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mountComponentWithStore } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { FolderExternalDeploymentsPage } from './folder-external-deployments';
import { FolderExternalDeploymentsWrapper } from './folder-external-deployments-wrapper.component';

describe('FolderExternalDeploymentsPage component', () => {
    let wrapper: ReactWrapper;
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder' },
    };
    const mountComponent = () => {
        wrapper = mountComponentWithStore(<FolderExternalDeploymentsPage {...defaultProps} />);
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(FolderExternalDeploymentsWrapper)).toExist();
    });
});
