/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;

public class FileExtensionSelector
implements FileSelector {
    private final Set<String> extensions = new HashSet<String>();

    public FileExtensionSelector(Collection<String> extensions) {
        if (extensions != null) {
            this.extensions.addAll(extensions);
        }
    }

    public FileExtensionSelector(String ... extensions) {
        if (extensions != null) {
            this.extensions.addAll(Arrays.asList(extensions));
        }
    }

    @Override
    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
        for (String extension : this.extensions) {
            if (!fileInfo.getFile().getName().getExtension().equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
        return true;
    }
}

