/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import akka.actor.Address;
import com.codahale.metrics.InstrumentedExecutorService;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRecoveryLogic;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.Runner;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.service.JobService;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Marker;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\u0011\"\u0001)B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003A\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u00115\u0003!Q1A\u0005\u00029C\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t-\u0002\u0011)\u0019!C\u0001/\"Aa\f\u0001B\u0001B\u0003%\u0001\f\u0003\u0005`\u0001\t\u0015\r\u0011\"\u0001a\u0011!!\u0007A!A!\u0002\u0013\t\u0007\"B3\u0001\t\u00031\u0007\u0002C>\u0001\u0011\u000b\u0007I\u0011\u0002?\t\u0017\u0005\u0005\u0001\u00011AA\u0002\u0013%\u00111\u0001\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0002C\u0006\u0002(\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0001\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0011!\tI\u0004\u0001Q\u0001\n\u00055\u0002\"CA\u001e\u0001\t\u0007I\u0011BA\u001f\u0011!\t)\u0006\u0001Q\u0001\n\u0005}\u0002bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u00037\u0002A\u0011AA-\u0011\u001d\ti\u0006\u0001C\u0005\u00033Bq!a\u0018\u0001\t\u0013\tI\u0006C\u0004\u0002b\u0001!I!a\u0001\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002Z!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\t9\n\u0001C\u0001\u00033\u00131bV8sW6\u000bg.Y4fe*\u0011!eI\u0001\ng\u000eDW\rZ;mKJT!\u0001J\u0013\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0014(\u0003%AXMY5bY\u0006\u00147OC\u0001)\u0003\r\u0019w.\\\u0002\u0001'\r\u00011&\r\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u001aT\"A\u0011\n\u0005Q\n#\u0001\u0005&pEJ+7m\u001c<fefdunZ5d\u0003%AHN]\"p]\u001aLw-F\u00018!\tA4(D\u0001:\u0015\tQ4%\u0001\u0004d_:4\u0017nZ\u0005\u0003ye\u0012\u0011\u0002\u00177s\u0007>tg-[4\u0002\u0015ad'oQ8oM&<\u0007%\u0001\u0005k_\n\fV/Z;f+\u0005\u0001\u0005C\u0001\u001aB\u0013\t\u0011\u0015E\u0001\u0005K_\n\fV/Z;f\u0003%QwNY)vKV,\u0007%A\bd_6\u0004xn]5uK^{'o[3s+\u00051\u0005CA$K\u001b\u0005A%BA%\"\u0003\u001d9xN]6feNL!a\u0013%\u0003\u001f\r{W\u000e]8tSR,wk\u001c:lKJ\f\u0001cY8na>\u001c\u0018\u000e^3X_J\\WM\u001d\u0011\u0002\u0015)|'mU3sm&\u001cW-F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011\u0016%A\u0004tKJ4\u0018nY3\n\u0005Q\u000b&A\u0003&pEN+'O^5dK\u0006Y!n\u001c2TKJ4\u0018nY3!\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f+\u0005A\u0006CA-]\u001b\u0005Q&BA.$\u0003\u0019\t7\r^8sg&\u0011QL\u0017\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u0015e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\u0011\u0002#\u0005\u001cGo\u001c:TsN$X-\u001c%pY\u0012,'/F\u0001b!\tI&-\u0003\u0002d5\n\t\u0012i\u0019;peNK8\u000f^3n\u0011>dG-\u001a:\u0002%\u0005\u001cGo\u001c:TsN$X-\u001c%pY\u0012,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u001dD\u0017N[6m[B\u0011!\u0007\u0001\u0005\u0006k5\u0001\ra\u000e\u0005\u0006}5\u0001\r\u0001\u0011\u0005\u0006\t6\u0001\rA\u0012\u0005\u0006\u001b6\u0001\ra\u0014\u0005\u0006-6\u0001\r\u0001\u0017\u0005\u0006?6\u0001\r!\u0019\u0015\u0003[>\u0004\"\u0001]=\u000e\u0003ET!A]:\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002uk\u000691m\u001c8uKb$(B\u0001<x\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001=\u0002\u0007=\u0014x-\u0003\u0002{c\n!A*\u0019>z\u0003=i\u0017\r\u001f+ie\u0016\fGm]\"pk:$X#A?\u0011\u00051r\u0018BA@.\u0005\rIe\u000e^\u0001\u000bi\"\u0014X-\u00193Q_>dWCAA\u0003!\u0011\t9!!\u0006\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\ty!!\u0005\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003'\tAA[1wC&!\u0011qCA\u0005\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0004;ie\u0016\fG\rU8pY~#S-\u001d\u000b\u0005\u0003;\t\u0019\u0003E\u0002-\u0003?I1!!\t.\u0005\u0011)f.\u001b;\t\u0013\u0005\u0015\u0002#!AA\u0002\u0005\u0015\u0011a\u0001=%c\u0005YA\u000f\u001b:fC\u0012\u0004vn\u001c7!\u0003I\u0019\b.\u001e;e_^t\u0017J\u001c)s_\u001e\u0014Xm]:\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\t\u0005M\u0012\u0011B\u0001\u0007CR|W.[2\n\t\u0005]\u0012\u0011\u0007\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002'MDW\u000f\u001e3po:Le\u000e\u0015:pOJ,7o\u001d\u0011\u0002\u000fI,hN\\3sgV\u0011\u0011q\b\t\u0007\u0003\u0003\nY%a\u0014\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nq!\\;uC\ndWMC\u0002\u0002J5\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti%a\u0011\u0003\r\t+hMZ3s!\r\u0011\u0014\u0011K\u0005\u0004\u0003'\n#A\u0002*v]:,'/\u0001\u0005sk:tWM]:!\u0003\u0015\u0019H/\u0019:u)\t\ti\"A\u0006sK\u000e|g/\u001a:K_\n\u001c\u0018\u0001D:uCJ$H\u000b\u001b:fC\u0012\u001c\u0018\u0001B:u_B\fQbZ3u)\"\u0014X-\u00193Q_>d\u0017\u0001C:ikR$wn\u001e8\u0002#\r\fgnY3m%\u0016\u001cXM\u001d<fI*{'\r\u0006\u0003\u0002\u001e\u0005%\u0004bBA69\u0001\u0007\u0011QN\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005=\u0014Q\u0010\b\u0005\u0003c\nI\bE\u0002\u0002t5j!!!\u001e\u000b\u0007\u0005]\u0014&\u0001\u0004=e>|GOP\u0005\u0004\u0003wj\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0000\u0005\u0005%AB*ue&twMC\u0002\u0002|5\naa];c[&$H\u0003BA\u000f\u0003\u000fCq!!#\u001e\u0001\u0004\tY)A\u0002k_\n\u00042AMAG\u0013\r\ty)\t\u0002\u0004\u0015>\u0014\u0017a\u0002:fa2\f7-\u001a\u000b\u0005\u0003;\t)\nC\u0004\u0002\nz\u0001\r!a#\u0002!\u0005\u0014wN\u001d;K_\n\u0014\u0015\u0010V1tW&#G\u0003BA\u000f\u00037Cq!a\u001b \u0001\u0004\ti\u0007K\u0002\u0001\u0003?\u0003B!!)\u0002(6\u0011\u00111\u0015\u0006\u0004\u0003K+\u0018AC:uKJ,w\u000e^=qK&!\u0011\u0011VAR\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class WorkManager
implements JobRecoveryLogic {
    private int maxThreadsCount;
    private final XlrConfig xlrConfig;
    private final JobQueue jobQueue;
    private final CompositeWorker compositeWorker;
    private final JobService jobService;
    private final ReleaseActorService releaseActorService;
    private final ActorSystemHolder actorSystemHolder;
    private ExecutorService threadPool;
    private final AtomicBoolean shutdownInProgress;
    private final Buffer<Runner> runners;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public void recoverAllJobs() {
        JobRecoveryLogic.recoverAllJobs$(this);
    }

    @Override
    public void recoverJobs(String nodeId) {
        JobRecoveryLogic.recoverJobs$(this, nodeId);
    }

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.nodeId$lzycompute();
        }
        return this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    @Override
    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    public CompositeWorker compositeWorker() {
        return this.compositeWorker;
    }

    @Override
    public JobService jobService() {
        return this.jobService;
    }

    @Override
    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private int maxThreadsCount$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.maxThreadsCount = this.xlrConfig().executors().scheduler().maxThreadsCount();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.maxThreadsCount;
    }

    private int maxThreadsCount() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.maxThreadsCount$lzycompute();
        }
        return this.maxThreadsCount;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    private void threadPool_$eq(ExecutorService x$1) {
        this.threadPool = x$1;
    }

    private AtomicBoolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    private Buffer<Runner> runners() {
        return this.runners;
    }

    public void start() {
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(35).append("Starting work manager with ").append(this.maxThreadsCount()).append(" threads").toString());
        this.stop();
        this.jobQueue().cancelIf(x$2 -> true);
        this.jobQueue().start();
        if (this.xlrConfig().maintenanceModeEnabled()) {
            this.logger().debug((Function0 & Serializable)() -> "[MAINTENANCE MODE] Job recovery - DISABLED");
        } else {
            this.recoverJobs();
        }
        this.startThreads();
        this.logger().info((Function0 & Serializable)() -> "Started work manager");
    }

    public void recoverJobs() {
        try {
            this.logger().debug((Function0 & Serializable)() -> "Job recovery started");
            ClusterMode clusterMode = this.xlrConfig().cluster().mode();
            if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
                this.recoverAllJobs();
            } else {
                this.recoverJobs(this.nodeId());
                this.recoverJobs(null);
            }
            this.logger().debug((Function0 & Serializable)() -> "Job recovery completed, proceeding with startup");
        }
        catch (Throwable t) {
            this.logger().error((Function0 & Serializable)() -> "Job recovery failed", (Function0 & Serializable)() -> t);
        }
    }

    private void startThreads() {
        this.shutdownInProgress().set(false);
        this.threadPool_$eq(this.getThreadPool());
        this.runners().clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxThreadsCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            int n = x$3;
            Runner runner = new Runner(this.jobQueue(), this.compositeWorker());
            this.runners().$plus$eq((Object)runner);
            this.threadPool().execute(runner);
        });
    }

    private void stop() {
        this.runners().foreach((Function1 & Serializable)worker -> {
            worker.stop();
            return BoxedUnit.UNIT;
        });
        this.runners().clear();
        this.jobQueue().stop();
    }

    private ExecutorService getThreadPool() {
        ExecutorService executors = Executors.newFixedThreadPool(this.maxThreadsCount(), PrefixedThreadFactory$.MODULE$.apply("task-execution", PrefixedThreadFactory$.MODULE$.apply$default$2()));
        if (this.xlrConfig().metrics().enabled()) {
            return new InstrumentedExecutorService(executors, XlrMetricRegistry$.MODULE$.metricRegistry(), "taskExecution");
        }
        return executors;
    }

    public void shutdown() {
        if (this.shutdownInProgress().compareAndSet(false, true)) {
            this.logger().info((Function0 & Serializable)() -> "starting shutdown");
            this.stop();
            this.threadPool().shutdown();
            if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                this.logger().warn((Function0 & Serializable)() -> "There are tasks, that did not complete within shutdown grace period, going to interrupt those tasks");
                this.threadPool().shutdownNow();
                if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                    this.logger().error((Function0 & Serializable)() -> "There are tasks, that could not be interrupted, giving up");
                }
            }
            this.jobQueue().cancelIf(x$4 -> true);
            this.shutdownInProgress().set(false);
            return;
        }
        this.logger().info((Function0 & Serializable)() -> "skipping shutdown, because shutdown already happened or in progress");
    }

    public void cancelReservedJob(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("Cancelling reserved job ").append(taskId).toString());
        this.jobService().deleteByTaskId(taskId);
    }

    public void submit(Job job) {
        this.jobQueue().submit(job);
    }

    public void replace(Job job) {
        this.jobQueue().replace(job);
    }

    public void abortJobByTaskId(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Aborting scheduled job ").append(taskId).toString());
        this.jobService().deleteByTaskId(taskId);
        this.jobQueue().cancelIf(x0$1 -> {
            Job job = x0$1;
            if (job instanceof TaskJob) {
                TaskJob taskJob = (TaskJob)job;
                return taskJob.taskId().equals(taskId);
            }
            return false;
        });
    }

    public WorkManager(XlrConfig xlrConfig, JobQueue jobQueue, CompositeWorker compositeWorker, JobService jobService, ReleaseActorService releaseActorService, @Lazy ActorSystemHolder actorSystemHolder) {
        this.xlrConfig = xlrConfig;
        this.jobQueue = jobQueue;
        this.compositeWorker = compositeWorker;
        this.jobService = jobService;
        this.releaseActorService = releaseActorService;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        JobRecoveryLogic.$init$(this);
        this.shutdownInProgress = new AtomicBoolean(false);
        this.runners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

