/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler.custom_proxymaker;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.python.util.ProxyCompiler;

public class MethodSignatureTest {
    Class<?> proxy;

    @Before
    public void setUp() throws Exception {
        ProxyCompiler.compile("tests/python/custom_proxymaker/method_signatures.py", "build/classes");
        this.proxy = Class.forName("custom_proxymaker.tests.MethodSignatures");
    }

    @Test
    public void methodThrows() throws Exception {
        Method method = this.proxy.getMethod("throwsException", new Class[0]);
        Assert.assertArrayEquals((Object[])new Class[]{RuntimeException.class}, (Object[])method.getExceptionTypes());
    }

    @Test
    public void returnsVoid() throws Exception {
        Method method = this.proxy.getMethod("throwsException", new Class[0]);
        Assert.assertEquals(Void.TYPE, method.getReturnType());
    }

    @Test
    public void returnsLong() throws Exception {
        Method method = this.proxy.getMethod("returnsLong", new Class[0]);
        Assert.assertEquals(Long.TYPE, method.getReturnType());
    }

    @Test
    public void returnsObject() throws Exception {
        Method method = this.proxy.getMethod("returnsObject", new Class[0]);
        Assert.assertEquals(Object.class, method.getReturnType());
    }

    @Test
    public void returnsArray() throws Exception {
        Method method = this.proxy.getMethod("returnsArray", new Class[0]);
        Object compareType = Array.newInstance(Long.TYPE, 0);
        Assert.assertEquals(compareType.getClass(), method.getReturnType());
    }

    @Test
    public void returnsArrayObj() throws Exception {
        Method method = this.proxy.getMethod("returnsArrayObj", new Class[0]);
        Object compareType = Array.newInstance(Object.class, 0);
        Assert.assertEquals(compareType.getClass(), method.getReturnType());
    }

    @Test
    public void acceptsString() throws Exception {
        Class[] partypes = new Class[]{String.class};
        Method method = this.proxy.getMethod("acceptsString", partypes);
    }

    @Test
    public void acceptsArray() throws Exception {
        Object compareType = Array.newInstance(Long.TYPE, 0);
        Class[] partypes = new Class[]{compareType.getClass()};
        Method method = this.proxy.getMethod("acceptsArray", partypes);
    }
}

