/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.URIParameter;
import java.security.cert.Certificate;

public class ScriptPermissionsProvider {
    public static final String SCRIPT_POLICY_FILE = "script.policy";
    private boolean autoRefresh;
    private final PermissionCollection permissionCollection = this.loadPermissionCollection();

    public ScriptPermissionsProvider() {
        this(true);
    }

    public ScriptPermissionsProvider(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public PermissionCollection getScriptPermissions() {
        if (this.autoRefresh) {
            return this.loadPermissionCollection();
        }
        return this.permissionCollection;
    }

    private PermissionCollection loadPermissionCollection() {
        try {
            URL policyFileUrl = ClassLoader.getSystemClassLoader().getResource(SCRIPT_POLICY_FILE);
            URIParameter params = policyFileUrl == null ? null : new URIParameter(policyFileUrl.toURI());
            Policy scriptPolicy = Policy.getInstance("JavaPolicy", params);
            return scriptPolicy.getPermissions(new ProtectionDomain(new CodeSource(null, (Certificate[])null), null));
        }
        catch (URISyntaxException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

