import React from 'react';
import { ReactWrapper } from 'enzyme';
import { DotSwitch, DotTypography } from '@digital-ai/dot-components';
import { stringPropertyMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/property.mock';
import { taskMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/task.mock';
import { mountWithTheme } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { Fallback } from './fallback.component';
import { PropertiesEnum } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';

describe('Fallback component', () => {
    const onChange = jest.fn();
    let wrapper: ReactWrapper;

    const task = {
        ...taskMock,
        inputProperties: {
            string: {
                value: true,
                variable: null,
            },
        },
    };

    const getDotSwitch = () => wrapper.find(DotSwitch);
    const getDescription = () => wrapper.find(DotTypography);

    beforeEach(() => {
        wrapper = mountWithTheme(
            <Fallback
                disabled={false}
                expanded={false}
                onChange={onChange}
                propertiesEnum={PropertiesEnum.InputProperties}
                property={stringPropertyMock}
                task={task}
            />,
        );
    });

    it('should be wrapped in proper styling', () => {
        expect(wrapper.find('.task-input-property .input-switch-wrapper')).toExist();
    });

    it('should have props and description', () => {
        const dotSwitchProps = getDotSwitch().props();
        expect(dotSwitchProps.checked).toBe(true);
        expect(dotSwitchProps.className).toBe('input-switch');
        expect(dotSwitchProps.disabled).toBe(false);
        expect(dotSwitchProps.label).toBe(stringPropertyMock.label);
        const description = getDescription();
        expect(description).toIncludeText(stringPropertyMock.description);
        const descriptionProps = description.props();
        expect(descriptionProps.className).toBe('input-description');
        expect(descriptionProps.variant).toBe('body2');
    });

    it('should handle onChange', () => {
        getDotSwitch().invoke('onChange')?.({ target: { checked: false } } as never);
        expect(getDotSwitch().props().checked).toBe(false);
        expect(onChange).toHaveBeenCalledWith({ value: false, variable: null });
    });
});
