/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ArrayHelper {
    private ArrayHelper() {
    }

    public static boolean equals(byte[] b1, int b1off, byte[] b2, int b2off, int max) {
        if (b1 == null) {
            throw new NullPointerException("b1");
        }
        if (b2 == null) {
            throw new NullPointerException("b2");
        }
        if (0 > b1off || b1off > b1.length) {
            throw new IndexOutOfBoundsException("b1off = " + b1off + ": not in [0, " + b1.length + "[!");
        }
        if (0 > b2off || b2off > b2.length) {
            throw new IndexOutOfBoundsException("b2off = " + b2off + ": not in [0, " + b2.length + "[!");
        }
        if (max < 1) {
            throw new IllegalArgumentException("len = " + max + ": too small");
        }
        int b1rem = b1.length - b1off;
        int b2rem = b2.length - b2off;
        if (max > b1rem ? (max = b1rem) != b2rem : max > b2rem && (max = b2rem) != b1rem) {
            return false;
        }
        while (--max >= 0) {
            if (b1[b1off + max] == b2[b2off + max]) continue;
            return false;
        }
        return true;
    }
}

