import React from 'react';
import { mount } from 'enzyme/build';
import { ReleaseCountComponent } from './release-count-component';

describe('ReleaseCountComponent', () => {
    test('should render release count component', () => {
        let releaseCount = {
            live: { total: 2, byStatus: { IN_PROGRESS: 2 } },
            archived: { total: 2, byStatus: { COMPLETED: 2 } },
            all: { total: 4, byStatus: { COMPLETED: 2, IN_PROGRESS: 2 } },
        };
        let releaseCountComponent = mount(<ReleaseCountComponent releaseCount={releaseCount} />);
        expect(releaseCountComponent.find('.release-count').exists()).toBeTruthy();
        expect(releaseCountComponent.find('.release-count').text()).toBe('4 releases');

        releaseCount = {
            live: { total: 0, byStatus: {} },
            archived: { total: 1, byStatus: { COMPLETED: 1 } },
            all: { total: 1, byStatus: { COMPLETED: 1 } },
        };
        releaseCountComponent = mount(<ReleaseCountComponent releaseCount={releaseCount} />);
        expect(releaseCountComponent.find('.release-count').exists()).toBeTruthy();
        expect(releaseCountComponent.find('.release-count').text()).toBe('1 release');

        releaseCount = undefined;
        releaseCountComponent = mount(<ReleaseCountComponent releaseCount={releaseCount} />);
        expect(releaseCountComponent.find('.release-count').exists()).toBeFalsy();
    });
});
