/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class JavaToSQLValueNode
extends ValueNode {
    JavaValueNode javaNode;

    JavaToSQLValueNode(JavaValueNode javaValueNode, ContextManager contextManager) {
        super(contextManager);
        this.javaNode = javaValueNode;
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.javaNode.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        LocalField localField;
        Object object;
        this.javaNode.returnValueToSQLDomain();
        boolean bl = this.javaNode.generateReceiver(expressionClassBuilder, methodBuilder);
        if (bl) {
            object = this.getTypeCompiler().interfaceName();
            localField = expressionClassBuilder.newFieldDeclaration(2, (String)object);
            methodBuilder.conditionalIfNull();
            methodBuilder.getField(localField);
            expressionClassBuilder.generateNullWithExpress(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType());
            methodBuilder.startElseCode();
        }
        TypeId typeId = this.getTypeId();
        object = this.getTypeCompiler();
        String string = object.interfaceName();
        localField = expressionClassBuilder.newFieldDeclaration(2, string);
        this.javaNode.generateExpression(expressionClassBuilder, methodBuilder);
        expressionClassBuilder.generateDataValue(methodBuilder, (TypeCompiler)object, this.getTypeServices().getCollationType(), localField);
        if (bl) {
            methodBuilder.completeConditional();
        }
    }

    @Override
    void printSubNodes(int n) {
    }

    JavaValueNode getJavaValueNode() {
        return this.javaNode;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        Object object;
        this.javaNode.checkReliability(this);
        this.javaNode = this.javaNode.bindExpression(fromList, subqueryList, list);
        if (this.javaNode instanceof StaticMethodCallNode && (object = ((StaticMethodCallNode)this.javaNode).getResolvedAggregate()) != null) {
            return ((AggregateNode)object).bindExpression(fromList, subqueryList, list);
        }
        object = this.javaNode.getDataType();
        if (object == null) {
            throw StandardException.newException((String)"X0X57.S", (Object[])new Object[]{this.javaNode.getJavaTypeName()});
        }
        TypeDescriptor typeDescriptor = ((DataTypeDescriptor)object).getCatalogType();
        if (typeDescriptor.isRowMultiSet() || typeDescriptor.getTypeName().equals("java.sql.ResultSet")) {
            throw StandardException.newException((String)"42ZB6", (Object[])new Object[0]);
        }
        this.setType((DataTypeDescriptor)object);
        if (((DataTypeDescriptor)object).getTypeId().isStringTypeId()) {
            this.setCollationInfo(this.javaNode.getCollationType(), 1);
        }
        return this;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.javaNode = this.javaNode.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.javaNode.categorize(jBitSet, bl);
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.javaNode.getOrderableVariantType();
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.javaNode != null) {
            this.javaNode = (JavaValueNode)this.javaNode.accept(visitor);
        }
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) {
        return false;
    }
}

