/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2;

import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc2.ISvnOperationRunner;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SvnOperationRunner<V, T extends SvnOperation<V>>
implements ISvnOperationRunner<V, T>,
ISVNEventHandler {
    private T operation;
    private SVNWCContext wcContext;

    @Override
    public V run(T operation) throws SVNException {
        this.setOperation(operation);
        try {
            V v = this.run();
            return v;
        }
        finally {
            this.reset(this.getWcGeneration());
        }
    }

    @Override
    public void reset(SvnWcGeneration wcGeneration) {
        this.setOperation(null);
        this.setWcContext(null);
    }

    @Override
    public void setWcContext(SVNWCContext context) {
        this.wcContext = context;
    }

    protected SVNWCContext getWcContext() {
        return this.wcContext;
    }

    protected abstract V run() throws SVNException;

    public void setOperation(T operation) {
        this.operation = operation;
    }

    public T getOperation() {
        return this.operation;
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        if (this.getOperation() != null && ((SvnOperation)this.getOperation()).isCancelled()) {
            SVNErrorManager.cancel("Operation cancelled", SVNLogType.WC);
        }
        if (this.getOperation() != null && ((SvnOperation)this.getOperation()).getCanceller() != null) {
            ((SvnOperation)this.getOperation()).getCanceller().checkCancelled();
        }
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        ISVNEventHandler eventHandler = null;
        if (this.getOperation() != null) {
            eventHandler = ((SvnOperation)this.getOperation()).getEventHandler();
        } else if (this.getWcContext() != null) {
            eventHandler = this.getWcContext().getEventHandler();
        }
        if (eventHandler != null) {
            eventHandler.handleEvent(event, progress);
        }
    }

    protected void handleEvent(SVNEvent event) throws SVNException {
        this.handleEvent(event, -1.0);
    }
}

