/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SingleChangeSetFilter;
import com.datical.liquibase.ext.command.InternalRollbackOneChangesetCommandStep$1;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubUpdater;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.Operation;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class InternalRollbackOneChangesetCommandStep
extends AbstractCommandStep {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    public static final String[] COMMAND_NAME = new String[]{"internalRollbackOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGE_LOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHANGE_SET_ID_ARG;
    public static final CommandArgumentDefinition<String> CHANGE_SET_AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CHANGE_SET_PATH_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<Writer> OUTPUT_WRITER_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    public static final CommandArgumentDefinition<Database> DATABASE_ARG;
    public static final CommandArgumentDefinition<Liquibase> LIQUIBASE_ARG;
    public static final CommandArgumentDefinition<ChangeLogParameters> CHANGE_LOG_PARAMETERS_ARG;
    private Database database;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private String changeLogFilePath;
    private Writer outputWriter;
    private Liquibase liquibase;
    private Boolean force;
    private Contexts contexts;
    private LabelExpression labelExpression;
    private boolean ignoreClasspathPrefix;
    private String rollbackScript;
    private ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private DatabaseChangeLog changeLog;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    @Override
    public void validate(CommandScope commandScope) {
        super.validate(commandScope);
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression) {
        changeLogIterator.run(new InternalRollbackOneChangesetCommandStep$1(this), new RuntimeEnvironment(this.database, contexts, labelExpression));
    }

    public void setOutputWriter(Writer writer) {
        this.outputWriter = writer;
    }

    @Override
    public void run(CommandResultsBuilder object) {
        Object object2;
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        object = ((CommandResultsBuilder)object).getCommandScope();
        this.changeSetId = ((CommandScope)object).getArgumentValue(CHANGE_SET_ID_ARG);
        this.changeSetAuthor = ((CommandScope)object).getArgumentValue(CHANGE_SET_AUTHOR_ARG);
        this.changeSetPath = ((CommandScope)object).getArgumentValue(CHANGE_SET_PATH_ARG);
        if (this.changeSetId == null || this.changeSetAuthor == null || this.changeSetPath == null) {
            throw new LiquibaseException(coreBundle.getString("id.author.path.required"));
        }
        this.force = ((CommandScope)object).getArgumentValue(FORCE_ARG);
        if (this.force == null || !this.force.booleanValue()) {
            object = "\nWARNING: Targeted rollback of this changeset may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException((String)object);
        }
        this.rollbackScript = ((CommandScope)object).getArgumentValue(ROLLBACK_SCRIPT_ARG);
        this.changeLogParameters = ((CommandScope)object).getArgumentValue(CHANGE_LOG_PARAMETERS_ARG);
        this.changeLogFilePath = ((CommandScope)object).getArgumentValue(CHANGE_LOG_FILE_ARG);
        this.changeLog = this.parseChangeLogFile(this.changeLogFilePath, this.changeLogParameters);
        this.liquibase = ((CommandScope)object).getArgumentValue(LIQUIBASE_ARG);
        this.database = ((CommandScope)object).getArgumentValue(DATABASE_ARG);
        this.force = ((CommandScope)object).getArgumentValue(FORCE_ARG);
        object = null;
        if (this.outputWriter != null) {
            object = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
            object2 = new LoggingExecutor((Executor)object, this.outputWriter, this.database);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, (Executor)object2);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, (Executor)object2);
        } else {
            object2 = new LoggingExecutor((Executor)object, null, this.database);
        }
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, (Executor)object2);
        Operation operation = null;
        HubUpdater hubUpdater = new HubUpdater(new Date(), this.changeLog, this.database);
        BufferedLogService bufferedLogService = new BufferedLogService();
        SingleChangeSetFilter singleChangeSetFilter = null;
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, this.changeLog, this.contexts, this.labelExpression);
            this.changeLog.validate(this.database, this.contexts, this.labelExpression);
            Object object3 = this.database.getRanChangeSetList();
            singleChangeSetFilter = new SingleChangeSetFilter(this.changeSetId, this.changeSetAuthor, this.changeSetPath, (List<RanChangeSet>)object3, this.changeLog);
            if (singleChangeSetFilter.isEmpty()) {
                String string = "rollback-one-changeset";
                if (this.outputWriter != null) {
                    string = "rollback-one-changeset-sql";
                }
                object2 = this.changeSetPath + "::" + this.changeSetId + "::" + this.changeSetAuthor;
                object2 = "\n\nWARNING:  The command '" + string + "' failed because the targeted change set\n'" + (String)object2 + "' cannot be located.\nAt least one supplied parameter cannot be found in combination with the other parameters.\nPlease check your details and try again.\n";
                if (singleChangeSetFilter.getMatchingIdChangeSet() != null) {
                    object2 = (String)object2 + "\nNOTE:  A change set with this ID was located.\n";
                }
                object2 = (String)object2 + "No rollback was performed.";
                throw new LiquibaseException((String)object2);
            }
            object2 = this.getChangeSetString(singleChangeSetFilter.getMatchingChangeSet());
            this.liquibase.outputHeader("Rollback changeset '" + (String)object2 + "'");
            ChangeLogIterator changeLogIterator = this.createChangeLogIterator((List<RanChangeSet>)object3, singleChangeSetFilter);
            object2 = this.outputWriter == null ? this.liquibase.getConnection(this.changeLog) : null;
            if (object2 != null) {
                operation = hubUpdater.preUpdateHub("ROLLBACK", "rollback-one-changeset", (Connection)object2, this.changeLogFilePath, this.contexts, this.labelExpression, changeLogIterator);
                this.changeExecListener = new HubChangeExecListener(operation, this.changeExecListener);
            }
            object3 = this.createChangeLogIterator((List<RanChangeSet>)object3, singleChangeSetFilter);
            object2 = new CompositeLogService(true, bufferedLogService);
            if (this.rollbackScript == null) {
                Scope.child(Scope.Attr.logService.name(), object2, () -> this.lambda$run$0((ChangeLogIterator)object3));
            } else {
                object2 = singleChangeSetFilter.getMatchingChangeSet();
                InternalRollbackOneChangesetCommandStep internalRollbackOneChangesetCommandStep = this;
                internalRollbackOneChangesetCommandStep.executeRollbackScript(internalRollbackOneChangesetCommandStep.rollbackScript, (ChangeSet)object2, this.contexts, this.labelExpression);
                this.removeRunStatus((ChangeLogIterator)object3, this.contexts, this.labelExpression);
                logger.info("Executed rollback script " + this.rollbackScript);
            }
            hubUpdater.postUpdateHub(operation, bufferedLogService);
        }
        catch (LiquibaseException liquibaseException) {
            hubUpdater.postUpdateHubExceptionHandling(operation, bufferedLogService, liquibaseException.getMessage());
            object2 = singleChangeSetFilter != null && !singleChangeSetFilter.isEmpty() ? this.getChangeSetString(singleChangeSetFilter.getMatchingChangeSet()) : this.changeSetPath + "::" + this.changeSetId + "::" + this.changeSetAuthor;
            if (liquibaseException.getCause() instanceof RollbackImpossibleException) {
                logger.severe("\nError executing rollback:\nThe targeted changeset '" + (String)object2 + "' does not have a rollback defined\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", liquibaseException);
                throw new LiquibaseException("\nError executing rollback:\nThe targeted changeset '" + (String)object2 + "' does not have a rollback defined.\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", liquibaseException);
            }
            logger.severe("\nError executing rollback for the targeted changeset '" + (String)object2 + "'.");
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object2 + "':\n" + liquibaseException.getMessage(), liquibaseException);
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                logger.severe(MSG_COULD_NOT_RELEASE_LOCK, lockException);
            }
            if (object != null) {
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, (Executor)object);
            }
        }
        this.resetServices();
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-changeset executed for " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    private String getChangeSetString(ChangeSet changeSet) {
        if (changeSet == null) {
            return null;
        }
        return changeSet.toString(false);
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter) {
        return new ChangeLogIterator(list, this.changeLog, changeSetFilter, new AlreadyRanChangeSetFilter(list), new ContextChangeSetFilter(this.contexts), new LabelChangeSetFilter(this.labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database));
    }

    protected void executeRollbackScript(String string, ChangeSet changeSet, Contexts contexts, LabelExpression labelExpression) {
        Object object;
        Object object2;
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        try {
            object2 = Scope.getCurrentScope().getResourceAccessor().openStreams(null, string);
            object = null;
            try {
                if (object2 == null || ((InputStreamList)object2).isEmpty()) {
                    throw new LiquibaseException("WARNING: The rollback script '" + string + "' was not located. Please check your parameters. No rollback was performed.");
                }
                if (((InputStreamList)object2).size() > 1) {
                    throw new LiquibaseException("Found multiple rollbackScripts COMMAND_NAMEd ".concat(String.valueOf(string)));
                }
                string = StreamUtil.readStreamAsString(((InputStreamList)object2).iterator().next());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                object = throwable;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((InputStreamList)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStreamList)object2).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new LiquibaseException("Error reading rollbackScript " + executor + ": " + iOException.getMessage());
        }
        this.changeLogParameters.setContexts(contexts);
        this.changeLogParameters.setLabels(labelExpression);
        string = this.changeLogParameters.expandExpressions(string, this.changeLog);
        object2 = this.buildRawSQLChange(string);
        object = this.getChangeSetString(changeSet);
        try {
            if (this.changeExecListener != null) {
                ((HubChangeExecListener)this.changeExecListener).setRollbackScriptContents(string);
                this.changeExecListener.willRollback(changeSet, this.changeLog, this.database);
            }
            Scope.getCurrentScope().getUI().sendMessage("Rolling Back Changeset:".concat(String.valueOf(object)));
            executor.execute((Change)object2);
            if (this.changeExecListener != null) {
                this.changeExecListener.rolledBack(changeSet, this.changeLog, this.database);
            }
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(this.getClass()).severe("Error executing rollback script: " + databaseException.getMessage());
            if (this.changeExecListener != null) {
                this.changeExecListener.rollbackFailed(changeSet, this.changeLog, this.database, databaseException);
            }
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object + "':\n" + databaseException.getMessage(), databaseException);
        }
        this.database.commit();
        if (string.length() == 0) {
            Scope.getCurrentScope().getLog(this.getClass()).info("No rollback logic defined in empty rollback script. Changesets have been removed from\nthe DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    protected RawSQLChange buildRawSQLChange(String object) {
        object = new RawSQLChange((String)object);
        ((AbstractSQLChange)object).setSplitStatements(Boolean.TRUE);
        ((AbstractSQLChange)object).setStripComments(Boolean.TRUE);
        return object;
    }

    protected void checkLiquibaseTables(boolean bl2, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changeLogHistoryService.init();
        if (bl2) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        Scope.getCurrentScope().getSingleton(ExecutorService.class).reset();
    }

    private DatabaseChangeLog parseChangeLogFile(String string, ChangeLogParameters changeLogParameters) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        return ChangeLogParserFactory.getInstance().getParser(string, resourceAccessor).parse(string, changeLogParameters, resourceAccessor);
    }

    private /* synthetic */ void lambda$run$0(ChangeLogIterator changeLogIterator) {
        changeLogIterator.run(this.createRollbackVisitor(), new RuntimeEnvironment(this.database, this.contexts, this.labelExpression));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHANGE_LOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).required().build();
        CHANGE_SET_ID_ARG = commandBuilder.argument("changeSetId", String.class).required().build();
        CHANGE_SET_AUTHOR_ARG = commandBuilder.argument("changeSetAuthor", String.class).required().build();
        CHANGE_SET_PATH_ARG = commandBuilder.argument("changeSetPath", String.class).required().build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).build();
        ROLLBACK_SCRIPT_ARG = commandBuilder.argument("rollbackScript", String.class).build();
        DATABASE_ARG = commandBuilder.argument("database", Database.class).required().build();
        LIQUIBASE_ARG = commandBuilder.argument("liquibase", Liquibase.class).required().build();
        OUTPUT_WRITER_ARG = commandBuilder.argument("outputWriter", Writer.class).build();
        CHANGE_LOG_PARAMETERS_ARG = commandBuilder.argument("changeLogParameters", ChangeLogParameters.class).build();
    }
}

