/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.jni;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchName;
import org.hyperic.jni.ArchNotSupportedException;

public class ArchLoader {
    private Object loadLock = new Object();
    private boolean loaded = false;
    private static final String osName = System.getProperty("os.name");
    public static final boolean IS_WIN32 = osName.startsWith("Windows");
    public static final boolean IS_AIX = osName.equals("AIX");
    public static final boolean IS_HPUX = osName.equals("HP-UX");
    public static final boolean IS_SOLARIS = osName.equals("SunOS");
    public static final boolean IS_LINUX = osName.equals("Linux");
    public static final boolean IS_DARWIN = osName.equals("Mac OS X") || osName.equals("Darwin");
    public static final boolean IS_OSF1 = osName.equals("OSF1");
    public static final boolean IS_FREEBSD = osName.equals("FreeBSD");
    public static final boolean IS_NETWARE = osName.equals("NetWare");
    private String packageName;
    private String name;
    private String resourcePath;
    private Class loaderClass;
    private String jarName;
    private String libName = null;
    private File nativeLibrary;
    private String version;

    public ArchLoader() {
    }

    public ArchLoader(Class loaderClass) {
        this.setLoaderClass(loaderClass);
        String pname = loaderClass.getName();
        int ix = pname.lastIndexOf(".");
        pname = pname.substring(0, ix);
        this.setPackageName(pname);
        ix = pname.lastIndexOf(".");
        this.setName(pname.substring(ix + 1));
        this.setJarName(this.getName() + ".jar");
        this.setResourcePath(this.toResName(pname));
    }

    public Class getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(Class value) {
        this.loaderClass = value;
    }

    public ClassLoader getClassLoader() {
        return this.getLoaderClass().getClassLoader();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String value) {
        this.resourcePath = value;
    }

    public String getJarName() {
        return this.jarName;
    }

    public void setJarName(String value) {
        this.jarName = value;
    }

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String value) {
        this.libName = value;
    }

    public String getArchLibName() throws ArchNotSupportedException {
        return this.getName() + "-" + ArchName.getName();
    }

    public String getDefaultLibName() throws ArchNotSupportedException {
        return System.getProperty(this.getPackageName() + ".libname", "java" + this.getArchLibName());
    }

    public File getNativeLibrary() {
        return this.nativeLibrary;
    }

    private String toResName(String name) {
        StringBuffer sb = new StringBuffer(name);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '.') continue;
            sb.setCharAt(i, '/');
        }
        return sb.toString();
    }

    public static String getLibraryPrefix() {
        if (IS_WIN32 || IS_NETWARE) {
            return "";
        }
        return "lib";
    }

    public static String getLibraryExtension() {
        if (IS_WIN32) {
            return ".dll";
        }
        if (IS_NETWARE) {
            return ".nlm";
        }
        if (IS_DARWIN) {
            return ".dylib";
        }
        if (IS_HPUX) {
            return ".sl";
        }
        return ".so";
    }

    public String getLibraryName() throws ArchNotSupportedException {
        String libName = this.getLibName();
        if (libName == null) {
            libName = this.getDefaultLibName();
            this.setLibName(libName);
        }
        String prefix = ArchLoader.getLibraryPrefix();
        String ext = ArchLoader.getLibraryExtension();
        return prefix + libName + ext;
    }

    public String getVersionedLibraryName() {
        if (this.version == null) {
            return null;
        }
        try {
            this.getLibraryName();
        }
        catch (ArchNotSupportedException e) {
            return null;
        }
        String prefix = ArchLoader.getLibraryPrefix();
        String ext = ArchLoader.getLibraryExtension();
        return prefix + this.libName + '-' + this.version + ext;
    }

    private boolean isJarURL(URL url) {
        String jarName;
        if (url == null) {
            return false;
        }
        String name = url.getFile();
        if (name.indexOf(jarName = this.getJarName()) != -1) {
            return true;
        }
        int ix = jarName.indexOf(".jar");
        if (ix != -1) {
            if ((ix = name.lastIndexOf(jarName = jarName.substring(0, ix) + "-")) != -1) {
                jarName = name.substring(ix);
                if ((ix = jarName.indexOf(".jar")) == -1) {
                    return false;
                }
                this.version = jarName.substring(jarName.indexOf(45) + 1, ix);
                jarName = jarName.substring(0, ix + 4);
                this.setJarName(jarName);
                return true;
            }
            return false;
        }
        return false;
    }

    public String findJarPath(String libName) throws ArchLoaderException {
        return this.findJarPath(libName, true);
    }

    private String findJarPath(String libName, boolean isRequired) throws ArchLoaderException {
        String dir;
        File file;
        if (this.getJarName() == null) {
            throw new ArchLoaderException("jarName is null");
        }
        String path = this.getResourcePath();
        ClassLoader loader = this.getClassLoader();
        URL url = loader.getResource(path);
        if (!this.isJarURL(url)) {
            url = null;
        }
        if (url == null && loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                if (!this.isJarURL(urls[i])) continue;
                url = urls[i];
                break;
            }
        }
        if (url == null) {
            if (isRequired) {
                throw new ArchLoaderException("Unable to find " + this.getJarName());
            }
            return null;
        }
        path = url.getFile();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        String jarName = this.getJarName();
        for (file = new File(path); file != null && !file.getName().startsWith(jarName); file = file.getParentFile()) {
        }
        if (libName == null) {
            libName = jarName;
        }
        if (file != null && (file = file.getParentFile()) != null && this.findNativeLibrary(dir = URLDecoder.decode(file.toString()), libName)) {
            return dir;
        }
        return null;
    }

    protected void systemLoadLibrary(String name) {
        System.loadLibrary(name);
    }

    protected void systemLoad(String name) {
        System.load(name);
    }

    protected boolean containsNativeLibrary(File dir, String name) {
        if (name == null) {
            return false;
        }
        File file = new File(dir, name);
        if (file.exists()) {
            this.nativeLibrary = file;
            return true;
        }
        return false;
    }

    protected boolean findNativeLibrary(String dir, String name) {
        File path = new File(dir).getAbsoluteFile();
        if (this.containsNativeLibrary(path, name)) {
            return true;
        }
        if (this.containsNativeLibrary(path, this.getVersionedLibraryName())) {
            return true;
        }
        return this.containsNativeLibrary(path, ArchLoader.getLibraryPrefix() + this.getName() + ArchLoader.getLibraryExtension());
    }

    protected boolean findInJavaLibraryPath(String libName) {
        String path = System.getProperty("java.library.path", "");
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            path = tok.nextToken();
            if (!this.findNativeLibrary(path, libName)) continue;
            return true;
        }
        return false;
    }

    protected void loadLibrary(String path) throws ArchNotSupportedException, ArchLoaderException {
        try {
            String libName = this.getLibraryName();
            if (path == null) {
                path = System.getProperty(this.getPackageName() + ".path");
            }
            if (path != null) {
                if (path.equals("-")) {
                    return;
                }
                this.findJarPath(null, false);
                this.findNativeLibrary(path, libName);
            } else if (this.findJarPath(libName, false) == null) {
                this.findInJavaLibraryPath(libName);
            }
            if (this.nativeLibrary != null) {
                this.systemLoad(this.nativeLibrary.toString());
            } else {
                this.systemLoadLibrary(libName);
            }
        }
        catch (RuntimeException e) {
            String reason = e.getMessage();
            if (reason == null) {
                reason = e.getClass().getName();
            }
            String msg = "Failed to load " + this.libName + ": " + reason;
            throw new ArchLoaderException(msg);
        }
    }

    public void load() throws ArchNotSupportedException, ArchLoaderException {
        this.load(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String path) throws ArchNotSupportedException, ArchLoaderException {
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loaded) {
                return;
            }
            this.loadLibrary(path);
            this.loaded = true;
        }
    }
}

