/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.variables.Variable;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class IntegerVariable
extends Variable.VariableWithValue<Integer> {
    @PublicApiMember
    @Property(required=true, description="Value of the release variable or default value of the template variable")
    protected int value;

    @Override
    @PublicApiMember
    public Integer getValue() {
        return this.value;
    }

    @Override
    public Integer getEmptyValue() {
        return 0;
    }

    @Override
    @PublicApiMember
    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(Object newValue) {
        if (newValue == null) {
            this.setValue(this.getEmptyValue());
            return;
        }
        if (newValue instanceof Integer) {
            this.setValue((Integer)newValue);
        } else if (newValue instanceof String) {
            this.handleStringValue(newValue.toString());
        } else {
            throw new IllegalArgumentException(String.format("Cannot set instance of %s into integer variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    private void handleStringValue(String newValue) {
        if (newValue.isBlank()) {
            this.setValue(this.getEmptyValue());
        } else {
            try {
                this.setValue(Integer.valueOf(newValue));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Cannot set instance of %s into integer variable value: %s", newValue.getClass().getSimpleName(), newValue), e);
            }
        }
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public String getValueAsString() {
        return Integer.toString(this.value);
    }

    @Override
    public String getEmptyValueAsString() {
        return "0";
    }

    @Override
    public boolean isValueEmpty() {
        return false;
    }

    @Override
    public boolean isValueAssignableFrom(Object value) {
        return value instanceof Integer;
    }
}

