import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

export const alertType = {
    INFO: 'info',
    WARNING: 'warning',
};

export class AlertMessage extends PureComponent {
    static propTypes = {
        alertType: PropTypes.oneOf([alertType.INFO, alertType.WARNING]).isRequired,
        children: PropTypes.element.isRequired,
    };

    alertIconsClasses = {
        info: 'info-icon',
        warning: 'warning-icon',
    };

    render() {
        const { children, alertType } = this.props;
        const alertClass = `xlr-alert-${alertType}`;
        const iconClass = `xl-icon ${this.alertIconsClasses[alertType]} icon-l`;
        return (
            <div className={alertClass}>
                <div className="icon">
                    <i className={iconClass} />
                </div>
                <div className="message">{children}</div>
            </div>
        );
    }
}
