/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.util.Arrays;

public class SVNIntMap {
    public static final int INITIAL_CAPACITY = 8192;
    public static final int CACHE_SIZE = 8192;
    public static final int CACHE_SIZE_MASK = 8191;
    private int[] keys = new int[this.capacity];
    private Object[] values = new Object[this.capacity];
    private int[] nextIndices = new int[this.capacity];
    private int[] hashToIndex = new int[8192];
    private int size = 0;
    private int capacity = 8192;

    public SVNIntMap() {
        Arrays.fill(this.keys, -1);
        Arrays.fill(this.nextIndices, -1);
        Arrays.fill(this.hashToIndex, -1);
    }

    public boolean containsKey(int key) {
        int hash = this.fitTableSize(this.hash(key));
        return this.hashToIndex[hash] != -1;
    }

    public Object get(int key) {
        int hash = this.fitTableSize(this.hash(key));
        int index = this.hashToIndex[hash];
        while (index != -1) {
            if (this.keys[index] == key) {
                return this.values[index];
            }
            index = this.nextIndices[index];
        }
        return null;
    }

    public void put(int key, Object value) {
        this.maybeGrowCapacity();
        int hash = this.fitTableSize(this.hash(key));
        int index = this.hashToIndex[hash];
        int previousIndex = -1;
        while (index != -1) {
            if (this.keys[index] == key) {
                this.values[index] = value;
                return;
            }
            previousIndex = index;
            index = this.nextIndices[index];
        }
        int newIndex = this.size++;
        if (previousIndex != -1) {
            this.nextIndices[previousIndex] = newIndex;
        }
        if (this.hashToIndex[hash] == -1) {
            this.hashToIndex[hash] = newIndex;
        }
        this.keys[newIndex] = key;
        this.values[newIndex] = value;
    }

    private void maybeGrowCapacity() {
        if (this.size < this.capacity) {
            return;
        }
        int newCapacity = this.capacity * 2;
        int[] newKeys = new int[newCapacity];
        Object[] newValues = new Object[newCapacity];
        int[] newNextIndices = new int[newCapacity];
        System.arraycopy(this.keys, 0, newKeys, 0, this.size);
        System.arraycopy(this.values, 0, newValues, 0, this.size);
        System.arraycopy(this.nextIndices, 0, newNextIndices, 0, this.size);
        Arrays.fill(newKeys, this.size, newKeys.length, -1);
        Arrays.fill(newNextIndices, this.size, newNextIndices.length, -1);
        this.keys = newKeys;
        this.values = newValues;
        this.nextIndices = newNextIndices;
        this.capacity = newCapacity;
    }

    private int fitTableSize(int hash) {
        return hash & 0x1FFF;
    }

    private int hash(int key) {
        return key;
    }
}

