/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import org.jparsec.ParseContext;
import org.jparsec.Parser;

final class SkipAtLeastParser
extends Parser<Void> {
    private final Parser<?> parser;
    private final int min;

    SkipAtLeastParser(Parser<?> parser, int min) {
        this.parser = parser;
        this.min = min;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        if (!ctxt.repeat(this.parser, this.min)) {
            return false;
        }
        if (this.applyMany(ctxt)) {
            ctxt.result = null;
            return true;
        }
        return false;
    }

    public String toString() {
        return "skipAtLeast";
    }

    private boolean applyMany(ParseContext ctxt) {
        int physical = ctxt.at;
        int logical = ctxt.step;
        while (true) {
            if (!this.parser.apply(ctxt)) {
                ctxt.setAt(logical, physical);
                return true;
            }
            int at2 = ctxt.at;
            if (physical == at2) {
                return true;
            }
            physical = at2;
            logical = ctxt.step;
        }
    }
}

