/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import org.jparsec.ParseContext;
import org.jparsec.Parser;
import org.jparsec.SourceLocator;
import org.jparsec.Token;
import org.jparsec.error.ParserException;

final class ScannerState
extends ParseContext {
    private final int end;

    ScannerState(CharSequence source) {
        this(null, source, 0, new SourceLocator(source));
    }

    ScannerState(String module, CharSequence source, int from, SourceLocator locator) {
        super(source, from, module, locator);
        this.end = source.length();
    }

    ScannerState(String module, CharSequence source, int from, int end, SourceLocator locator, Object originalResult) {
        super(source, originalResult, from, module, locator);
        this.end = end;
    }

    @Override
    char peekChar() {
        return this.source.charAt(this.at);
    }

    @Override
    boolean isEof() {
        return this.end == this.at;
    }

    @Override
    int toIndex(int pos) {
        return pos;
    }

    @Override
    String getInputName(int pos) {
        if (pos >= this.end) {
            return "EOF";
        }
        return Character.toString(this.source.charAt(pos));
    }

    @Override
    CharSequence characters() {
        return this.source;
    }

    @Override
    Token getToken() {
        throw new IllegalStateException("Parser not on token level");
    }

    final <T> T run(Parser<T> parser) {
        if (!this.applyWithExceptionWrapped(parser)) {
            ParserException exception = new ParserException(this.renderError(), this.module, this.locator.locate(this.errorIndex()));
            exception.setParseTree(this.buildErrorParseTree());
            throw exception;
        }
        return parser.getReturn(this);
    }

    private boolean applyWithExceptionWrapped(Parser<?> parser) {
        try {
            return parser.apply(this);
        }
        catch (RuntimeException e) {
            if (e instanceof ParserException) {
                throw (ParserException)e;
            }
            ParserException wrapper = new ParserException(e, null, this.module, this.locator.locate(this.getIndex()));
            wrapper.setParseTree(this.buildParseTree());
            throw wrapper;
        }
    }
}

