/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.handlers;

import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentUpdatedEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.notifications.CommentAdded;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.UserMentioned;
import com.xebialabs.xlrelease.notifications.handlers.package$;
import com.xebialabs.xlrelease.notifications.mentions.Mentions$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0005a3A!\u0002\u0004\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004C\u0003\u001e\u0001\u0011\u0005a\u0004C\u00032\u0001\u0011\u0005!\u0007C\u0003G\u0001\u0011\u0005qIA\u0010D_6lWM\u001c;O_RLg-[2bi&|g.\u0012<f]RD\u0015M\u001c3mKJT!a\u0002\u0005\u0002\u0011!\fg\u000e\u001a7feNT!!\u0003\u0006\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\tYA\"A\u0005yYJ,G.Z1tK*\u0011QBD\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aD\u0001\u0004G>l7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0017a\u00058pi&4\u0017nY1uS>t7+\u001a:wS\u000e,\u0007C\u0001\u000e\u001c\u001b\u0005A\u0011B\u0001\u000f\t\u0005Mqu\u000e^5gS\u000e\fG/[8o'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0011q$\t\t\u0003A\u0001i\u0011A\u0002\u0005\u00061\t\u0001\r!\u0007\u0015\u0003\u0005\r\u0002\"\u0001J\u0018\u000e\u0003\u0015R!AJ\u0014\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002)S\u00059a-Y2u_JL(B\u0001\u0016,\u0003\u0015\u0011W-\u00198t\u0015\taS&A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005q\u0013aA8sO&\u0011\u0001'\n\u0002\n\u0003V$xn^5sK\u0012\f\u0001c\u001c8D_6lWM\u001c;De\u0016\fG/\u001a3\u0015\u0005M2\u0004CA\n5\u0013\t)DC\u0001\u0003V]&$\b\"B\u001c\u0004\u0001\u0004A\u0014!B3wK:$\bCA\u001d?\u001b\u0005Q$BA\u001e=\u0003\u0019)g/\u001a8ug*\u0011QHC\u0001\u0007I>l\u0017-\u001b8\n\u0005}R$aE\"p[6,g\u000e^\"sK\u0006$X\rZ#wK:$\bFA\u0002B!\t\u0011E)D\u0001D\u0015\tY$\"\u0003\u0002F\u0007\nq\u0011i]=oGN+(m]2sS\n,\u0017\u0001E8o\u0007>lW.\u001a8u+B$\u0017\r^3e)\t\u0019\u0004\nC\u00038\t\u0001\u0007\u0011\n\u0005\u0002:\u0015&\u00111J\u000f\u0002\u0014\u0007>lW.\u001a8u+B$\u0017\r^3e\u000bZ,g\u000e\u001e\u0015\u0003\t\u0005C#\u0001\u0001(\u0011\u0005\t{\u0015B\u0001)D\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\"\u0012\u0001A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+.\n!b\u001d;fe\u0016|G/\u001f9f\u0013\t9FKA\u0005D_6\u0004xN\\3oi\u0002")
public class CommentNotificationEventHandler {
    private final NotificationService notificationService;

    @AsyncSubscribe
    public void onCommentCreated(CommentCreatedEvent event) {
        Set<String> mentions;
        Tuple3 tuple3 = new Tuple3((Object)event.task(), (Object)event.comment(), (Object)BoxesRunTime.boxToBoolean((boolean)event.createdByUser()));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Task task = (Task)tuple3._1();
        Comment comment = (Comment)tuple3._2();
        boolean createdByUser = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)task, (Object)comment, (Object)BoxesRunTime.boxToBoolean((boolean)createdByUser));
        Task task2 = (Task)tuple32._1();
        Comment comment2 = (Comment)tuple32._2();
        boolean createdByUser2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
        if (task2.getRelease().isActive() && createdByUser2) {
            this.notificationService.notify(new CommentAdded((List<Task>)((List)package$.MODULE$.wrapTask().apply((Object)task2)), comment2));
        }
        if ((mentions = Mentions$.MODULE$.collectMentions(comment2.getText())).nonEmpty()) {
            this.notificationService.notify(new UserMentioned((List<Task>)((List)package$.MODULE$.wrapTask().apply((Object)task2)), mentions, event.username(), comment2.getText()));
            return;
        }
    }

    @AsyncSubscribe
    public void onCommentUpdated(CommentUpdatedEvent event) {
        Tuple2 tuple2 = new Tuple2((Object)event.original(), (Object)event.updated());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Comment original = (Comment)tuple2._1();
        Comment updated = (Comment)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)original, (Object)updated);
        Comment original2 = (Comment)tuple22._1();
        Comment updated2 = (Comment)tuple22._2();
        Set<String> originalMentions = Mentions$.MODULE$.collectMentions(original2.getText());
        Set<String> updatedMentions = Mentions$.MODULE$.collectMentions(updated2.getText());
        Set newMentions = (Set)updatedMentions.$minus$minus(originalMentions);
        if (newMentions.nonEmpty()) {
            this.notificationService.notify(new UserMentioned((List<Task>)((List)package$.MODULE$.wrapTask().apply((Object)event.task())), (Set<String>)newMentions, event.username(), updated2.getText()));
            return;
        }
    }

    @Autowired
    public CommentNotificationEventHandler(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

