/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.support.report;

import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.support.report.LicenseUsageStatistics;
import com.xebialabs.xlrelease.support.report.ReportDataProvider;
import com.xebialabs.xlrelease.support.report.repository.DataStatisticsRepository;
import com.xebialabs.xlrelease.views.LicenseView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005E4AAC\u0006\u0001-!A\u0011\u0005\u0001BC\u0002\u0013\u0005!\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003$\u0011!a\u0003A!b\u0001\n\u0003i\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bQ\u0002A\u0011A\u001b\t\u000f!\u0003!\u0019!C!\u0013\"1Q\u000b\u0001Q\u0001\n)CQA\u0016\u0001\u0005B]CQA\u0018\u0001\u0005\n}\u00131\u0003T5dK:\u001cX\rR1uCB\u0013xN^5eKJT!\u0001D\u0007\u0002\rI,\u0007o\u001c:u\u0015\tqq\"A\u0004tkB\u0004xN\u001d;\u000b\u0005A\t\u0012!\u0003=me\u0016dW-Y:f\u0015\t\u00112#A\u0005yK\nL\u0017\r\\1cg*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010 \u001b\u0005Y\u0011B\u0001\u0011\f\u0005I\u0011V\r]8si\u0012\u000bG/\u0019)s_ZLG-\u001a:\u0002\u001d1L7-\u001a8tKN+'O^5dKV\t1\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u000591/\u001a:wS\u000e,'B\u0001\u0015\u0012\u0003\u001da\u0017nY3og\u0016L!AK\u0013\u0003\u001d1K7-\u001a8tKN+'O^5dK\u0006yA.[2f]N,7+\u001a:wS\u000e,\u0007%\u0001\u0006sKB|7/\u001b;pef,\u0012A\f\t\u0003_Ej\u0011\u0001\r\u0006\u0003Y-I!A\r\u0019\u00031\u0011\u000bG/Y*uCRL7\u000f^5dgJ+\u0007o\\:ji>\u0014\u00180A\u0006sKB|7/\u001b;pef\u0004\u0013A\u0002\u001fj]&$h\bF\u00027oa\u0002\"A\b\u0001\t\u000b\u0005*\u0001\u0019A\u0012\t\u000b1*\u0001\u0019\u0001\u0018)\u0005\u0015Q\u0004CA\u001eG\u001b\u0005a$BA\u001f?\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u007f\u0001\u000bqAZ1di>\u0014\u0018P\u0003\u0002B\u0005\u0006)!-Z1og*\u00111\tR\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ)A\u0002pe\u001eL!a\u0012\u001f\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u00028b[\u0016,\u0012A\u0013\t\u0003\u0017Js!\u0001\u0014)\u0011\u00055KR\"\u0001(\u000b\u0005=+\u0012A\u0002\u001fs_>$h(\u0003\u0002R3\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\t\u0016$A\u0003oC6,\u0007%A\td_2dWm\u0019;Ti\u0006$\u0018n\u001d;jGN,\u0012\u0001\u0017\t\u0005\u0017fS5,\u0003\u0002[)\n\u0019Q*\u00199\u0011\u0005aa\u0016BA/\u001a\u0005\r\te._\u0001\u0019G\u0006d7-\u001e7bi\u0016,F/\u001b7ju\u0006$\u0018n\u001c8SCR,Gc\u00011dQB\u0011\u0001$Y\u0005\u0003Ef\u0011QA\u00127pCRDQ\u0001Z\u0005A\u0002\u0015\f\u0001\"\\1y+N,'o\u001d\t\u00031\u0019L!aZ\r\u0003\u0007%sG\u000fC\u0003j\u0013\u0001\u0007Q-\u0001\u0007dkJ\u0014XM\u001c;Vg\u0016\u00148\u000f\u000b\u0002\u0001WB\u0011An\\\u0007\u0002[*\u0011aNQ\u0001\u000bgR,'/Z8usB,\u0017B\u00019n\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class LicenseDataProvider
implements ReportDataProvider {
    private final LicenseService licenseService;
    private final DataStatisticsRepository repository;
    private final String name;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LicenseDataProvider licenseDataProvider = this;
        synchronized (licenseDataProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public LicenseService licenseService() {
        return this.licenseService;
    }

    public DataStatisticsRepository repository() {
        return this.repository;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Map<String, Object> collectStatistics() {
        LicenseUsageStatistics statistics = new LicenseUsageStatistics();
        LicenseView licenseView = new LicenseView(this.licenseService().getLicense());
        statistics.setLicenseVersion(licenseView.getVersion());
        statistics.setLicensedProduct(licenseView.getProduct());
        statistics.setLicensedEdition(licenseView.getEdition());
        statistics.setLicensedTo(licenseView.getLicensedTo());
        statistics.setLicenseExpiresAfter(licenseView.getExpiresAfter());
        statistics.setLicenseRemainingDays(this.licenseService().getValidPeriod().getDays());
        statistics.setLicensedMaxUsers(BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)licenseView.getMaxNumberOfUsers()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)));
        statistics.setCurrentUsers(this.repository().countEnabledUsers());
        statistics.setLicenseUtilizationRate(this.calculateUtilizationRate(statistics.getLicensedMaxUsers(), statistics.getCurrentUsers()));
        statistics.setLicensedRepositoryId(licenseView.getRepositoryId());
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"license"), (Object)statistics)}));
    }

    private float calculateUtilizationRate(int maxUsers, int currentUsers) {
        if (maxUsers <= 0 || currentUsers < 0) {
            return 0.0f;
        }
        return package$.MODULE$.BigDecimal().apply(currentUsers).$div(package$.MODULE$.BigDecimal().apply(maxUsers)).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).floatValue();
    }

    @Autowired
    public LicenseDataProvider(LicenseService licenseService, DataStatisticsRepository repository) {
        this.licenseService = licenseService;
        this.repository = repository;
        Logging.$init$((Logging)this);
        this.name = "license";
    }
}

