/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.pager;

import java.util.Arrays;
import java.util.List;
import org.hyperic.sigar.pager.PageControl;
import org.hyperic.sigar.pager.PageFetchException;
import org.hyperic.sigar.pager.PageFetcher;
import org.hyperic.sigar.pager.PageList;

public class StaticPageFetcher
extends PageFetcher {
    private List data;

    public StaticPageFetcher(String[] data) {
        this.data = Arrays.asList(data);
    }

    public StaticPageFetcher(List data) {
        this.data = data;
    }

    public PageList getPage(PageControl control) throws PageFetchException {
        PageList res = new PageList();
        res.setTotalSize(this.data.size());
        if (control.getPagesize() == -1 || control.getPagenum() == -1) {
            res.addAll(this.data);
            return res;
        }
        int startIdx = control.getPageEntityIndex();
        int endIdx = startIdx + control.getPagesize();
        if (startIdx >= this.data.size()) {
            return res;
        }
        if (endIdx > this.data.size()) {
            endIdx = this.data.size();
        }
        res.addAll(this.data.subList(startIdx, endIdx));
        return res;
    }
}

