/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.ryantenney.metrics.spring.reporter.AbstractReporterElementParser;
import com.ryantenney.metrics.spring.reporter.LibratoReporterFactoryBean;

public class LibratoReporterElementParser
extends AbstractReporterElementParser {
    @Override
    public String getType() {
        return "librato";
    }

    @Override
    protected Class<?> getBeanClass() {
        return LibratoReporterFactoryBean.class;
    }

    @Override
    protected void validate(AbstractReporterElementParser.ValidationContext c) {
        c.require("username");
        c.require("token");
        c.require("period", "^(\\d+)\\s?(ns|us|ms|s|m|h|d)?$", "Period is required and must be in the form '\\d+(ns|us|ms|s|m|h|d)'");
        c.optional("source");
        c.optional("source-supplier-ref");
        if (!c.has("source") && !c.has("source-supplier-ref")) {
            c.require("source");
        } else if (c.has("source") && c.has("source-supplier-ref")) {
            c.reject("source-supplier-ref", "Reporter element must not specify both the 'source' and 'source-supplier-ref' attributes");
        }
        c.optional("timeout", "^(\\d+)\\s?(ns|us|ms|s|m|h|d)?$", "Timeout must be in the form '\\d+(ns|us|ms|s|m|h|d)'");
        c.optional("name");
        c.optional("sanitizer-ref");
        c.optional("prefix-delimiter");
        c.optional("clock-ref");
        c.optional("source-regex");
        c.optional("http-poster-ref");
        c.optional("http-client-config-ref");
        c.optional("delete-idle-stats");
        c.optional("omit-complex-gauges");
        c.optional("expansion-config");
        c.optional("expansion-config-ref");
        if (c.has("expansion-config") && c.has("expansion-config-ref")) {
            c.reject("expansion-config", "Librato Reporter element must not specify both the 'expansion-config' and 'expansion-config-ref' attributes");
        }
        c.optional("rate-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Rate unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("duration-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Duration unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("prefix");
        c.optional("prefix-supplier-ref");
        if (c.has("prefix") && c.has("prefix-supplier-ref")) {
            c.reject("prefix-supplier-ref", "Reporter element must not specify both the 'prefix' and 'prefix-supplier-ref' attributes");
        }
        c.optional("filter");
        c.optional("filter-ref");
        if (c.has("filter") && c.has("filter-ref")) {
            c.reject("filter-ref", "Reporter element must not specify both the 'filter' and 'filter-ref' attributes");
        }
        c.rejectUnmatchedProperties();
    }
}

