/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.audit;

import com.google.common.base.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.reports.domain.ReleaseData;
import com.xebialabs.xlrelease.reports.domain.ReleaseStartedBy;
import com.xebialabs.xlrelease.reports.domain.StartedByCreateReleaseTask;
import com.xebialabs.xlrelease.reports.domain.StartedByTrigger;
import com.xebialabs.xlrelease.reports.domain.StartedByUser;
import com.xebialabs.xlrelease.reports.domain.UserThatCreatedOrStartedRelease;
import com.xebialabs.xlrelease.reports.service.ReportsService$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.service.ReleaseActivityLogsService;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class CreatedByDetailsHelper$ {
    public static final CreatedByDetailsHelper$ MODULE$ = new CreatedByDetailsHelper$();

    public Option<ReleaseStartedBy> getCreationDetails(ReleaseRepository releaseRepository, TriggerRepository triggerRepository, ReleaseActivityLogsService activityLogsService, Function1<String, Option<String>> resolveUser, ReleaseData releaseData) {
        Release release = releaseData.release();
        if (release.isCreatedFromTrigger()) {
            return new Some((Object)this.tryToFetchTriggerInfo(triggerRepository, release));
        }
        if (!Strings.isNullOrEmpty((String)release.getStartedFromTaskId())) {
            String masterReleaseId = Ids.releaseIdFrom((String)release.getStartedFromTaskId());
            return new Some((Object)new StartedByCreateReleaseTask((Try<String>)Try$.MODULE$.apply((Function0 & Serializable)() -> releaseRepository.getTitle(masterReleaseId)), masterReleaseId));
        }
        None$ startedBy = release.isTemplate() || release.isPlanned() ? None$.MODULE$ : releaseData.startedByLogEntry().map((Function1 & Serializable)activityLogEntry -> MODULE$.getUserFromActivityLogEntry(resolveUser, (ActivityLogEntry)activityLogEntry));
        Option createdBy = releaseData.createdByLogEntry().map((Function1 & Serializable)activityLogEntry -> MODULE$.getUserFromActivityLogEntry(resolveUser, (ActivityLogEntry)activityLogEntry));
        return new Some((Object)new StartedByUser((Option<UserThatCreatedOrStartedRelease>)startedBy, (Option<UserThatCreatedOrStartedRelease>)createdBy));
    }

    public StartedByTrigger tryToFetchTriggerInfo(TriggerRepository triggerRepository, Release release) {
        Option option = CollectionConverters$.MODULE$.ListHasAsScala(release.getTags()).asScala().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.startsWith("Trigger"))).map((Function1 & Serializable)triggerTag -> new StartedByTrigger((Try<Trigger>)Try$.MODULE$.apply((Function0 & Serializable)() -> triggerRepository.find(triggerTag)), (Option<String>)Option$.MODULE$.apply(triggerTag)));
        if (option instanceof Some) {
            Some some = (Some)option;
            StartedByTrigger startedByTrigger = (StartedByTrigger)some.value();
            return startedByTrigger;
        }
        return new StartedByTrigger((Try<Trigger>)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            throw new NotFoundException("Trigger tag is missing", new Object[0]);
        }), (Option<String>)Option$.MODULE$.empty());
    }

    public UserThatCreatedOrStartedRelease getUserFromActivityLogEntry(Function1<String, Option<String>> resolveUser, ActivityLogEntry activityLogEntry) {
        String username = (String)Option$.MODULE$.apply((Object)activityLogEntry.getUsername()).getOrElse((Function0 & Serializable)() -> ReportsService$.MODULE$.SYSTEM_USER_NAME());
        return new UserThatCreatedOrStartedRelease(username, (Option<String>)Try$.MODULE$.apply((Function0 & Serializable)() -> (Option)resolveUser.apply((Object)username)).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private CreatedByDetailsHelper$() {
    }
}

