/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVPropertiesHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVUtil {
    public static int DEPTH_ZERO = 0;
    public static int DEPTH_ONE = 1;
    public static int DEPTH_INFINITE = -1;
    private static boolean ourIsUseDAVWCURL = true;

    public static synchronized boolean isUseDAVWCURL() {
        return ourIsUseDAVWCURL;
    }

    public static synchronized void setUseDAVWCURL(boolean useDAVWCURL) {
        ourIsUseDAVWCURL = useDAVWCURL;
    }

    public static HTTPStatus getProperties(DAVConnection connection, String path, int depth, String label, DAVElement[] properties, Map result) throws SVNException {
        HTTPHeader header = new HTTPHeader();
        if (depth == DEPTH_ZERO) {
            header.setHeaderValue("Depth", "0");
        } else if (depth == DEPTH_ONE) {
            header.setHeaderValue("Depth", "1");
        } else if (depth == DEPTH_INFINITE) {
            header.setHeaderValue("Depth", "infinity");
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Invalid PROPFIND depth value: ''{0}''", new Object[]{depth});
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (label != null) {
            header.setHeaderValue("Label", label);
        }
        StringBuffer body = DAVPropertiesHandler.generatePropertiesRequest(null, properties);
        DAVPropertiesHandler davHandler = new DAVPropertiesHandler();
        davHandler.setDAVProperties(result);
        return connection.doPropfind(path, header, body, davHandler);
    }

    public static DAVProperties getResourceProperties(DAVConnection connection, String path, String label, DAVElement[] properties) throws SVNException {
        SVNHashMap resultMap = new SVNHashMap();
        HTTPStatus status = DAVUtil.getProperties(connection, path, DEPTH_ZERO, label, properties, resultMap);
        if (status.getError() != null) {
            SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
        }
        if (!resultMap.isEmpty()) {
            return (DAVProperties)resultMap.values().iterator().next();
        }
        label = label == null ? "NULL" : label;
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Failed to find label ''{0}'' for URL ''{1}''", label, path);
        SVNErrorManager.error(err, SVNLogType.NETWORK);
        return null;
    }

    public static String getPropertyValue(DAVConnection connection, String path, String label, DAVElement property) throws SVNException {
        DAVProperties props = DAVUtil.getResourceProperties(connection, path, label, new DAVElement[]{property});
        SVNPropertyValue value = props.getPropertyValue(property);
        if (value == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_PROPS_NOT_FOUND, "''{0}'' was not present on the resource", (Object)property.toString());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return value.getString();
    }

    public static DAVProperties getStartingProperties(DAVConnection connection, String path, String label) throws SVNException {
        return DAVUtil.getResourceProperties(connection, path, label, DAVElement.STARTING_PROPERTIES);
    }

    public static DAVProperties findStartingProperties(DAVConnection connection, DAVRepository repos, String fullPath) throws SVNException {
        SVNErrorMessage err;
        DAVProperties props = null;
        String originalPath = fullPath;
        String loppedPath = "";
        if ("".equals(fullPath)) {
            props = DAVUtil.getStartingProperties(connection, fullPath, null);
            if (props != null) {
                if (props.getPropertyValue(DAVElement.REPOSITORY_UUID) != null && repos != null) {
                    repos.setRepositoryUUID(props.getPropertyValue(DAVElement.REPOSITORY_UUID).getString());
                }
                props.setLoppedPath(loppedPath);
            }
            return props;
        }
        while (!"".equals(fullPath)) {
            err = null;
            Throwable nested = null;
            try {
                props = DAVUtil.getStartingProperties(connection, fullPath, null);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() == null) {
                    throw e;
                }
                err = e.getErrorMessage();
            }
            if (err == null) break;
            if (err.getErrorCode() != SVNErrorCode.FS_NOT_FOUND) {
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            loppedPath = SVNPathUtil.append(SVNPathUtil.tail(fullPath), loppedPath);
            int length = fullPath.length();
            fullPath = SVNPathUtil.removeTail(fullPath);
            if (length > 1 && "".equals(fullPath)) {
                fullPath = "/";
            }
            if (length != fullPath.length()) continue;
            SVNErrorMessage err2 = SVNErrorMessage.create(err.getErrorCode(), "The path was not part of repository");
            SVNErrorManager.error(err2, err, nested, SVNLogType.NETWORK);
        }
        if ("".equals(fullPath)) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "No part of path ''{0}'' was found in repository HEAD", (Object)originalPath);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (props != null) {
            if (props.getPropertyValue(DAVElement.REPOSITORY_UUID) != null && repos != null) {
                repos.setRepositoryUUID(props.getPropertyValue(DAVElement.REPOSITORY_UUID).getString());
            }
            if (props.getPropertyValue(DAVElement.BASELINE_RELATIVE_PATH) != null && repos != null) {
                String relativePath = props.getPropertyValue(DAVElement.BASELINE_RELATIVE_PATH).getString();
                relativePath = SVNEncodingUtil.uriEncode(relativePath);
                String rootPath = fullPath.substring(0, fullPath.length() - relativePath.length());
                repos.setRepositoryRoot(repos.getLocation().setPath(rootPath, true));
            }
            props.setLoppedPath(loppedPath);
        }
        return props;
    }

    public static String getVCCPath(DAVConnection connection, DAVRepository repository, String path) throws SVNException {
        DAVProperties properties = DAVUtil.findStartingProperties(connection, repository, path);
        SVNPropertyValue vcc = properties.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
        if (vcc == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The VCC property was not found on the resource");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return vcc.getString();
    }

    public static DAVBaselineInfo getStableURL(DAVConnection connection, DAVRepository repos, String path, long revision, boolean includeType, boolean includeRevision, DAVBaselineInfo info) throws SVNException {
        if (connection.hasHttpV2Support()) {
            info = info == null ? new DAVBaselineInfo() : info;
            info.revision = SVNRevision.isValidRevisionNumber(revision) ? revision : DAVUtil.getLatestRevisionHttpV2(connection);
            info.baselineBase = SVNPathUtil.append(connection.myRevRootStub, String.valueOf(info.revision));
            info.baselinePath = connection.getRelativePath(path);
            return info;
        }
        return DAVUtil.getBaselineInfo(connection, repos, path, revision, includeType, includeRevision, info);
    }

    public static DAVBaselineInfo getBaselineInfo(DAVConnection connection, DAVRepository repos, String path, long revision, boolean includeType, boolean includeRevision, DAVBaselineInfo info) throws SVNException {
        DAVElement[] dAVElementArray;
        DAVBaselineInfo dAVBaselineInfo = info = info == null ? new DAVBaselineInfo() : info;
        if (includeRevision) {
            dAVElementArray = DAVElement.BASELINE_PROPERTIES;
        } else {
            DAVElement[] dAVElementArray2 = new DAVElement[1];
            dAVElementArray = dAVElementArray2;
            dAVElementArray2[0] = DAVElement.BASELINE_COLLECTION;
        }
        DAVElement[] properties = dAVElementArray;
        DAVProperties baselineProperties = DAVUtil.getBaselineProperties(connection, repos, path, revision, properties);
        info.baselinePath = baselineProperties.getURL();
        SVNPropertyValue baseValue = baselineProperties.getPropertyValue(DAVElement.BASELINE_COLLECTION);
        info.baselineBase = baseValue == null ? null : baseValue.getString();
        info.baseline = baselineProperties.getOriginalURL();
        if (info.baselineBase == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "'DAV:baseline-collection' not present on the baseline resource");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (includeRevision) {
            SVNPropertyValue version = baselineProperties.getPropertyValue(DAVElement.VERSION_NAME);
            if (version == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "'DAV:version-name' not present on the baseline resource");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            try {
                info.revision = Long.parseLong(version.getString());
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
        }
        if (includeType) {
            SVNHashMap propsMap = new SVNHashMap();
            path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            HTTPStatus status = DAVUtil.getProperties(connection, path, 0, null, new DAVElement[]{DAVElement.RESOURCE_TYPE}, propsMap);
            if (status.getError() != null) {
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
            if (!propsMap.isEmpty()) {
                DAVProperties props = (DAVProperties)propsMap.values().iterator().next();
                info.isDirectory = props != null && props.isCollection();
            }
        }
        return info;
    }

    public static DAVProperties getBaselineProperties(DAVConnection connection, DAVRepository repos, String path, long revision, DAVElement[] elements) throws SVNException {
        boolean httpV2Enabled;
        boolean bl = httpV2Enabled = repos != null ? repos.isHttpV2Enabled() : ((DAVRepository)connection.getRepository()).isHttpV2Enabled();
        if (httpV2Enabled) {
            if (revision < 0L) {
                revision = DAVUtil.getLatestRevisionHttpV2(connection);
            }
            String propFindPath = connection.myRevStub + "/" + revision;
            return DAVUtil.getResourceProperties(connection, propFindPath, String.valueOf(-1L), elements);
        }
        DAVProperties properties = null;
        String loppedPath = "";
        properties = DAVUtil.findStartingProperties(connection, repos, path);
        SVNPropertyValue vccValue = properties.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
        if (vccValue == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The VCC property was not found on the resource");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        loppedPath = properties.getLoppedPath();
        SVNPropertyValue baselineRelativePathValue = properties.getPropertyValue(DAVElement.BASELINE_RELATIVE_PATH);
        if (baselineRelativePathValue == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The relative-path property was not found on the resource");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        String baselineRelativePath = SVNEncodingUtil.uriEncode(baselineRelativePathValue.getString());
        baselineRelativePath = SVNPathUtil.append(baselineRelativePath, loppedPath);
        String label = null;
        String vcc = vccValue.getString();
        if (revision < 0L) {
            vcc = DAVUtil.getPropertyValue(connection, vcc, null, DAVElement.CHECKED_IN);
        } else {
            label = Long.toString(revision);
        }
        properties = DAVUtil.getResourceProperties(connection, vcc, label, elements);
        properties.setURL(baselineRelativePath);
        return properties;
    }

    public static long getLatestRevisionHttpV2(DAVConnection davConnection) throws SVNException {
        davConnection.myLatestRevision = -1L;
        HTTPStatus status = davConnection.doOptions(davConnection.getLocation().getPath());
        if (status.getCode() != 200) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "OPTIONS request (for latest revision) got HTTP response code {0}", new Object[]{status.getCode()});
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        davConnection.parseCapabilities(status);
        if (!SVNRevision.isValidRevisionNumber(davConnection.myLatestRevision)) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "The OPTIONS response did not include the youngest revision");
            SVNErrorManager.error(errorMessage, SVNLogType.NETWORK);
        }
        return davConnection.myLatestRevision;
    }

    public static SVNProperties filterProperties(DAVProperties source, SVNProperties target) {
        target = target == null ? new SVNProperties() : target;
        for (Map.Entry entry : source.getProperties().entrySet()) {
            DAVElement element = (DAVElement)entry.getKey();
            SVNPropertyValue value = (SVNPropertyValue)entry.getValue();
            String propertyName = DAVUtil.getPropertyNameByElement(element);
            if (propertyName == null) continue;
            target.put(propertyName, value);
        }
        return target;
    }

    public static String getPropertyNameByElement(DAVElement element) {
        if (element == null) {
            return null;
        }
        String namespace = element.getNamespace();
        String name = element.getName();
        if (namespace.equals("http://subversion.tigris.org/xmlns/custom/")) {
            if (name.startsWith("svk_")) {
                name = name.substring(0, "svk".length()) + ":" + name.substring("svk".length() + 1);
            }
            return name;
        }
        if (namespace.equals("http://subversion.tigris.org/xmlns/svn/")) {
            return "svn:" + name;
        }
        if (element == DAVElement.CHECKED_IN) {
            return "svn:wc:ra_dav:version-url";
        }
        return null;
    }

    public static void setSpecialWCProperties(SVNProperties props, DAVElement property, SVNPropertyValue propValue) {
        DAVUtil.setSpecialWCProperties(props, property, propValue, false);
    }

    public static void setSpecialWCProperties(SVNProperties props, DAVElement property, SVNPropertyValue propValue, boolean isDir) {
        String propName = DAVUtil.convertDAVElementToPropName(property, isDir);
        if (propName != null) {
            props.put(propName, propValue);
        }
    }

    public static void setSpecialWCProperties(ISVNEditor editor, boolean isDir, String path, DAVElement property, SVNPropertyValue propValue) throws SVNException {
        String propName = DAVUtil.convertDAVElementToPropName(property, isDir);
        if (propName != null) {
            if (isDir) {
                editor.changeDirProperty(propName, propValue);
            } else {
                editor.changeFileProperty(path, propName, propValue);
            }
        }
    }

    public static String getPathFromURL(String url) {
        String schemeEnd = "://";
        int ind = url.indexOf(schemeEnd);
        if (ind == -1) {
            return url;
        }
        url = url.substring(schemeEnd.length());
        for (int i = 0; i < url.length(); ++i) {
            char currentChar = url.charAt(i);
            if (currentChar != '/' && currentChar != '?' && currentChar != '#') continue;
            return url.substring(i);
        }
        return "/";
    }

    private static String convertDAVElementToPropName(DAVElement property, boolean isDir) {
        String propName = null;
        if (property == DAVElement.VERSION_NAME) {
            propName = "svn:entry:committed-rev";
        } else if (property == DAVElement.CREATOR_DISPLAY_NAME) {
            propName = "svn:entry:last-author";
        } else if (property == DAVElement.CREATION_DATE) {
            propName = "svn:entry:committed-date";
        } else if (property == DAVElement.REPOSITORY_UUID) {
            propName = "svn:entry:uuid";
        } else if (property == DAVElement.MD5_CHECKSUM && !isDir) {
            propName = "svn:entry:checksum";
        } else if (property == DAVElement.SHA1_CHECKSUM && !isDir) {
            propName = "svnkit:entry:sha1-checksum";
        }
        return propName;
    }

    public static SVNErrorMessage createUnexpectedStatusErrorMessage(HTTPStatus httpStatus, String method, String path) {
        SVNErrorMessage errorMessage;
        int code = httpStatus.getCode();
        String location = httpStatus.getHeader().getFirstHeaderValue("Location");
        if (code != 405 && (errorMessage = DAVUtil.createDefaultUnexpectedStatusErrorMessage(httpStatus, path, location)) != null) {
            return errorMessage;
        }
        switch (code) {
            case 201: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Path ''{0}'' unexpectedly created", (Object)path);
            }
            case 204: {
                return SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", (Object)path);
            }
            case 405: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_METHOD_NOT_ALLOWED, "The HTTP method ''{0}'' is not allowed on ''{1}''", method, path);
            }
        }
        return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unexpected HTTP status {0} ''{1}'' on ''{2}'' request to ''{3}''", code, httpStatus.getReason(), method, path);
    }

    private static SVNErrorMessage createDefaultUnexpectedStatusErrorMessage(HTTPStatus httpStatus, String path, String location) {
        int code = httpStatus.getCode();
        switch (code) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_RELOCATED, code == 301 ? "Repository moved permanently to ''{0}''" : "Repository moved temporarily to '%s'", (Object)location);
            }
            case 403: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_FORBIDDEN, "Access to ''{0}'' forbidden", (Object)path);
            }
            case 404: {
                return SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' path not found", (Object)path);
            }
            case 405: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_METHOD_NOT_ALLOWED, "HTTP method is not allowed on ''{0}''", (Object)path);
            }
            case 409: {
                return SVNErrorMessage.create(SVNErrorCode.FS_CONFLICT, "''{0}'' conflicts", (Object)path);
            }
            case 412: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_PRECONDITION_FAILED, "Precondition on ''{0}'' failed", (Object)path);
            }
            case 423: {
                return SVNErrorMessage.create(SVNErrorCode.FS_NO_LOCK_TOKEN, "''{0}'': no lock token available", (Object)path);
            }
            case 411: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "DAV request failed: 411 Content length required. The server or an intermediate proxy does not accept chunked encoding. Try setting 'http-chunked-requests' to 'auto' or 'no' in your client configuration.");
            }
            case 500: {
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unexpected server error {0} ''{1}'' on ''{2}''", code, httpStatus.getReason(), path);
            }
            case 501: {
                return SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The requested feature is not supported by '%s'", (Object)path);
            }
        }
        if (code >= 300 || code <= 199) {
            return SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unexpected HTTP status {0} ''{1}'' on ''{2}''", code, httpStatus.getReason(), path);
        }
        return null;
    }
}

