/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public final class StringValue
extends ASTNodeAccessImpl
implements Expression {
    private String value = "";
    private String prefix = null;
    public static final List<String> ALLOWED_PREFIXES = Arrays.asList("N", "U", "E", "R", "B", "RB", "_utf8");

    public StringValue() {
    }

    public StringValue(String string) {
        if (string.startsWith("'") && string.endsWith("'")) {
            this.value = string.substring(1, string.length() - 1);
            return;
        }
        if (string.length() > 2) {
            for (String string2 : ALLOWED_PREFIXES) {
                if (string.length() <= string2.length() || !string.substring(0, string2.length()).equalsIgnoreCase(string2) || string.charAt(string2.length()) != '\'') continue;
                this.prefix = string2;
                this.value = string.substring(string2.length() + 1, string.length() - 1);
                return;
            }
        }
        this.value = string;
    }

    public final String getValue() {
        return this.value;
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final String getNotExcapedValue() {
        StringBuilder stringBuilder = new StringBuilder(this.value);
        int n2 = 0;
        int n3 = 0;
        while ((n2 = this.value.indexOf("''", n2)) != -1) {
            stringBuilder.deleteCharAt(n2 - n3);
            n2 += 2;
            ++n3;
        }
        return stringBuilder.toString();
    }

    public final void setValue(String string) {
        this.value = string;
    }

    public final void setPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public final void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public final String toString() {
        return (this.prefix != null ? this.prefix : "") + "'" + this.value + "'";
    }

    public final StringValue withPrefix(String string) {
        this.setPrefix(string);
        return this;
    }

    public final StringValue withValue(String string) {
        this.setValue(string);
        return this;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (StringValue)object;
        return Objects.equals(this.value, ((StringValue)object).value) && Objects.equals(this.prefix, ((StringValue)object).prefix);
    }

    public final int hashCode() {
        return Objects.hash(this.value, this.prefix);
    }
}

