/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.CreateSynonymChange;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymChange;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.OutputChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class ChangedSynonymChangeGenerator
extends LicenseCheckingChangeGenerator
implements ChangedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Synonym.class.isAssignableFrom(clazz)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    @Override
    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences object, DiffOutputControl diffOutputControl, Database database, Database object2, ChangeGeneratorChain object3) {
        object = (Synonym)databaseObject;
        object2 = new DropSynonymChange();
        ((DropSynonymChange)object2).setSynonymName(((Synonym)object).getName());
        ((DropSynonymChange)object2).setObjectType(((Synonym)object).getObjectType());
        if (!(database instanceof MSSQLDatabase)) {
            ((DropSynonymChange)object2).setPrivate(((Synonym)object).isPrivate());
        }
        if (diffOutputControl.getIncludeCatalog()) {
            ((DropSynonymChange)object2).setSynonymCatalogName(((Synonym)object).getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            ((DropSynonymChange)object2).setSynonymSchemaName(((Synonym)object).getSchema().getName());
        }
        object3 = new CreateSynonymChange();
        ((CreateSynonymChange)object3).setSynonymName(((Synonym)object).getName());
        ((CreateSynonymChange)object3).setObjectName(((Synonym)object).getObjectName());
        boolean bl2 = ((Synonym)object).isPrivate();
        if (database instanceof MSSQLDatabase) {
            bl2 = false;
        }
        ((CreateSynonymChange)object3).setPrivate(bl2);
        ((CreateSynonymChange)object3).setObjectType(((Synonym)object).getObjectType());
        if (bl2 && ((Synonym)object).getSchema() != null) {
            if (diffOutputControl.getIncludeCatalog()) {
                ((CreateSynonymChange)object3).setSynonymCatalogName(((Synonym)object).getSchema().getCatalogName());
            }
            if (diffOutputControl.getIncludeSchema()) {
                ((CreateSynonymChange)object3).setSynonymSchemaName(((Synonym)object).getSchema().getName());
            }
        }
        if (((Synonym)object).getObjectSchema() != null) {
            boolean bl3;
            bl2 = !StringUtil.trimToEmpty(((Synonym)object).getObjectSchema().getCatalogName()).equalsIgnoreCase(StringUtil.trimToEmpty(database.getDefaultCatalogName()));
            boolean bl4 = bl3 = !StringUtil.trimToEmpty(((Synonym)object).getObjectSchema().getName()).equalsIgnoreCase(StringUtil.trimToEmpty(database.getDefaultSchemaName()));
            if (bl2 || diffOutputControl.getIncludeCatalog()) {
                ((CreateSynonymChange)object3).setObjectCatalogName(((Synonym)object).getObjectSchema().getCatalogName());
            }
            if (bl3 || diffOutputControl.getIncludeSchema()) {
                ((CreateSynonymChange)object3).setObjectSchemaName(((Synonym)object).getObjectSchema().getName());
            }
        }
        if (database instanceof OracleDatabase && ((CreateSynonymChange)object3).getSynonymCatalogName() != null && ((CreateSynonymChange)object3).getSynonymSchemaName() == null) {
            Object object4 = object3;
            ((CreateSynonymChange)object4).setSynonymSchemaName(((CreateSynonymChange)object4).getSynonymCatalogName());
            ((CreateSynonymChange)object3).setSynonymCatalogName(null);
        }
        if (database instanceof OracleDatabase && ((CreateSynonymChange)object3).getObjectCatalogName() != null && ((CreateSynonymChange)object3).getObjectSchemaName() == null) {
            Object object5 = object3;
            ((CreateSynonymChange)object5).setObjectSchemaName(((CreateSynonymChange)object5).getObjectCatalogName());
            ((CreateSynonymChange)object3).setObjectCatalogName(null);
        }
        if (database instanceof OracleDatabase && databaseObject.getAttribute("missingSchema", Boolean.FALSE).booleanValue()) {
            OutputChange outputChange = new OutputChange();
            outputChange.setMessage("No schema found for the object pointed to by this synonym. This may mean it references an object across database link. Please ensure the synonym is being created correctly.");
            return new Change[]{outputChange, object2, object3};
        }
        return new Change[]{object2, object3};
    }
}

