/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.google.common.base.Strings;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerState;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository;
import com.xebialabs.plugin.manager.startup.PluginSynchronizer;
import com.xebialabs.plugin.manager.startup.SourceOfTruth$;
import com.xebialabs.plugin.manager.startup.SynchronizationCondition;
import com.xebialabs.xlrelease.ReleaseServer;
import com.xebialabs.xlrelease.XLReleaseBootstrapper;
import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.plugin.classloading.XlrPluginClassLoader;
import com.xebialabs.xlrelease.script.Jsr223EngineFactory;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.spring.configuration.XlrWebApplicationInitializer;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.sql.DataSource;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Marker;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.ResourceUtils;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class XLReleaseBootstrapper$
implements Logging {
    public static final XLReleaseBootstrapper$ MODULE$ = new XLReleaseBootstrapper$();
    private static final String PRODUCT_DIGITALAI;
    private static final String LOGBACK_CONFIG_FILE;
    private static final String MAINTENANCE_MODE_LOG_MESSAGE;
    private static final File PLUGINS_LOCAL_FOLDER;
    private static final File PLUGINS_OFFICIAL_FOLDER;
    private static final File HOTFIX_PLUGINS_FOLDER;
    private static ReleaseServer releaseServer;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$((Logging)MODULE$);
        PRODUCT_DIGITALAI = "Digital.ai Release";
        LOGBACK_CONFIG_FILE = "logback.configurationFile";
        MAINTENANCE_MODE_LOG_MESSAGE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The system is booting in maintenance mode. The following features are disabled:\n      |- automated triggers\n      |- archiving\n      |- archive purging\n      |- email notifications\n      |- non-admin access\n      |- task recovery"));
        PLUGINS_LOCAL_FOLDER = new File("plugins/__local__");
        PLUGINS_OFFICIAL_FOLDER = new File("plugins/xlr-official");
        HOTFIX_PLUGINS_FOLDER = new File("hotfix/plugins");
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XLReleaseBootstrapper$ xLReleaseBootstrapper$ = this;
        synchronized (xLReleaseBootstrapper$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : grizzled$slf4j$Logging$$_logger;
    }

    public String PRODUCT_DIGITALAI() {
        return PRODUCT_DIGITALAI;
    }

    public String LOGBACK_CONFIG_FILE() {
        return LOGBACK_CONFIG_FILE;
    }

    public String MAINTENANCE_MODE_LOG_MESSAGE() {
        return MAINTENANCE_MODE_LOG_MESSAGE;
    }

    public File PLUGINS_LOCAL_FOLDER() {
        return PLUGINS_LOCAL_FOLDER;
    }

    public File PLUGINS_OFFICIAL_FOLDER() {
        return PLUGINS_OFFICIAL_FOLDER;
    }

    public File HOTFIX_PLUGINS_FOLDER() {
        return HOTFIX_PLUGINS_FOLDER;
    }

    public ReleaseServer releaseServer() {
        return releaseServer;
    }

    public void releaseServer_$eq(ReleaseServer x$1) {
        releaseServer = x$1;
    }

    public void boot(String[] args) {
        ReleaseServer.outputReleaseInfo();
        XLReleaseServerLaunchOptions launchOptions = XLReleaseServerLaunchOptions.parseCommandLine(args);
        if (launchOptions == null) {
            System.exit(0);
        }
        File serverConfFile = ResourceUtils.getFile((String)XlrConfig$.MODULE$.bootConfig().confFile_location());
        ServerConfigFile confFile = new ServerConfigFile(serverConfFile);
        Security.addProvider((Provider)new BouncyCastleProvider());
        XLReleasePermissions.init();
        this.releaseServer_$eq(new ReleaseServer(launchOptions, confFile));
        this.releaseServer().prepareConfigs();
        this.validateNoPluginsOnClasspath();
        this.initPluginClassloader();
        ClassLoader pluginTccl = Thread.currentThread().getContextClassLoader();
        XlrConfig xlrConfig = XlrConfig$.MODULE$.getInstance();
        if (xlrConfig.maintenanceModeEnabled()) {
            ServerState.getInstance().maintenanceStart(new MaintenanceStartEvent());
            this.logger().warn((Function0 & Serializable)() -> MODULE$.MAINTENANCE_MODE_LOG_MESSAGE());
        }
        if (xlrConfig.security().scripting().sandbox().jython().isolatePlugins()) {
            ClassLoader jythonEngineClassloader = Jsr223EngineFactory.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(jythonEngineClassloader);
        }
        Runnable jythonInitialization = () -> {};
        Thread jythonInitializationThread = new Thread(jythonInitialization, "jython-initialization");
        jythonInitializationThread.start();
        Thread.currentThread().setContextClassLoader(pluginTccl);
        this.syncPlugins();
        LocalBooter.boot();
    }

    /*
     * Unable to fully structure code
     */
    public void syncPlugins() {
        dataSource = XLReleaseBootstrapper$.createDataSource$1();
        jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        shouldSync = new SynchronizationCondition(new JdbcTemplate((DataSource)dataSource), "xlr-xlpm-module").shouldSync();
        var5_4 = new Tuple2((Object)Thread.currentThread().getContextClassLoader(), (Object)BoxesRunTime.boxToBoolean((boolean)shouldSync));
        if (var5_4 == null) ** GOTO lbl-1000
        pluginClassLoader = (ClassLoader)var5_4._1();
        var7_6 = var5_4._2$mcZ$sp();
        if (!(pluginClassLoader instanceof XlrPluginClassLoader)) ** GOTO lbl-1000
        var8_7 = (XlrPluginClassLoader)pluginClassLoader;
        if (var7_6) {
            this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$syncPlugins$1(), ()Ljava/lang/String;)());
            var8_7.clearClasspathRoots();
            XLReleaseBootstrapper$.createPluginSynchronizer$1(jdbcTemplate).syncPlugins();
            var8_7.refreshDirs();
            var1_8 = BoxedUnit.UNIT;
        } else lbl-1000:
        // 3 sources

        {
            this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$syncPlugins$2(), ()Ljava/lang/String;)());
            var1_9 = BoxedUnit.UNIT;
        }
        dataSource.close();
    }

    public void initPluginClassloader() {
        TConfig.get().setArchiveDetector(new TArchiveDetector((FsDriverProvider)TArchiveDetector.ALL, "jar", (FsDriver)new JarDriver((IOPoolProvider)IOPoolLocator.SINGLETON)));
        Files.createDirectories(this.HOTFIX_PLUGINS_FOLDER().toPath(), new FileAttribute[0]);
        Files.createDirectories(this.PLUGINS_LOCAL_FOLDER().toPath(), new FileAttribute[0]);
        Files.createDirectories(this.PLUGINS_OFFICIAL_FOLDER().toPath(), new FileAttribute[0]);
        List pluginDirectories = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.HOTFIX_PLUGINS_FOLDER(), this.PLUGINS_LOCAL_FOLDER(), this.PLUGINS_OFFICIAL_FOLDER()}));
        XlrPluginClassLoader pluginClassloader = new XlrPluginClassLoader((Iterable<File>)pluginDirectories, this.getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(pluginClassloader);
    }

    public void main(String[] args) {
        this.boot(args);
        System.setProperty("liquibase.hub.mode", "off");
        SpringApplication app = new SpringApplication(new Class[]{XLReleaseBootstrapper.class});
        app.setAllowBeanDefinitionOverriding(true);
        app.setBannerMode(Banner.Mode.OFF);
        app.setDefaultProperties(this.defaultProperties());
        app.addInitializers(new ApplicationContextInitializer[]{new XlrWebApplicationInitializer()});
        app.run(args);
    }

    /*
     * WARNING - void declaration
     */
    private Properties defaultProperties() {
        void var1_1;
        Object object;
        Properties properties = new Properties();
        properties.put("spring.liquibase.enabled", "false");
        properties.put("spring.backgroundpreinitializer.ignore", "true");
        properties.put("server.shutdown", "immediate");
        properties.put("xl.server.session.storage.enabled", BoxesRunTime.boxToBoolean((boolean)XlrConfig$.MODULE$.getInstance().server_session_storage_enabled()));
        properties.put("xl.release.config", XlrConfig$.MODULE$.defaultConfigName());
        if (Strings.isNullOrEmpty((String)System.getProperty(this.LOGBACK_CONFIG_FILE()))) {
            object = properties.put("logging.config", "conf/logback.xml");
        } else {
            properties.put("logging.config", System.getProperty(this.LOGBACK_CONFIG_FILE()));
            object = System.setProperty(this.LOGBACK_CONFIG_FILE(), "");
        }
        properties.put("spring.main.allow-circular-references", BoxesRunTime.boxToBoolean((boolean)true));
        properties.put("server.servlet.context-parameters.resteasy.async.job.service.enabled", BoxesRunTime.boxToBoolean((boolean)true));
        properties.put("server.servlet.context-parameters.resteasy.document.expand.entity.references", BoxesRunTime.boxToBoolean((boolean)false));
        return var1_1;
    }

    private void validateNoPluginsOnClasspath() {
        block0: {
            String classPathSeparator;
            String classPath = System.getProperty("java.class.path", ".");
            if (!ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])classPath.split(classPathSeparator = System.getProperty("path.separator"))), (Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)XLReleaseBootstrapper$.MODULE$.isPluginEntry(entry)))) break block0;
            this.logger().error((Function0 & Serializable)() -> "Plugin related directories are on the server classpath -- the system may not start properly. Please remove the following entries from the conf/xlr-wrapper-*.conf files: hotfix/plugins, plugins/__local__, plugins/xlr-official. From Release 10.2 on, the plugin classpath is handled internally by the Plugin Manager. Consult the documentation for more details at https://docs.xebialabs.com/release/how-to/upgrade-7.5.x-to-current/");
        }
    }

    private boolean isPluginEntry(String entry) {
        return entry.toLowerCase().startsWith("hotfix/*") || entry.toLowerCase().startsWith("hotfix/plugins") || entry.toLowerCase().startsWith("plugins");
    }

    private static final HikariDataSource createDataSource$1() {
        XlrConfig xlrConfig = XlrConfig$.MODULE$.getInstance();
        HikariConfig cfg = new HikariConfig();
        cfg.setDriverClassName(xlrConfig.xlrRepositoryDriver());
        cfg.setJdbcUrl(xlrConfig.xlrRepositoryJdbcUrl());
        cfg.setUsername(xlrConfig.xlrRepositoryUsername());
        cfg.setPassword(xlrConfig.xlrRepositoryPassword());
        return new HikariDataSource(cfg);
    }

    private static final PluginSynchronizer createPluginSynchronizer$1(JdbcTemplate jdbcTemplate) {
        String pluginSource = XLReleaseServerLaunchOptions.getInstance().getPluginSource();
        Enumeration.Value sourceOfTruth = pluginSource != null ? SourceOfTruth$.MODULE$.withName(pluginSource) : SourceOfTruth$.MODULE$.DATABASE();
        return new PluginSynchronizer(new SqlPluginRepository(jdbcTemplate), "xl-release", sourceOfTruth);
    }

    public static final /* synthetic */ String $anonfun$syncPlugins$1() {
        return "Attempting plugin synchronization...";
    }

    public static final /* synthetic */ String $anonfun$syncPlugins$2() {
        return "Skipping plugin synchronization";
    }

    private XLReleaseBootstrapper$() {
    }
}

