/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.scm.connector.ScmConnectorConfig;
import com.xebialabs.xlrelease.dsl.service.DslExporter;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.scm.connector.ScmConnectorService;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse$;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.actors.extensions.TemplateVersionExtensionActorMessages;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings$;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.views.TemplateContentAndPrevious;
import com.xebialabs.xlrelease.versioning.templates.views.VersionView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;

@Path(value="/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\tmg\u0001\u0002\f\u0018\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011i\u0003!\u0011!Q\u0001\nmC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\")q\u000e\u0001C\u0001a\"9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!!3\u0001\t\u0003\tY\rC\u0004\u0002r\u0002!\t!a=\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!\u0011\u0006\u0001\u0005\u0002\t-\u0002b\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011i\n\u0001C\u0005\u0005?\u0013!\u0004V3na2\fG/\u001a,feNLwN\\5oOJ+7o\\;sG\u0016T!\u0001G\r\u0002\u0013Q,W\u000e\u001d7bi\u0016\u001c(B\u0001\u000e\u001c\u0003)1XM]:j_:Lgn\u001a\u0006\u00039u\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005yy\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0001\u0013aA2p[\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000bMdg\r\u000e6\u000b\u00039\n\u0001b\u001a:jujdW\rZ\u0005\u0003a-\u0012q\u0001T8hO&tw-A\u0006eg2,\u0005\u0010]8si\u0016\u0014\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u001d\u0019XM\u001d<jG\u0016T!aN\u000e\u0002\u0007\u0011\u001cH.\u0003\u0002:i\tYAi\u001d7FqB|'\u000f^3s\u0003i!X-\u001c9mCR,'+\u001a<jg&|gNU3q_NLGo\u001c:z!\tat(D\u0001>\u0015\tqt#\u0001\u0006sKB|7/\u001b;pefL!\u0001Q\u001f\u00035Q+W\u000e\u001d7bi\u0016\u0014VM^5tS>t'+\u001a9pg&$xN]=\u0002-Q,W\u000e\u001d7bi\u0016\u001cFo\u001c:bO\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u0011#\u000e\u0003]I!!R\f\u0003-Q+W\u000e\u001d7bi\u0016\u001cFo\u001c:bO\u0016\u001cVM\u001d<jG\u0016\f1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001S&\u000e\u0003%S!AS\u000e\u0002\r\u0005\u001cGo\u001c:t\u0013\ta\u0015JA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-A\tqKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\u0004\"a\u0014*\u000e\u0003AS!!U\u000e\u0002\u0011M,7-\u001e:jifL!a\u0015)\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0011\u0005YCV\"A,\u000b\u0005UZ\u0012BA-X\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005qsV\"A/\u000b\u0005yZ\u0012BA0^\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180A\fuK6\u0004H.\u0019;f'R|'/Y4f\u0019&\u001cH/\u001a8feB\u0011!-Z\u0007\u0002G*\u0011A-G\u0001\u0004g\u000el\u0017B\u00014d\u0005e\u00196-\u001c+f[Bd\u0017\r^3Ti>\u0014\u0018mZ3TKJ4\u0018nY3\u0002'M\u001cWnQ8o]\u0016\u001cGo\u001c:TKJ4\u0018nY3\u0011\u0005%lW\"\u00016\u000b\u0005-d\u0017!C2p]:,7\r^8s\u0015\t!7$\u0003\u0002oU\n\u00192kY7D_:tWm\u0019;peN+'O^5dK\u00061A(\u001b8jiz\"\"\"\u001d:tiV4x\u000f_={!\t\u0019\u0005\u0001C\u00032\u0015\u0001\u0007!\u0007C\u0003;\u0015\u0001\u00071\bC\u0003B\u0015\u0001\u0007!\tC\u0003G\u0015\u0001\u0007q\tC\u0003N\u0015\u0001\u0007a\nC\u0003U\u0015\u0001\u0007Q\u000bC\u0003[\u0015\u0001\u00071\fC\u0003a\u0015\u0001\u0007\u0011\rC\u0003h\u0015\u0001\u0007\u0001\u000e\u000b\u0002\u000byB\u0019Q0!\u0005\u000e\u0003yT1a`A\u0001\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u0007\t)!A\u0004gC\u000e$xN]=\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003\u0017\ti!A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ty!A\u0002pe\u001eL1!a\u0005\u007f\u0005%\tU\u000f^8xSJ,G-\u0001\u0010hKR$V-\u001c9mCR,g+\u001a:tS>tw.\u001b8h'\u0016$H/\u001b8hgV\u0011\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0019!w.\\1j]*\u0019\u00111E\f\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\t9#!\b\u00035Q+W\u000e\u001d7bi\u00164VM]:j_:LgnZ*fiRLgnZ:)\u000f-\tY#a\u0010\u0002BA!\u0011QFA\u001e\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012A\u0001:t\u0015\u0011\t)$a\u000e\u0002\u0005]\u001c(BAA\u001d\u0003\u0015Q\u0017M^1y\u0013\u0011\ti$a\f\u0003\tA\u000bG\u000f[\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u0007\n\u0011bL:fiRLgnZ:)\u0007-\t9\u0005\u0005\u0003\u0002.\u0005%\u0013\u0002BA&\u0003_\u00111aR#U\u00039\u0019wN\u001c8fGRLwN\\%oM>$B!!\u0015\u0002^A!\u00111KA-\u001b\t\t)F\u0003\u0003\u0002X\u0005=\u0012\u0001B2pe\u0016LA!a\u0017\u0002V\tA!+Z:q_:\u001cX\rC\u0004\u0002`1\u0001\r!!\u0019\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\r\u0005\u0003\u0002d\u0005Ed\u0002BA3\u0003[\u00022!a\u001a&\u001b\t\tIGC\u0002\u0002l\u0005\na\u0001\u0010:p_Rt\u0014bAA8K\u00051\u0001K]3eK\u001aLA!a\u001d\u0002v\t11\u000b\u001e:j]\u001eT1!a\u001c&Q\u0011\ti&!\u001f\u0011\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{R1!a \u001c\u0003\u0015\u0001\u0018M]1n\u0013\u0011\t\u0019)! \u0003\u000f%#\u0007+\u0019:b[\"B\u0011QLAD\u0003\u007f\ti\t\u0005\u0003\u0002.\u0005%\u0015\u0002BAF\u0003_\u0011\u0011\u0002U1uQB\u000b'/Y7\"\u0005\u0005}\u0003f\u0002\u0007\u0002,\u0005}\u0012\u0011S\u0011\u0003\u0003'\u000b1f\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSSpL2p]:,7\r^5p]&sgm\u001c\u0015\u0004\u0019\u0005\u001d\u0013\u0001D4fiJ+g/[:j_:\u001cH\u0003BA)\u00037Cq!a\u0018\u000e\u0001\u0004\t\t\u0007\u000b\u0003\u0002\u001c\u0006e\u0004\u0006CAN\u0003\u000f\u000by$!$)\u000f5\tY#a\u0010\u0002$\u0006\u0012\u0011QU\u0001(_m$X-\u001c9mCR,\u0017\n\u001a\u001e/UI+G.Z1tKnsv&L/+{>\u0012XM^5tS>t7\u000fK\u0002\u000e\u0003\u000f\n!cZ3u%\u00164\u0018n]5p]\u000e{g\u000e^3oiR1\u0011\u0011KAW\u0003gCq!a\u0018\u000f\u0001\u0004\t\t\u0007\u000b\u0003\u0002.\u0006e\u0004\u0006CAW\u0003\u000f\u000by$!$\t\u000f\u0005Uf\u00021\u0001\u00028\u0006Q!/\u001a<jg&|g.\u00133\u0011\u0007\u0011\nI,C\u0002\u0002<\u0016\u00121!\u00138uQ!\t\u0019,a\"\u0002@\u0005}\u0016EAA[Q\u001dq\u00111FA \u0003\u0007\f#!!2\u0002y=ZH/Z7qY\u0006$X-\u00133;])\u0012V\r\\3bg\u0016\\flL\u0017^Uu|#/\u001a<jg&|gn]\u0018|e\u00164\u0018n]5p]&#WpL2p]R,g\u000e\u001e\u0015\u0004\u001d\u0005\u001d\u0013!D2sK\u0006$XMV3sg&|g\u000e\u0006\u0004\u0002R\u00055\u00171\u001b\u0005\b\u0003?z\u0001\u0019AA1Q\u0011\ti-!\u001f)\u0011\u00055\u0017qQA \u0003\u001bCq!!6\u0010\u0001\u0004\t9.A\u0006wKJ\u001c\u0018n\u001c8WS\u0016<\b\u0003BAm\u0003?l!!a7\u000b\u0007\u0005uw#A\u0003wS\u0016<8/\u0003\u0003\u0002b\u0006m'a\u0003,feNLwN\u001c,jK^DsaDA\u0016\u0003\u007f\t)/\t\u0002\u0002h\u00061sf\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSSp\f<feNLwN\\:)\u0007=\tY\u000f\u0005\u0003\u0002.\u00055\u0018\u0002BAx\u0003_\u0011A\u0001U(T)\u0006y!/Z:u_J,'+\u001a<jg&|g\u000e\u0006\u0004\u0002R\u0005U\u00181 \u0005\b\u0003?\u0002\u0002\u0019AA1Q\u0011\t)0!\u001f)\u0011\u0005U\u0018qQA \u0003\u001bCq!!.\u0011\u0001\u0004\t9\f\u000b\u0005\u0002|\u0006\u001d\u0015qHA`Q\u001d\u0001\u00121FA \u0005\u0003\t#Aa\u0001\u0002y=ZH/Z7qY\u0006$X-\u00133;])\u0012V\r\\3bg\u0016\\flL\u0017^Uu|#/\u001a<jg&|gn]\u0018|e\u00164\u0018n]5p]&#Wp\f:fgR|'/\u001a\u0015\u0004!\t\u001d\u0001\u0003BA\u0017\u0005\u0013IAAa\u0003\u00020\t\u0019\u0001+\u0016+\u0002\u001d\u0011,G.\u001a;f%\u00164\u0018n]5p]R1\u0011\u0011\u000bB\t\u0005/Aq!a\u0018\u0012\u0001\u0004\t\t\u0007\u000b\u0003\u0003\u0012\u0005e\u0004\u0006\u0003B\t\u0003\u000f\u000by$!$\t\u000f\u0005U\u0016\u00031\u0001\u00028\"B!qCAD\u0003\u007f\ty\fK\u0004\u0012\u0003W\tyD!\b\"\u0005\t}\u0011\u0001N\u0018|i\u0016l\u0007\u000f\\1uK&#'H\f\u0016SK2,\u0017m]3\\=>jSLK?0e\u00164\u0018n]5p]N|3P]3wSNLwN\\%e{\"\u001a\u0011Ca\t\u0011\t\u00055\"QE\u0005\u0005\u0005O\tyC\u0001\u0004E\u000b2+E+R\u0001\u0010I\u0016dW\r^3SKZL7/[8ogR1\u0011\u0011\u000bB\u0017\u0005gAq!a\u0018\u0013\u0001\u0004\t\t\u0007\u000b\u0003\u0003.\u0005e\u0004\u0006\u0003B\u0017\u0003\u000f\u000by$!$\t\u000f\tU\"\u00031\u0001\u00038\u0005Y!/\u001a<jg&|g.\u00133t!\u0019\u0011IDa\u0011\u000286\u0011!1\b\u0006\u0005\u0005{\u0011y$\u0001\u0003vi&d'B\u0001B!\u0003\u0011Q\u0017M^1\n\t\t\u0015#1\b\u0002\u0005\u0019&\u001cH\u000fK\u0004\u0013\u0003W\ty$a))\u0007I\u0011\u0019#A\u0004d_6\u0004\u0018M]3\u0015\u0011\t=#Q\u000bB.\u0005c\u0002B!!7\u0003R%!!1KAn\u0005i!V-\u001c9mCR,7i\u001c8uK:$\u0018I\u001c3Qe\u00164\u0018n\\;t\u0011\u001d\tyf\u0005a\u0001\u0003CBCA!\u0016\u0002z!B!QKAD\u0003\u007f\ti\tC\u0004\u00026N\u0001\r!a.)\u0011\tm#qLA \u0003\u007f\u0003B!!\f\u0003b%!!1MA\u0018\u0005)\tV/\u001a:z!\u0006\u0014\u0018-\u001c\u0015\t\u00057\u00129'a\u0010\u0003nA!\u0011Q\u0006B5\u0013\u0011\u0011Y'a\f\u0003\u0019\u0011+g-Y;miZ\u000bG.^3\"\u0005\t=\u0014!\u0001\u0019\t\u000f\tM4\u00031\u0001\u00028\u0006aAo\u001c*fm&\u001c\u0018n\u001c8JI\"B!\u0011\u000fB0\u0003\u007f\u00119(\t\u0002\u0003t!B!\u0011\u000fB4\u0003\u007f\u0011i\u0007K\u0004\u0014\u0003W\tyD! \"\u0005\t}\u0014!J\u0018|i\u0016l\u0007\u000f\\1uK&#'H\f\u0016SK2,\u0017m]3\\=>jSLK?0G>l\u0007/\u0019:fQ\r\u0019\u0012qI\u0001\u0015O\u0016$(+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;\u0015\t\t\u001d%1\u0014\t\u0005\u0005\u0013\u00139*\u0004\u0002\u0003\f*!!Q\u0012BH\u00035\u0019XM]5bY&T\u0018\r^5p]*!!\u0011\u0013BJ\u0003!\u0001H.^7cS:<'b\u0001BK;\u0005AA-\u001a9m_fLG/\u0003\u0003\u0003\u001a\n-%!\u0005*fg>dW\u000f^5p]\u000e{g\u000e^3yi\"9\u0011q\f\u000bA\u0002\u0005\u0005\u0014\u0001E4fiR+W\u000e\u001d7bi\u0016\f5\u000fR:m)\u0011\t\tG!)\t\u000f\t\rV\u00031\u0001\u0003&\u0006AA/Z7qY\u0006$X\r\u0005\u0003\u0003(\n-VB\u0001BU\u0015\r\tybG\u0005\u0005\u0005[\u0013IKA\u0004SK2,\u0017m]3)\u0007\u0001\u0011\t\f\u0005\u0003\u00034\neVB\u0001B[\u0015\u0011\u00119,!\u0003\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003<\nU&AC\"p]R\u0014x\u000e\u001c7fe\":\u0001Aa0\u0002@\t\u0015\u0007\u0003BA\u0017\u0005\u0003LAAa1\u00020\tA1i\u001c8tk6,7\u000f\f\u0002\u0003H\u0006\u0012!\u0011Z\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:Ds\u0001\u0001Bg\u0003\u007f\u0011\u0019\u000e\u0005\u0003\u0002.\t=\u0017\u0002\u0002Bi\u0003_\u0011\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u0005\u000fDs\u0001AA\u0016\u0003\u007f\u00119.\t\u0002\u0003Z\u0006YqF^3sg&|g.\u001b8h\u0001")
public class TemplateVersioningResource
implements Logging {
    private final DslExporter dslExporter;
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateStorageService templateStorageService;
    private final ReleaseActorService releaseActorService;
    private final PermissionChecker permissionChecker;
    private final ReleaseService releaseService;
    private final ConfigurationRepository configurationRepository;
    private final ScmTemplateStorageService templateStorageListener;
    private final ScmConnectorService scmConnectorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateVersioningResource templateVersioningResource = this;
        synchronized (templateVersioningResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/settings")
    public TemplateVersioningSettings getTemplateVersionoingSettings() {
        return (TemplateVersioningSettings)this.configurationRepository.read(TemplateVersioningSettings$.MODULE$.TEMPLATE_VERSIONING_ID());
    }

    @GET
    @Path(value="{templateId:.*Release[^/-]*}/connectionInfo")
    public Response connectionInfo(@PathParam(value="templateId") @IdParam String templateId) {
        String folderId = Ids.findFolderId((String)templateId);
        ScmConnectorConfig scmConfiguration = this.scmConnectorService.findScmConnectorConfig(folderId);
        return Response.ok((Object)scmConfiguration).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response getRevisions(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissionChecker.checkView(templateId);
        List<TemplateRevision> templateRevisions = this.templateRevisionRepository.find(templateId, new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        GenericEntity<List<TemplateRevision>> entity = new GenericEntity<List<TemplateRevision>>(null, templateRevisions){};
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/content")
    public Response getRevisionContent(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkView(templateId);
        Release template = this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        return Response.ok((Object)this.getTemplateAsDsl(template), (String)"text/plain").build();
    }

    @POST
    @Path(value="/{templateId:.*Release[^/-]*}/versions")
    public Response createVersion(@PathParam(value="templateId") @IdParam String templateId, VersionView versionView) {
        Checks.checkArgument((boolean)this.releaseService.isTemplate(templateId), (String)"Snapshots can only be created for templates", (Object[])new Object[0]);
        this.permissionChecker.checkEdit(templateId);
        String user = Permissions.getAuthenticatedUserName();
        Try result = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.templateStorageListener.createNewVersion(templateId, versionView.name(), versionView.description(), user)).map((Function1 & Serializable)tagName -> {
            Try r = (Try)$this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.NewTemplateVersion((String)tagName, versionView.description(), user));
            return new Tuple2(tagName, (Object)r);
        }).map((Function1 & Serializable)x$1 -> {
            Try try_;
            Try r;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null || (r = (Try)tuple2._2()) == null) {
                throw new MatchError((Object)tuple2);
            }
            Try try_2 = try_ = r;
            return try_2;
        });
        return Response.ok((Object)result.fold((Function1 & Serializable)x0$1 -> {
            CreateVersionResponse createVersionResponse;
            Throwable throwable = x0$1;
            if (throwable instanceof ScmException) {
                ScmException scmException = (ScmException)throwable;
                String msg = scmException.msg();
                int statusCode = scmException.statusCode();
                this.logger().warn((Function0 & Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable)() -> scmException);
                createVersionResponse = new CreateVersionResponse(false, msg, statusCode);
            } else if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().warn((Function0 & Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable)() -> throwable2);
                createVersionResponse = new CreateVersionResponse(false, throwable2.getMessage(), 500);
            } else {
                throw new MatchError((Object)throwable);
            }
            return createVersionResponse;
        }, (Function1 & Serializable)id -> new CreateVersionResponse(true, id.toString(), CreateVersionResponse$.MODULE$.$lessinit$greater$default$3()))).build();
    }

    @PUT
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/restore")
    public Response restoreRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, templateId);
        this.permissionChecker.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, templateId);
        this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.RestoreRevision(revisionId));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}")
    public Response deleteRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevision(templateId, revisionId);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response deleteRevisions(@PathParam(value="templateId") @IdParam String templateId, List<Object> revisionIds) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevisions(templateId, (Seq<Object>)CollectionConverters$.MODULE$.ListHasAsScala(revisionIds).asScala().toSeq());
        return Response.ok().build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/compare")
    public TemplateContentAndPrevious compare(@PathParam(value="templateId") @IdParam String templateId, @DefaultValue(value="0") @QueryParam(value="revisionId") int revisionId, @DefaultValue(value="0") @QueryParam(value="toRevisionId") int toRevisionId) {
        this.permissionChecker.checkView(templateId);
        Release revision = revisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        Release toRevision = toRevisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(toRevisionId, this.getResolutionContext(templateId));
        return new TemplateContentAndPrevious(this.getTemplateAsDsl(revision), this.getTemplateAsDsl(toRevision));
    }

    private ResolutionContext getResolutionContext(String templateId) {
        return Ids.isInFolder((String)templateId) ? ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId)) : ResolutionContext$.MODULE$.GLOBAL();
    }

    private String getTemplateAsDsl(Release template) {
        return this.dslExporter.exportTemplate(template, this.dslExporter.exportTemplate$default$2());
    }

    @Autowired
    public TemplateVersioningResource(DslExporter dslExporter, TemplateRevisionRepository templateRevisionRepository, TemplateStorageService templateStorageService, ReleaseActorService releaseActorService, PermissionChecker permissionChecker, ReleaseService releaseService, ConfigurationRepository configurationRepository, ScmTemplateStorageService templateStorageListener, ScmConnectorService scmConnectorService) {
        this.dslExporter = dslExporter;
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateStorageService = templateStorageService;
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
        this.releaseService = releaseService;
        this.configurationRepository = configurationRepository;
        this.templateStorageListener = templateStorageListener;
        this.scmConnectorService = scmConnectorService;
        Logging.$init$((Logging)this);
    }
}

