/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class IgnoreUrlFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(IgnoreUrlFilter.class);
    private static final Supplier<Stream<String>> IGNORED_URLS = () -> Stream.of("angular-gantt.js.map", "ctrl.frameSrc");

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            String requestURI = ((HttpServletRequest)request).getRequestURI();
            if (IGNORED_URLS.get().anyMatch(requestURI::contains)) {
                LOG.debug("Request to [{}] has been ignored", new Object[]{requestURI});
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

