import React from 'react';
import { mount } from 'enzyme/build';
import { DisplayDateComponent } from './display-date.component';
import { formatDateTime } from '../../utils';

describe('DisplayDateComponent', () => {
    test('should render date with default format', () => {
        const date = 1557753584147;
        const displayDateComponent = mount(<DisplayDateComponent date={date} />);
        expect(displayDateComponent.find('span').text()).toContain(formatDateTime(date, 'YYYY-MM-DD', 'h:mm A'));
    });

    test('should render date with link to calendar', () => {
        const date = 1557758090673;
        const displayDateComponent = mount(<DisplayDateComponent date={date} isLink={true} />);
        const dateLink = displayDateComponent.find('a');
        expect(dateLink.text()).toContain(formatDateTime(date, 'YYYY-MM-DD', 'h:mm A'));
        expect(dateLink.prop('href')).toBe('#/calendar?has_filter&date=2019-05-13');
    });

    test('should render date with custom format', () => {
        const date = 1557777725636;
        const displayDateComponent = mount(<DisplayDateComponent date={date} dateFormat="YYYY-MM-DD" />);
        const displayDateWithLinkComponent = mount(<DisplayDateComponent date={date} dateFormat="YYYY-MM-DD" isLink={true} timeFormat={''} />);
        expect(displayDateComponent.find('span').text()).toContain('2019-05-13');
        expect(displayDateWithLinkComponent.find('a').text()).toContain('2019-05-13');
    });

    test('should render styled date', () => {
        const date = 1557778011893;
        const displayDateComponent = mount(<DisplayDateComponent color="red" date={date} />);
        const displayDateLinkComponent = mount(<DisplayDateComponent color="red" date={date} isLink={true} />);
        expect(displayDateComponent.prop('color')).toBe('red');
        expect(displayDateLinkComponent.prop('color')).toBe('red');
        expect(displayDateComponent.find('span').prop('style')).toHaveProperty('color', 'red');
        expect(displayDateLinkComponent.find('a').prop('style')).toHaveProperty('color', 'red');
    });
});
