import React, { Component } from 'react';
import PropTypes from 'prop-types';

export class InfiniteListBodyComponent extends Component {
    static propTypes = {
        loadMore: PropTypes.func.isRequired,
        onScrollList: PropTypes.func,
        renderRow: PropTypes.func.isRequired,
        rows: PropTypes.arrayOf(PropTypes.any).isRequired,
        selectedRows: PropTypes.arrayOf(PropTypes.string).isRequired,
        toggleSelectedRows: PropTypes.func.isRequired,
    };

    constructor(props) {
        super(props);
        this.rowsRef = React.createRef();
    }

    componentDidMount() {
        this.rowsRef.current.addEventListener('scroll', this.loadMore);
        this.loadMore();
    }

    componentWillUnmount() {
        this.rowsRef.current.removeEventListener('scroll', this.loadMore);
    }

    loadMore = () => {
        const rowsRef = this.rowsRef.current;
        if (rowsRef.scrollTop + rowsRef.clientHeight >= rowsRef.scrollHeight) {
            this.props.loadMore();
        }
    };

    renderRow(row) {
        return (
            <span className="list-row-view-container" key={row.id}>
                <input checked={this.props.selectedRows.includes(row.id)} onChange={() => this.props.toggleSelectedRows([row])} type="checkbox" />
                {this.props.renderRow(row)}
            </span>
        );
    }

    render() {
        const { rows, onScrollList } = this.props;
        return (
            <div className="list-view-rows" onScroll={onScrollList} ref={this.rowsRef}>
                {rows.map((row) => this.renderRow(row))}
            </div>
        );
    }
}
