import React from 'react';
import { Dropdown } from './dropdown.component';
import { mountWithTheme } from '../../../../tests/unit/testing-utils';

describe('Dropdown', () => {
    const mountComponentWithTheme = (props) => mountWithTheme(<Dropdown {...props} />);

    it('should create button with text', () => {
        const wrapper = mountComponentWithTheme({ maxVisibleItems: 10, menuItems: [], text: 'my button' });

        const dropdownButton = wrapper.find('button');
        expect(dropdownButton).toIncludeText('my button');
    });

    describe('menu', () => {
        const menuItems = [
            { children: 'first', key: 'first' },
            { children: 'second', key: 'second' },
        ];

        let wrapper = undefined;
        let dropdownButton = undefined;

        const selectDropDownMenuItems = () => wrapper.find('.dot-menu ul li');
        const selectDownIcon = () => wrapper.find('.dot-icon .icon-arrow-down');
        const selectUpIcon = () => wrapper.find('.dot-icon .icon-arrow-up');

        beforeEach(() => {
            wrapper = mountComponentWithTheme({ maxVisibleItems: 10, menuItems, text: 'my button' });
            dropdownButton = wrapper.find('button');
        });

        it('should change icon when opening and closing', () => {
            expect(selectDownIcon()).toExist();
            expect(selectUpIcon()).not.toExist();
            dropdownButton.simulate('click');
            expect(selectUpIcon()).toExist();
            expect(selectDownIcon()).not.toExist();
            dropdownButton.simulate('click');
            expect(selectDownIcon()).toExist();
            expect(selectUpIcon()).not.toExist();
        });

        it('should open menu onclick and show menu items', () => {
            expect(selectDropDownMenuItems()).not.toExist();
            dropdownButton.simulate('click');
            expect(selectDropDownMenuItems()).toHaveLength(2);
        });
    });
});
