/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.ddata;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Scheduler;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ddata.DurableStore;
import akka.cluster.ddata.DurableStore$LoadAll$;
import akka.cluster.ddata.DurableStore$LoadAllCompleted$;
import akka.cluster.ddata.LmdbDurableStore$;
import akka.cluster.ddata.LmdbDurableStore$WriteBehind$;
import akka.cluster.ddata.Replicator$Internal$DeletedData$;
import akka.event.LoggingAdapter;
import akka.io.DirectByteBufferPool$;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.SerializerWithStringManifest;
import akka.util.ByteString$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.ccompat.package;
import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.lmdbjava.CursorIterator;
import org.lmdbjava.Dbi;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.Env;
import org.lmdbjava.EnvFlags;
import org.lmdbjava.PutFlags;
import org.lmdbjava.Txn;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015s!\u0002&L\u0011\u0003\u0011f!\u0002+L\u0011\u0003)\u0006\"\u0002/\u0002\t\u0003i\u0006\"\u00020\u0002\t\u0003yv!B9\u0002\u0011\u0013\u0013h!\u0002;\u0002\u0011\u0013+\bB\u0002/\u0006\t\u0003\t\t\u0002C\u0005\u0002\u0014\u0015\t\t\u0011\"\u0011\u0002\u0016!I\u0011qE\u0003\u0002\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0003c)\u0011\u0011!C\u0001\u0003gA\u0011\"a\u0010\u0006\u0003\u0003%\t%!\u0011\t\u0013\u0005=S!!A\u0005\u0002\u0005E\u0003\"CA.\u000b\u0005\u0005I\u0011IA/\u0011%\ty&BA\u0001\n\u0003\n\t\u0007C\u0005\u0002d\u0015\t\t\u0011\"\u0003\u0002f\u00191\u0011QN\u0001G\u0003_B!\"!\u001d\u0010\u0005+\u0007I\u0011AA:\u0011)\t\tj\u0004B\tB\u0003%\u0011Q\u000f\u0005\u000b\u0003'{!Q3A\u0005\u0002\u0005U\u0005BCAO\u001f\tE\t\u0015!\u0003\u0002\u0018\"Q\u0011qT\b\u0003\u0016\u0004%\t!!)\t\u0015\u0005\rvB!E!\u0002\u0013\t)\t\u0003\u0006\u0002&>\u0011)\u001a!C\u0001\u0003CC!\"a*\u0010\u0005#\u0005\u000b\u0011BAC\u0011\u0019av\u0002\"\u0001\u0002*\"I\u0011QW\b\u0002\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003\u0003|\u0011\u0013!C\u0001\u0003\u0007D\u0011\"!7\u0010#\u0003%\t!a7\t\u0013\u0005}w\"%A\u0005\u0002\u0005\u0005\b\"CAs\u001fE\u0005I\u0011AAq\u0011%\t\u0019bDA\u0001\n\u0003\n)\u0002C\u0005\u0002(=\t\t\u0011\"\u0001\u0002*!I\u0011\u0011G\b\u0002\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003\u007fy\u0011\u0011!C!\u0003\u0003B\u0011\"a\u0014\u0010\u0003\u0003%\t!a;\t\u0013\u0005=x\"!A\u0005B\u0005E\b\"CA.\u001f\u0005\u0005I\u0011IA/\u0011%\tyfDA\u0001\n\u0003\n\t\u0007C\u0005\u0002v>\t\t\u0011\"\u0011\u0002x\u001eI\u00111`\u0001\u0002\u0002#%\u0011Q \u0004\n\u0003[\n\u0011\u0011!E\u0005\u0003\u007fDa\u0001\u0018\u0015\u0005\u0002\t]\u0001\"CA0Q\u0005\u0005IQIA1\u0011%\u0011I\u0002KA\u0001\n\u0003\u0013Y\u0002C\u0005\u0003&!\n\t\u0011\"!\u0003(!I\u00111\r\u0015\u0002\u0002\u0013%\u0011Q\r\u0004\u0006).\u0013!\u0011\b\u0005\tO:\u0012\t\u0011)A\u0005Q\"1AL\fC\u0001\u0005\u000fB\u0011B!\u0014/\u0005\u0004%\tAa\u0014\t\u0011\tmc\u0006)A\u0005\u0005#B\u0011B!\u0018/\u0005\u0004%\tAa\u0018\t\u0011\t\u001dd\u0006)A\u0005\u0005CB\u0011B!\u001b/\u0005\u0004%\tAa\u001b\t\u0011\tmd\u0006)A\u0005\u0005[B\u0011B! /\u0005\u0004%\tAa \t\u0011\tEe\u0006)A\u0005\u0005\u0003C\u0011Ba%/\u0005\u0004%\tA!&\t\u0011\tue\u0006)A\u0005\u0005/C\u0011Ba(/\u0001\u0004%IA!)\t\u0013\tMf\u00061A\u0005\n\tU\u0006\u0002\u0003B`]\u0001\u0006KAa)\t\u000f\t\u0005g\u0006\"\u0003\u0003D\"9!Q\u0019\u0018\u0005\u0002\t\u001d\u0007b\u0002Be]\u0011\u0005!1\u001a\u0005\n\u0005#t#\u0019!C\u0001\u0005'D\u0001ba\u0002/A\u0003%!Q\u001b\u0005\b\u0007\u0013qC\u0011IB\u0006\u0011\u001d\u00199B\fC!\u00073Aqaa\u0007/\t\u0003\u0019i\u0002C\u0004\u0004(9\"\ta!\b\t\u000f\r%b\u0006\"\u0001\u0004\u001e!911\u0006\u0018\u0005\u0002\r5\u0002bBB\"]\u0011\u00051\u0011D\u0001\u0011\u00196$'\rR;sC\ndWm\u0015;pe\u0016T!\u0001T'\u0002\u000b\u0011$\u0017\r^1\u000b\u00059{\u0015aB2mkN$XM\u001d\u0006\u0002!\u0006!\u0011m[6b\u0007\u0001\u0001\"aU\u0001\u000e\u0003-\u0013\u0001\u0003T7eE\u0012+(/\u00192mKN#xN]3\u0014\u0005\u00051\u0006CA,[\u001b\u0005A&\"A-\u0002\u000bM\u001c\u0017\r\\1\n\u0005mC&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002%\u0006)\u0001O]8qgR\u0011\u0001M\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G>\u000bQ!Y2u_JL!!\u001a2\u0003\u000bA\u0013x\u000e]:\t\u000b\u001d\u001c\u0001\u0019\u00015\u0002\r\r|gNZ5h!\tIw.D\u0001k\u0015\t97N\u0003\u0002m[\u0006AA/\u001f9fg\u00064WMC\u0001o\u0003\r\u0019w.\\\u0005\u0003a*\u0014aaQ8oM&<\u0017aC,sSR,')\u001a5j]\u0012\u0004\"a]\u0003\u000e\u0003\u0005\u00111b\u0016:ji\u0016\u0014U\r[5oIN)QA\u0016<zyB\u0011\u0011m^\u0005\u0003q\n\u0014Q\u0003R3bI2+G\u000f^3s'V\u0004\bO]3tg&|g\u000e\u0005\u0002Xu&\u00111\u0010\u0017\u0002\b!J|G-^2u!\ri\u00181\u0002\b\u0004}\u0006\u001dabA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007\t\u0016A\u0002\u001fs_>$h(C\u0001Z\u0013\r\tI\u0001W\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti!a\u0004\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005%\u0001\fF\u0001s\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006LA!!\n\u0002\u001c\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000b\u0011\u0007]\u000bi#C\u0002\u00020a\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000e\u0002<A\u0019q+a\u000e\n\u0007\u0005e\u0002LA\u0002B]fD\u0011\"!\u0010\n\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0005\u0005\u0004\u0002F\u0005-\u0013QG\u0007\u0003\u0003\u000fR1!!\u0013Y\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\n9E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA*\u00033\u00022aVA+\u0013\r\t9\u0006\u0017\u0002\b\u0005>|G.Z1o\u0011%\tidCA\u0001\u0002\u0004\t)$\u0001\u0005iCND7i\u001c3f)\t\tY#\u0001\u0005u_N#(/\u001b8h)\t\t9\"\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002hA!\u0011\u0011DA5\u0013\u0011\tY'a\u0007\u0003\r=\u0013'.Z2u\u0005\u0011aU\u000e\u001a2\u0014\t=1\u0016\u0010`\u0001\u0004K:4XCAA;!\u0019\t9(!!\u0002\u00066\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0005m[\u0012\u0014'.\u0019<b\u0015\t\ty(A\u0002pe\u001eLA!a!\u0002z\t\u0019QI\u001c<\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013SA!a#\u0002 \u0005\u0019a.[8\n\t\u0005=\u0015\u0011\u0012\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018\u0001B3om\u0002\n!\u0001\u001a2\u0016\u0005\u0005]\u0005CBA<\u00033\u000b))\u0003\u0003\u0002\u001c\u0006e$a\u0001#cS\u0006\u0019AM\u0019\u0011\u0002\u0013-,\u0017PQ;gM\u0016\u0014XCAAC\u0003)YW-\u001f\"vM\u001a,'\u000fI\u0001\fm\u0006dW/\u001a\"vM\u001a,'/\u0001\u0007wC2,XMQ;gM\u0016\u0014\b\u0005\u0006\u0006\u0002,\u00065\u0016qVAY\u0003g\u0003\"a]\b\t\u000f\u0005E\u0004\u00041\u0001\u0002v!9\u00111\u0013\rA\u0002\u0005]\u0005bBAP1\u0001\u0007\u0011Q\u0011\u0005\b\u0003KC\u0002\u0019AAC\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005-\u0016\u0011XA^\u0003{\u000by\fC\u0005\u0002re\u0001\n\u00111\u0001\u0002v!I\u00111S\r\u0011\u0002\u0003\u0007\u0011q\u0013\u0005\n\u0003?K\u0002\u0013!a\u0001\u0003\u000bC\u0011\"!*\u001a!\u0003\u0005\r!!\"\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0019\u0016\u0005\u0003k\n9m\u000b\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!C;oG\",7m[3e\u0015\r\t\u0019\u000eW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAl\u0003\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!8+\t\u0005]\u0015qY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019O\u000b\u0003\u0002\u0006\u0006\u001d\u0017AD2paf$C-\u001a4bk2$H\u0005\u000e\u000b\u0005\u0003k\tI\u000fC\u0005\u0002>\u0001\n\t\u00111\u0001\u0002,Q!\u00111KAw\u0011%\tiDIA\u0001\u0002\u0004\t)$\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\f\u0003gD\u0011\"!\u0010$\u0003\u0003\u0005\r!a\u000b\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019&!?\t\u0013\u0005ub%!AA\u0002\u0005U\u0012\u0001\u0002'nI\n\u0004\"a\u001d\u0015\u0014\u000b!\u0012\tA!\u0004\u0011\u001d\t\r!\u0011BA;\u0003/\u000b))!\"\u0002,6\u0011!Q\u0001\u0006\u0004\u0005\u000fA\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u0017\u0011)AA\tBEN$(/Y2u\rVt7\r^5p]R\u0002BAa\u0004\u0003\u00165\u0011!\u0011\u0003\u0006\u0005\u0005'\ty\"\u0001\u0002j_&!\u0011Q\u0002B\t)\t\ti0A\u0003baBd\u0017\u0010\u0006\u0006\u0002,\nu!q\u0004B\u0011\u0005GAq!!\u001d,\u0001\u0004\t)\bC\u0004\u0002\u0014.\u0002\r!a&\t\u000f\u0005}5\u00061\u0001\u0002\u0006\"9\u0011QU\u0016A\u0002\u0005\u0015\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005S\u0011)\u0004E\u0003X\u0005W\u0011y#C\u0002\u0003.a\u0013aa\u00149uS>t\u0007cC,\u00032\u0005U\u0014qSAC\u0003\u000bK1Aa\rY\u0005\u0019!V\u000f\u001d7fi!I!q\u0007\u0017\u0002\u0002\u0003\u0007\u00111V\u0001\u0004q\u0012\u00024C\u0002\u0018W\u0005w\u0011\t\u0005E\u0002b\u0005{I1Aa\u0010c\u0005\u0015\t5\r^8s!\r\t'1I\u0005\u0004\u0005\u000b\u0012'\u0001D!di>\u0014Hj\\4hS:<G\u0003\u0002B%\u0005\u0017\u0002\"a\u0015\u0018\t\u000b\u001d\u0004\u0004\u0019\u00015\u0002\u001bM,'/[1mSj\fG/[8o+\t\u0011\t\u0006\u0005\u0003\u0003T\t]SB\u0001B+\u0015\r\u0011ieT\u0005\u0005\u00053\u0012)FA\u0007TKJL\u0017\r\\5{CRLwN\\\u0001\u000fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8!\u0003)\u0019XM]5bY&TXM]\u000b\u0003\u0005C\u0002BAa\u0015\u0003d%!!Q\rB+\u0005q\u0019VM]5bY&TXM],ji\"\u001cFO]5oO6\u000bg.\u001b4fgR\f1b]3sS\u0006d\u0017N_3sA\u0005AQ.\u00198jM\u0016\u001cH/\u0006\u0002\u0003nA!!q\u000eB<\u001d\u0011\u0011\tHa\u001d\u0011\u0005}D\u0016b\u0001B;1\u00061\u0001K]3eK\u001aLA!!\n\u0003z)\u0019!Q\u000f-\u0002\u00135\fg.\u001b4fgR\u0004\u0013aE<sSR,')\u001a5j]\u0012Le\u000e^3sm\u0006dWC\u0001BA!\u0011\u0011\u0019I!$\u000e\u0005\t\u0015%\u0002\u0002BD\u0005\u0013\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0005\u0017C\u0016AC2p]\u000e,(O]3oi&!!q\u0012BC\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fAc\u001e:ji\u0016\u0014U\r[5oI&sG/\u001a:wC2\u0004\u0013a\u00013jeV\u0011!q\u0013\t\u0005\u0005\u001f\u0011I*\u0003\u0003\u0003\u001c\nE!\u0001\u0002$jY\u0016\fA\u0001Z5sA\u0005)q\f\\7eEV\u0011!1\u0015\t\u0007\u0005K\u0013YKa,\u000e\u0005\t\u001d&b\u0001BU\u001f\u0006!Q\u000f^5m\u0013\u0011\u0011iKa*\u0003\u0013=\u0003H/[8o-\u0006d\u0007c\u0001BY\u001f9\u00111\u000bA\u0001\n?2lGMY0%KF$BAa.\u0003>B\u0019qK!/\n\u0007\tm\u0006L\u0001\u0003V]&$\b\"CA\u001fy\u0005\u0005\t\u0019\u0001BR\u0003\u0019yF.\u001c3cA\u0005!A.\u001c3c)\t\u0011y+A\bjg\u0012\u0013\u0017J\\5uS\u0006d\u0017N_3e+\t\t\u0019&A\u000bf]N,(/\u001a,bYV,')\u001e4gKJ\u001c\u0016N_3\u0015\t\t]&Q\u001a\u0005\b\u0005\u001f\u0004\u0005\u0019AA\u0016\u0003\u0011\u0019\u0018N_3\u0002\u000fA,g\u000eZ5oOV\u0011!Q\u001b\t\t\u0005/\u0014YNa8\u0003z6\u0011!\u0011\u001c\u0006\u0005\u0005S\u000by\"\u0003\u0003\u0003^\ne'a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0005C\u0014\u0019P\u0004\u0003\u0003d\n=h\u0002\u0002Bs\u0005[tAAa:\u0003l:\u0019qP!;\n\u0003AK!AT(\n\u00051k\u0015b\u0001By\u0017\u0006\u00191*Z=\n\t\tU(q\u001f\u0002\u0006\u0017\u0016L\u0018\n\u001a\u0006\u0004\u0005c\\\u0005\u0003\u0002B~\u0007\u0003q1a\u0015B\u007f\u0013\r\u0011ypS\u0001\r\tV\u0014\u0018M\u00197f'R|'/Z\u0005\u0005\u0007\u0007\u0019)AA\nEkJ\f'\r\\3ECR\fWI\u001c<fY>\u0004XMC\u0002\u0003\u0000.\u000b\u0001\u0002]3oI&tw\rI\u0001\fa>\u001cHOU3ti\u0006\u0014H\u000f\u0006\u0003\u00038\u000e5\u0001bBB\b\u0007\u0002\u00071\u0011C\u0001\u0007e\u0016\f7o\u001c8\u0011\u0007u\u001c\u0019\"\u0003\u0003\u0004\u0016\u0005=!!\u0003+ie><\u0018M\u00197f\u0003!\u0001xn\u001d;Ti>\u0004HC\u0001B\\\u0003\u001d\u0011XmY3jm\u0016,\"aa\b\u0011\t\r\u000521E\u0007\u0002]%!1Q\u0005B\u001f\u0005\u001d\u0011VmY3jm\u0016\fA!\u001b8ji\u00061\u0011m\u0019;jm\u0016\fQ\u0001\u001a2QkR$\u0002Ba.\u00040\rm2q\b\u0005\b\u0007cA\u0005\u0019AB\u001a\u0003\t!\b\u0010\u0005\u0004\u0003&\n-6Q\u0007\t\u0007\u0003o\u001a9$!\"\n\t\re\u0012\u0011\u0010\u0002\u0004)bt\u0007bBB\u001f\u0011\u0002\u0007!q\\\u0001\u0004W\u0016L\bbBB!\u0011\u0002\u0007!\u0011`\u0001\u0005I\u0006$\u0018-A\u0006xe&$XMQ3iS:$\u0007")
public final class LmdbDurableStore
implements Actor,
ActorLogging {
    private final Config config;
    private final Serialization serialization;
    private final SerializerWithStringManifest serializer;
    private final String manifest;
    private final FiniteDuration writeBehindInterval;
    private final File dir;
    private Lmdb _lmdb;
    private final HashMap<String, DurableStore.DurableDataEnvelope> pending;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    public static Props props(Config config) {
        return LmdbDurableStore$.MODULE$.props(config);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Serialization serialization() {
        return this.serialization;
    }

    public SerializerWithStringManifest serializer() {
        return this.serializer;
    }

    public String manifest() {
        return this.manifest;
    }

    public FiniteDuration writeBehindInterval() {
        return this.writeBehindInterval;
    }

    public File dir() {
        return this.dir;
    }

    private Lmdb _lmdb() {
        return this._lmdb;
    }

    private void _lmdb_$eq(Lmdb x$1) {
        this._lmdb = x$1;
    }

    public Lmdb akka$cluster$ddata$LmdbDurableStore$$lmdb() {
        Lmdb lmdb;
        Lmdb lmdb2 = this._lmdb();
        Lmdb lmdb3 = (Lmdb)OptionVal.Some$.MODULE$.unapply((Object)lmdb2);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)lmdb3)) {
            Lmdb l;
            lmdb = l = (Lmdb)OptionVal$.MODULE$.get$extension((Object)lmdb3);
        } else {
            long t0 = System.nanoTime();
            this.log().info("Using durable data in LMDB directory [{}]", (Object)this.dir().getCanonicalPath());
            Long mapSize = this.config.getBytes("lmdb.map-size");
            this.dir().mkdirs();
            Env env = Env.create().setMapSize(Predef$.MODULE$.Long2long(mapSize)).setMaxDbs(1).open(this.dir(), new EnvFlags[]{EnvFlags.MDB_NOLOCK});
            Dbi db = env.openDbi("ddata", new DbiFlags[]{DbiFlags.MDB_CREATE});
            ByteBuffer keyBuffer = ByteBuffer.allocateDirect(env.getMaxKeySize());
            ByteBuffer valueBuffer = ByteBuffer.allocateDirect(102400);
            if (this.log().isDebugEnabled()) {
                this.log().debug("Init of LMDB in directory [{}] took [{} ms]", (Object)this.dir().getCanonicalPath(), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
            }
            Lmdb l = new Lmdb((Env<ByteBuffer>)env, (Dbi<ByteBuffer>)db, keyBuffer, valueBuffer);
            this._lmdb_$eq((Lmdb)OptionVal.Some$.MODULE$.apply((Object)l));
            lmdb = l;
        }
        return lmdb;
    }

    public boolean isDbInitialized() {
        return OptionVal$.MODULE$.isDefined$extension((Object)this._lmdb());
    }

    public void ensureValueBufferSize(int size) {
        block0: {
            ByteBuffer valueBuffer = this.akka$cluster$ddata$LmdbDurableStore$$lmdb().valueBuffer();
            if (valueBuffer.remaining() >= size) break block0;
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(valueBuffer);
            Lmdb qual$1 = this.akka$cluster$ddata$LmdbDurableStore$$lmdb();
            ByteBuffer x$1 = ByteBuffer.allocateDirect(size * 2);
            Env<ByteBuffer> x$2 = qual$1.copy$default$1();
            Dbi<ByteBuffer> x$3 = qual$1.copy$default$2();
            ByteBuffer x$4 = qual$1.copy$default$3();
            this._lmdb_$eq((Lmdb)OptionVal.Some$.MODULE$.apply((Object)qual$1.copy(x$2, x$3, x$4, x$1)));
        }
    }

    public HashMap<String, DurableStore.DurableDataEnvelope> pending() {
        return this.pending;
    }

    public void postRestart(Throwable reason) {
        Actor.postRestart$((Actor)this, (Throwable)reason);
        this.context().become(this.active());
    }

    public void postStop() {
        block0: {
            Actor.postStop$((Actor)this);
            this.writeBehind();
            if (!this.isDbInitialized()) break block0;
            Lmdb l = this.akka$cluster$ddata$LmdbDurableStore$$lmdb();
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> l.db().close());
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> l.env().close());
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.keyBuffer());
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.valueBuffer());
        }
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.init();
    }

    public PartialFunction<Object, BoxedUnit> init() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ LmdbDurableStore $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (DurableStore$LoadAll$.MODULE$.equals(A1)) {
                    BoxedUnit boxedUnit;
                    block14: {
                        if (this.$outer.dir().exists() && this.$outer.dir().list().length > 0) {
                            Lmdb l = this.$outer.akka$cluster$ddata$LmdbDurableStore$$lmdb();
                            long t0 = System.nanoTime();
                            Txn tx = l.env().txnRead();
                            try {
                                try {
                                    CursorIterator iter = l.db().iterate(tx);
                                    try {
                                        IntRef n = IntRef.create((int)0);
                                        DurableStore.LoadData loadData = new DurableStore.LoadData((Map<String, DurableStore.DurableDataEnvelope>)package.JavaConverters$.MODULE$.IteratorHasAsScala((java.util.Iterator)iter).asScala().map((Function1 & Serializable)entry -> {
                                            ++n$1.elem;
                                            byte[] keyArray = new byte[((Buffer)entry.key()).remaining()];
                                            ((ByteBuffer)entry.key()).get(keyArray);
                                            String key = new String(keyArray, ByteString$.MODULE$.UTF_8());
                                            byte[] valArray = new byte[((Buffer)entry.val()).remaining()];
                                            ((ByteBuffer)entry.val()).get(valArray);
                                            DurableStore.DurableDataEnvelope envelope = (DurableStore.DurableDataEnvelope)$this.$outer.serializer().fromBinary(valArray, $this.$outer.manifest());
                                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)envelope);
                                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                                        if (loadData.data().nonEmpty()) {
                                            this.$outer.sender().$bang((Object)loadData, this.$outer.self());
                                        }
                                        this.$outer.sender().$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                                        if (this.$outer.log().isDebugEnabled()) {
                                            this.$outer.log().debug("load all of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)n.elem), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                                        }
                                        this.$outer.context().become(this.$outer.active());
                                        boxedUnit = BoxedUnit.UNIT;
                                        break block14;
                                    }
                                    finally {
                                        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> iter.close());
                                    }
                                }
                                catch (Throwable throwable) {
                                    Option option;
                                    Throwable throwable2 = throwable;
                                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        throw new DurableStore.LoadFailed("failed to load durable distributed-data", e);
                                    }
                                    throw throwable;
                                }
                            }
                            finally {
                                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> tx.close());
                            }
                        }
                        this.$outer.sender().$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                        this.$outer.context().become(this.$outer.active());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = DurableStore$LoadAll$.MODULE$.equals(object);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.cluster.ddata.LmdbDurableStore$$anonfun$init$1 scala.runtime.IntRef org.lmdbjava.CursorIterator$KeyVal ), $anonfun$applyOrElse$2(org.lmdbjava.CursorIterator ), $anonfun$applyOrElse$3(org.lmdbjava.Txn )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ LmdbDurableStore $outer;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_36;
                A1 A1 = x1;
                if (A1 instanceof DurableStore.Store) {
                    BoxedUnit boxedUnit;
                    DurableStore.Store store = (DurableStore.Store)A1;
                    String key = store.key();
                    DurableStore.DurableDataEnvelope data = store.data();
                    Option<DurableStore.StoreReply> reply = store.reply();
                    try {
                        Some some;
                        DurableStore.StoreReply storeReply;
                        Object object;
                        this.$outer.akka$cluster$ddata$LmdbDurableStore$$lmdb();
                        if (this.$outer.writeBehindInterval().length() == 0L) {
                            OptionVal$.MODULE$.None();
                            this.$outer.dbPut(null, key, data);
                            object = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit2;
                            if (this.$outer.pending().isEmpty()) {
                                Scheduler qual$1 = this.$outer.context().system().scheduler();
                                FiniteDuration x$1 = this.$outer.writeBehindInterval();
                                ActorRef x$2 = this.$outer.self();
                                LmdbDurableStore$WriteBehind$ x$3 = LmdbDurableStore$WriteBehind$.MODULE$;
                                ExecutionContextExecutor x$4 = this.$outer.context().dispatcher();
                                ActorRef x$5 = qual$1.scheduleOnce$default$5(x$1, x$2, (Object)x$3);
                                boxedUnit2 = qual$1.scheduleOnce(x$1, x$2, (Object)x$3, (ExecutionContext)x$4, x$5);
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            object = this.$outer.pending().put(key, data);
                        }
                        Option<DurableStore.StoreReply> option = reply;
                        if (option instanceof Some && (storeReply = (DurableStore.StoreReply)(some = (Some)option).value()) != null) {
                            Object successMsg = storeReply.successMsg();
                            ActorRef replyTo = storeReply.replyTo();
                            replyTo.$bang(successMsg, this.$outer.self());
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Some some;
                        DurableStore.StoreReply storeReply;
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) throw throwable;
                        Throwable e = (Throwable)option.get();
                        this.$outer.log().error(e, "failed to store [{}]", (Object)key);
                        Option<DurableStore.StoreReply> option2 = reply;
                        if (option2 instanceof Some && (storeReply = (DurableStore.StoreReply)(some = (Some)option2).value()) != null) {
                            Object failureMsg = storeReply.failureMsg();
                            ActorRef replyTo = storeReply.replyTo();
                            replyTo.$bang(failureMsg, this.$outer.self());
                            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit8 = boxedUnit;
                    return var3_36;
                }
                if (LmdbDurableStore$WriteBehind$.MODULE$.equals(A1)) {
                    this.$outer.writeBehind();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var3_36;
                } else {
                    Object object = function1.apply(x1);
                }
                return var3_36;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DurableStore.Store ? true : LmdbDurableStore$WriteBehind$.MODULE$.equals(object);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void dbPut(Txn<ByteBuffer> tx, String key, DurableStore.DurableDataEnvelope data) {
        try {
            byte[] value = this.serializer().toBinary((Object)data);
            this.ensureValueBufferSize(value.length);
            Lmdb l = this.akka$cluster$ddata$LmdbDurableStore$$lmdb();
            l.keyBuffer().put(key.getBytes(ByteString$.MODULE$.UTF_8())).flip();
            l.valueBuffer().put(value).flip();
            Txn<ByteBuffer> txn = tx;
            Txn txn2 = (Txn)OptionVal.Some$.MODULE$.unapply(txn);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)txn2)) {
                Txn t = (Txn)OptionVal$.MODULE$.get$extension((Object)txn2);
                l.db().put(t, (Object)l.keyBuffer(), (Object)l.valueBuffer(), new PutFlags[0]);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                l.db().put((Object)l.keyBuffer(), (Object)l.valueBuffer());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        finally {
            Lmdb l = this.akka$cluster$ddata$LmdbDurableStore$$lmdb();
            l.keyBuffer().clear();
            l.valueBuffer().clear();
        }
    }

    public void writeBehind() {
        block9: {
            if (!this.pending().isEmpty()) {
                long t0 = System.nanoTime();
                Txn tx = this.akka$cluster$ddata$LmdbDurableStore$$lmdb().env().txnWrite();
                try {
                    try {
                        for (Map.Entry<String, DurableStore.DurableDataEnvelope> entry : this.pending().entrySet()) {
                            this.dbPut((Txn<ByteBuffer>)((Txn)OptionVal.Some$.MODULE$.apply((Object)tx)), entry.getKey(), entry.getValue());
                        }
                        tx.commit();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store and commit of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)this.pending().size()), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                        }
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.log().error(e, "failed to store [{}]", (Object)package.JavaConverters$.MODULE$.SetHasAsScala(this.pending().keySet()).asScala().mkString(","));
                            tx.abort();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.pending().clear();
                }
            }
        }
    }

    public LmdbDurableStore(Config config) {
        File file;
        FiniteDuration finiteDuration;
        block5: {
            this.config = config;
            Actor.$init$((Actor)this);
            ActorLogging.$init$((ActorLogging)this);
            this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
            this.serializer = (SerializerWithStringManifest)this.serialization().serializerFor(DurableStore.DurableDataEnvelope.class);
            this.manifest = this.serializer().manifest((Object)new DurableStore.DurableDataEnvelope(Replicator$Internal$DeletedData$.MODULE$));
            String string = config.getString("lmdb.write-behind-interval").toLowerCase();
            switch (string == null ? 0 : string.hashCode()) {
                case 109935: {
                    if (!"off".equals(string)) break;
                    finiteDuration = Duration$.MODULE$.Zero();
                    break block5;
                }
            }
            finiteDuration = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("lmdb.write-behind-interval", TimeUnit.MILLISECONDS))).millis();
        }
        this.writeBehindInterval = finiteDuration;
        String string = config.getString("lmdb.dir");
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        this.dir = file = string.endsWith("ddata") ? new File(new StringBuilder(3).append(string).append("-").append(this.context().system().name()).append("-").append(this.self().path().parent().name()).append("-").append(((Cluster)Cluster$.MODULE$.apply(this.context().system())).selfAddress().port().get()).toString()) : new File(string);
        OptionVal$.MODULE$.None();
        this._lmdb = null;
        this.pending = new HashMap();
        Statics.releaseFence();
    }

    private static final class Lmdb
    implements Product,
    Serializable {
        private final Env<ByteBuffer> env;
        private final Dbi<ByteBuffer> db;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Env<ByteBuffer> env() {
            return this.env;
        }

        public Dbi<ByteBuffer> db() {
            return this.db;
        }

        public ByteBuffer keyBuffer() {
            return this.keyBuffer;
        }

        public ByteBuffer valueBuffer() {
            return this.valueBuffer;
        }

        public Lmdb copy(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            return new Lmdb(env, db, keyBuffer, valueBuffer);
        }

        public Env<ByteBuffer> copy$default$1() {
            return this.env();
        }

        public Dbi<ByteBuffer> copy$default$2() {
            return this.db();
        }

        public ByteBuffer copy$default$3() {
            return this.keyBuffer();
        }

        public ByteBuffer copy$default$4() {
            return this.valueBuffer();
        }

        public String productPrefix() {
            return "Lmdb";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.env();
                    break;
                }
                case 1: {
                    object = this.db();
                    break;
                }
                case 2: {
                    object = this.keyBuffer();
                    break;
                }
                case 3: {
                    object = this.valueBuffer();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Lmdb;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "env";
                    break;
                }
                case 1: {
                    string = "db";
                    break;
                }
                case 2: {
                    string = "keyBuffer";
                    break;
                }
                case 3: {
                    string = "valueBuffer";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Lmdb)) return false;
            boolean bl = true;
            if (!bl) return false;
            Lmdb lmdb = (Lmdb)x$1;
            Env<ByteBuffer> env = this.env();
            Env<ByteBuffer> env2 = lmdb.env();
            if (env == null) {
                if (env2 != null) {
                    return false;
                }
            } else if (!env.equals(env2)) return false;
            Dbi<ByteBuffer> dbi = this.db();
            Dbi<ByteBuffer> dbi2 = lmdb.db();
            if (dbi == null) {
                if (dbi2 != null) {
                    return false;
                }
            } else if (!dbi.equals(dbi2)) return false;
            ByteBuffer byteBuffer = this.keyBuffer();
            ByteBuffer byteBuffer2 = lmdb.keyBuffer();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            ByteBuffer byteBuffer3 = this.valueBuffer();
            ByteBuffer byteBuffer4 = lmdb.valueBuffer();
            if (byteBuffer3 == null) {
                if (byteBuffer4 == null) return true;
                return false;
            } else {
                if (!((Object)byteBuffer3).equals(byteBuffer4)) return false;
                return true;
            }
        }

        public Lmdb(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            this.env = env;
            this.db = db;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
            Product.$init$((Product)this);
        }
    }
}

