/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.error;

import org.jparsec.ParseTree;
import org.jparsec.error.ErrorReporter;
import org.jparsec.error.Location;
import org.jparsec.error.ParseErrorDetails;

public class ParserException
extends RuntimeException {
    private final ParseErrorDetails error;
    private final Location location;
    private ParseTree parseTree = null;
    @Deprecated
    private final String module;

    public ParserException(ParseErrorDetails details, Location location) {
        this(details, null, location);
    }

    @Deprecated
    public ParserException(ParseErrorDetails details, String moduleName, Location location) {
        super(ParserException.toErrorMessage(null, moduleName, details, location));
        this.error = details;
        this.module = moduleName;
        this.location = location;
    }

    @Deprecated
    public ParserException(Throwable cause, ParseErrorDetails details, String moduleName, Location location) {
        super(ParserException.toErrorMessage(cause.getMessage(), moduleName, details, location), cause);
        this.error = details;
        this.location = location;
        this.module = moduleName;
    }

    public ParseErrorDetails getErrorDetails() {
        return this.error;
    }

    public ParseTree getParseTree() {
        return this.parseTree;
    }

    public void setParseTree(ParseTree parseTree) {
        this.parseTree = parseTree;
    }

    private static String toErrorMessage(String message, String module, ParseErrorDetails details, Location location) {
        StringBuilder buf = new StringBuilder();
        if (message != null && message.length() > 0) {
            buf.append(message).append('\n');
        }
        if (module != null) {
            buf.append('(').append(module).append(") ");
        }
        buf.append(ErrorReporter.toString(details, location));
        return buf.toString();
    }

    @Deprecated
    public String getModuleName() {
        return this.module;
    }

    @Deprecated
    public Location getLocation() {
        return this.location;
    }

    public final int getLine() {
        return this.location.line;
    }

    public final int getColumn() {
        return this.location.column;
    }
}

